/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.HashSet;
import org.scilab.forge.scirenderer.implementation.g2d.motor.BoundingBox;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public abstract class AbstractDrawable3DObject {
    public static final double PRECISION = 1.0E-8;
    private static int defaultPrecedence = 0;
    protected final Vector3d[] vertices;
    protected final Color[] colors;
    protected int precedence;
    protected Boolean is2d;
    protected Double zindex;
    protected Vector3d v0;
    protected Vector3d v1;
    protected Vector3d v0v1;
    protected double nv0v1;
    protected Vector3d normal;
    protected BoundingBox bbox;
    protected boolean marked;
    protected boolean marked2;
    protected Boolean degenerated;

    public AbstractDrawable3DObject(Vector3d[] vector3dArray, Color[] colorArray) throws InvalidPolygonException {
        if (vector3dArray == null || vector3dArray.length == 0) {
            throw new InvalidPolygonException("Invalid 3D Object: no vertices was givenl");
        }
        this.vertices = vector3dArray;
        this.colors = colorArray;
        if (this.isDegenerate()) {
            throw new InvalidPolygonException("Invalid 3D Object: two vertices are the same");
        }
        if (this.isNanOrInf()) {
            throw new InvalidPolygonException("Invalid 3D Object: contains NaN or Inf coordinates");
        }
        this.setPrecedence(defaultPrecedence++);
        this.getNormal();
    }

    final BoundingBox getBBox() {
        if (this.bbox == null) {
            this.bbox = BoundingBox.getBoundingBox(this);
        }
        return this.bbox;
    }

    public static boolean isMonochromatic(Color[] colorArray) {
        if (colorArray != null && colorArray.length > 0) {
            Color color = colorArray[0];
            for (int i = 1; i < colorArray.length; ++i) {
                if (color.equals(colorArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public abstract void draw(Graphics2D var1);

    public static void resetDefaultPrecedence() {
        defaultPrecedence = 0;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public boolean is2D() {
        if (this.is2d == null) {
            for (Vector3d vector3d : this.vertices) {
                if (vector3d.getZ() == 0.0) continue;
                this.is2d = Boolean.FALSE;
                return this.is2d;
            }
            this.is2d = Boolean.TRUE;
        }
        return this.is2d;
    }

    public Vector3d getProvidedNormal() {
        return this.normal;
    }

    public Vector3d getNormal() {
        if (this.v0v1 == null) {
            this.setNormal();
        }
        return this.v0v1;
    }

    protected void setNormal() {
        this.v0 = this.vertices[1].minus(this.vertices[0]);
        if (this.vertices.length >= 3) {
            this.v1 = this.vertices[2].minus(this.vertices[0]);
            this.v0v1 = Vector3d.product(this.v0, this.v1);
            this.nv0v1 = this.v0v1.getNorm();
            this.v0v1 = this.v0v1.times(1.0 / this.nv0v1);
        } else {
            this.v0v1 = new Vector3d(0.0, 0.0, 0.0);
        }
    }

    protected boolean isPlanar() {
        Vector3d vector3d = this.getNormal();
        if (vector3d.isZero() || this.vertices.length == 3) {
            return true;
        }
        for (int i = 1; i < this.vertices.length; ++i) {
            if (AbstractDrawable3DObject.isNull(vector3d.scalar(this.vertices[0].minus(this.vertices[i])))) continue;
            return false;
        }
        return true;
    }

    public int isBehind(Vector3d vector3d, double d) {
        double[] dArray = AbstractDrawable3DObject.minmax3D(this, vector3d);
        if (AbstractDrawable3DObject.isPositiveOrNull(dArray[0] + d)) {
            return 1;
        }
        if (dArray[1] + d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static boolean isBehind(Vector3d vector3d, Vector3d vector3d2, double d) {
        return AbstractDrawable3DObject.isPositiveOrNull(vector3d.scalar(vector3d2) + d);
    }

    protected Path2D getProjectedPolyLine() {
        Path2D.Double double_ = new Path2D.Double();
        double_.moveTo(this.vertices[0].getX(), this.vertices[0].getY());
        for (int i = 1; i < this.vertices.length; ++i) {
            double_.lineTo(this.vertices[i].getX(), this.vertices[i].getY());
        }
        return double_;
    }

    protected Path2D getProjectedContour() {
        Path2D path2D = this.getProjectedPolyLine();
        path2D.closePath();
        return path2D;
    }

    protected static final boolean isNull(double d) {
        return Math.abs(d) <= 1.0E-8;
    }

    protected static final boolean isPositiveOrNull(double d) {
        return d >= 0.0 || AbstractDrawable3DObject.isNull(d);
    }

    protected static final boolean isNegativeOrNull(double d) {
        return d <= 0.0 || AbstractDrawable3DObject.isNull(d);
    }

    protected static final boolean isGreaterOrEqual(double d, double d2) {
        return AbstractDrawable3DObject.isPositiveOrNull(d - d2);
    }

    protected static final boolean isLowerOrEqual(double d, double d2) {
        return AbstractDrawable3DObject.isPositiveOrNull(d2 - d);
    }

    protected static final boolean isEqual(double d, double d2) {
        return AbstractDrawable3DObject.isNull(d - d2);
    }

    protected static final double[] minmax3D(AbstractDrawable3DObject abstractDrawable3DObject, Vector3d vector3d) {
        double d;
        double d2 = d = vector3d.scalar(abstractDrawable3DObject.vertices[0]);
        for (int i = 1; i < abstractDrawable3DObject.vertices.length; ++i) {
            double d3 = vector3d.scalar(abstractDrawable3DObject.vertices[i]);
            if (d3 < d) {
                d = d3;
                continue;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return new double[]{d, d2};
    }

    protected static final double[] minmax2D(AbstractDrawable3DObject abstractDrawable3DObject, double d, double d2) {
        double d3;
        double d4 = d3 = d * abstractDrawable3DObject.vertices[0].getX() + d2 * abstractDrawable3DObject.vertices[0].getY();
        for (int i = 1; i < abstractDrawable3DObject.vertices.length; ++i) {
            double d5 = d * abstractDrawable3DObject.vertices[i].getX() + d2 * abstractDrawable3DObject.vertices[i].getY();
            if (d5 < d3) {
                d3 = d5;
                continue;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        return new double[]{d3, d4};
    }

    protected static final Color getColorsBarycenter(Color color, Color color2, double d, double d2) {
        if (color != null && color2 != null && !color.equals(color2)) {
            float[] fArray = color.getComponents(null);
            float[] fArray2 = color2.getComponents(null);
            return new Color((float)((double)fArray[0] * d + (double)fArray2[0] * d2), (float)((double)fArray[1] * d + (double)fArray2[1] * d2), (float)((double)fArray[2] * d + (double)fArray2[2] * d2), (float)((double)fArray[3] * d + (double)fArray2[3] * d2));
        }
        return color;
    }

    protected boolean isDegenerate() {
        if (this.degenerated == null) {
            HashSet<Vector3d> hashSet = new HashSet<Vector3d>();
            for (Vector3d vector3d : this.vertices) {
                hashSet.add(vector3d);
            }
            this.degenerated = hashSet.size() != this.vertices.length;
        }
        return this.degenerated;
    }

    protected boolean isNanOrInf() {
        for (Vector3d vector3d : this.vertices) {
            if (!AbstractDrawable3DObject.isNanOrInf(vector3d)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isNanOrInf(Vector3d vector3d) {
        double d = vector3d.getX();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return true;
        }
        double d2 = vector3d.getY();
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            return true;
        }
        double d3 = vector3d.getZ();
        return Double.isNaN(d3) || Double.isInfinite(d3);
    }
}

