/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d;

import java.awt.Color;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.g2d.G2DCanvas;
import org.scilab.forge.scirenderer.implementation.g2d.clipping.G2DClippingManager;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Motor3D;
import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.renderer.Renderer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.TransformationManager;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerImpl;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerListener;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class G2DDrawingTools
implements DrawingTools {
    private final TransformationManager transformationManager;
    private final G2DClippingManager clippingManager;
    private final G2DCanvas g2dCanvas;

    G2DDrawingTools(G2DCanvas g2DCanvas) {
        this.transformationManager = new TransformationManagerImpl(g2DCanvas);
        this.clippingManager = new G2DClippingManager(this);
        this.g2dCanvas = g2DCanvas;
        this.transformationManager.addListener(new TransformationManagerListener(){

            @Override
            public void transformationChanged(TransformationManager transformationManager) {
                if (transformationManager.isUsingSceneCoordinate()) {
                    G2DDrawingTools.this.g2dCanvas.getMotor3D().setTransformation(transformationManager.getG2DProjection(), transformationManager.getG2DSingleProjection());
                } else {
                    G2DDrawingTools.this.g2dCanvas.getMotor3D().setTransformation(transformationManager.getG2DWindowProjection(), null);
                }
            }
        });
    }

    public Motor3D getMotor3D() {
        return this.g2dCanvas.getMotor3D();
    }

    @Override
    public G2DCanvas getCanvas() {
        return this.g2dCanvas;
    }

    @Override
    public TransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    @Override
    public LightManager getLightManager() {
        return null;
    }

    @Override
    public G2DClippingManager getClippingManager() {
        return this.clippingManager;
    }

    @Override
    public void clear(org.scilab.forge.scirenderer.shapes.appearance.Color color) {
        this.g2dCanvas.getMotor3D().reset(color);
    }

    @Override
    public void clear(Color color) {
        this.g2dCanvas.getMotor3D().reset(color);
    }

    @Override
    public void clearDepthBuffer() {
        this.g2dCanvas.getMotor3D().clearDepth();
    }

    @Override
    public void draw(Renderer renderer) {
        this.g2dCanvas.getRendererManager().draw(this, renderer);
    }

    @Override
    public void draw(Geometry geometry) throws SciRendererException {
        this.g2dCanvas.getMotor3D().draw(this, geometry, Appearance.getDefault());
    }

    @Override
    public void draw(Geometry geometry, Appearance appearance) throws SciRendererException {
        this.g2dCanvas.getMotor3D().draw(this, geometry, appearance);
    }

    @Override
    public void draw(Texture texture) throws SciRendererException {
        this.g2dCanvas.getTextureManager().draw(this, texture);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer) {
        this.g2dCanvas.getMotor3D().draw((DrawingTools)this, texture, anchorPosition, elementsBuffer, 0.0);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, double d) {
        this.g2dCanvas.getMotor3D().draw((DrawingTools)this, texture, anchorPosition, elementsBuffer, d);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, Vector3d vector3d) {
        this.g2dCanvas.getMotor3D().draw((DrawingTools)this, texture, anchorPosition, vector3d, 0.0);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, Vector3d vector3d, double d) {
        this.g2dCanvas.getMotor3D().draw((DrawingTools)this, texture, anchorPosition, vector3d, d);
    }
}

