/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d;

import java.awt.Dimension;
import java.awt.Graphics2D;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.implementation.g2d.G2DDrawingTools;
import org.scilab.forge.scirenderer.implementation.g2d.buffers.G2DBuffersManager;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Motor3D;
import org.scilab.forge.scirenderer.implementation.g2d.renderer.G2DRendererManager;
import org.scilab.forge.scirenderer.implementation.g2d.texture.G2DTextureManager;
import org.scilab.forge.scirenderer.picking.PickingManager;
import org.scilab.forge.scirenderer.picking.PickingTask;

public final class G2DCanvas
implements Canvas {
    private final G2DDrawingTools drawingTools;
    private final G2DBuffersManager buffersManager;
    private final G2DRendererManager rendererManager;
    private final G2DTextureManager textureManager;
    private final Motor3D motor;
    private final Dimension dimension;
    private boolean drawEnabled = true;
    private int antiAliasingLevel = 0;
    private static final PickingManager PICKINGMANAGER = new PickingManager(){

        @Override
        public void addPickingTask(PickingTask pickingTask) {
        }
    };
    private Drawer mainDrawer;

    G2DCanvas(Graphics2D graphics2D, int n, int n2) {
        this.dimension = new Dimension(n, n2);
        this.motor = new Motor3D(this, graphics2D, this.dimension);
        this.buffersManager = new G2DBuffersManager();
        this.rendererManager = new G2DRendererManager();
        this.drawingTools = new G2DDrawingTools(this);
        this.motor.setClippingPlanes(this.drawingTools.getClippingManager().getClippingPlanes());
        this.textureManager = new G2DTextureManager(this);
    }

    public DrawingTools getDrawingTools() {
        return this.drawingTools;
    }

    public void setGraphics(Graphics2D graphics2D, int n, int n2) {
        this.dimension.width = n;
        this.dimension.height = n2;
        this.motor.setGraphics(graphics2D);
    }

    @Override
    public void setMainDrawer(Drawer drawer) {
        this.mainDrawer = drawer;
    }

    @Override
    public Drawer getMainDrawer() {
        return this.mainDrawer;
    }

    @Override
    public G2DRendererManager getRendererManager() {
        return this.rendererManager;
    }

    @Override
    public G2DBuffersManager getBuffersManager() {
        return this.buffersManager;
    }

    @Override
    public PickingManager getPickingManager() {
        return PICKINGMANAGER;
    }

    @Override
    public G2DTextureManager getTextureManager() {
        return this.textureManager;
    }

    @Override
    public int getWidth() {
        return this.dimension.width;
    }

    @Override
    public int getHeight() {
        return this.dimension.height;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public int getAntiAliasingLevel() {
        return this.antiAliasingLevel;
    }

    @Override
    public void setAntiAliasingLevel(int n) {
        this.antiAliasingLevel = n;
    }

    @Override
    public void redraw() {
        this.draw();
    }

    @Override
    public void redrawAndWait() {
        this.redraw();
    }

    @Override
    public void waitImage() {
    }

    public void disableDraw() {
        this.drawEnabled = false;
    }

    public void enableDraw() {
        this.drawEnabled = true;
    }

    public void draw() {
        if (this.drawEnabled) {
            try {
                this.mainDrawer.draw(this.drawingTools);
                this.getMotor3D().setAntialiased(this.antiAliasingLevel != 0);
                this.getMotor3D().draw();
            }
            catch (Exception exception) {
                System.out.println(exception + "::::" + this.mainDrawer);
                exception.printStackTrace();
            }
        }
    }

    public Motor3D getMotor3D() {
        return this.motor;
    }

    @Override
    public void destroy() {
    }
}

