/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.font.FontFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.util.ClasspathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFontFactory
extends FontFactory {
    private static final Log LOGGER = LogFactory.getLog(DefaultFontFactory.class);
    private final Map<String, Font> fontCache = new HashMap<String, Font>();

    DefaultFontFactory() {
        this.autoloadFontsFromAWT();
        this.autoloadFontsFromClasspath();
    }

    private void autoloadFontsFromAWT() {
        String[] stringArray;
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            Font font = new Font(string, 0, 12);
            this.cacheFont(font);
        }
    }

    private void autoloadFontsFromClasspath() {
        List list = ClasspathResource.getInstance().listResourcesOfMimeType("application/x-font");
        for (URL uRL : list) {
            try {
                try {
                    this.cacheFont(Font.createFont(0, uRL.openStream()));
                }
                catch (FontFormatException fontFormatException) {
                    try {
                        this.cacheFont(Font.createFont(1, uRL.openStream()));
                    }
                    catch (FontFormatException fontFormatException2) {
                        LOGGER.warn((Object)fontFormatException.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)iOException.getMessage());
            }
        }
    }

    @Override
    public Font getFont(String string, int n, int n2) {
        Font font = this.fontCache.get(string);
        font = font == null ? new Font(string, n, n2) : font.deriveFont(n, n2);
        return font;
    }

    @Override
    public Font getFont(List<String> list, int n, int n2, int n3) {
        Font font = this.searchFontList(list, n, n2, n3);
        if (font == null) {
            font = this.searchFontList(this.fontCache.keySet(), n, n2, n3);
        }
        return font;
    }

    private Font searchFontList(Collection<String> collection, int n, int n2, int n3) {
        for (String string : collection) {
            Font font = this.getFont(string, n2, n3);
            String string2 = string.trim();
            if (!font.getFamily().equalsIgnoreCase(string2) && !font.getFontName().equalsIgnoreCase(string2) || !font.canDisplay(n)) continue;
            return font;
        }
        return null;
    }

    @Override
    public Font registerFont(int n, File file) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(n, file));
    }

    @Override
    public Font registerFont(int n, InputStream inputStream) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(n, inputStream));
    }

    private Font cacheFont(Font font) {
        this.fontCache.put(font.getFontName(), font);
        String string = font.getFamily();
        if (!this.fontCache.containsKey(string)) {
            this.fontCache.put(font.getFamily(), font);
        }
        return font;
    }

    @Override
    public Set<String> listFontNames() {
        return this.fontCache.keySet();
    }
}

