/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.TextObject;
import org.apache.batik.dom.events.DOMCustomEvent;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.mathml.MathMLOperatorElement;
import org.w3c.dom.mathml.MathMLUnderOverElement;

public final class Mo
extends AbstractJEuclidElement
implements MathMLOperatorElement,
EventListener {
    public static final String ATTR_FORM = "form";
    public static final String ATTR_SEPARATOR = "separator";
    public static final String ATTR_LSPACE = "lspace";
    public static final String ATTR_RSPACE = "rspace";
    public static final String ATTR_MINSIZE = "minsize";
    public static final String ATTR_MAXSIZE = "maxsize";
    public static final String ATTR_MOVEABLEWRONG = "moveablelimits";
    public static final String ATTR_MOVABLELIMITS = "movablelimits";
    public static final String ATTR_ACCENT = "accent";
    public static final String ELEMENT = "mo";
    public static final float LARGEOP_CORRECTOR_INLINE = 1.2f;
    public static final float LARGEOP_CORRECTOR_BLOCK = 1.5f;
    public static final String ATTR_STRETCHY = "stretchy";
    public static final String ATTR_LARGEOP = "largeop";
    public static final String ATTR_SYMMETRIC = "symmetric";
    public static final String ATTR_FENCE = "fence";
    public static final String MOEVENT = "MOEvent";
    public static final String HOR_DELIMITERS = "_\u00af\u0332\u0333\u033f\u2190\u2192\u2194\u23b4\u23b5\ufe35\ufe36\ufe37\ufe38\u2322";
    public static final String VER_DELIMITERS = "[{()}]|\u2191\u2193\u21c5\u21c8\u21ca\u21f5\u2223\u2225\u2329\u232a";
    private static final long serialVersionUID = 1L;
    private final OperatorDictionary opDict;
    private boolean inChangeHook;

    public Mo() {
        this.setDefaultMathAttribute(ATTR_FORM, "infix");
        this.setDefaultMathAttribute(ATTR_FENCE, "false");
        this.setDefaultMathAttribute(ATTR_SEPARATOR, "false");
        this.setDefaultMathAttribute(ATTR_LSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_RSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_STRETCHY, "false");
        this.setDefaultMathAttribute(ATTR_SYMMETRIC, "true");
        this.setDefaultMathAttribute(ATTR_MAXSIZE, "9999999pt");
        this.setDefaultMathAttribute(ATTR_MINSIZE, "1");
        this.setDefaultMathAttribute(ATTR_LARGEOP, "false");
        this.setDefaultMathAttribute(ATTR_MOVABLELIMITS, "false");
        this.setDefaultMathAttribute(ATTR_ACCENT, "false");
        this.opDict = OperatorDictionary.getInstance();
    }

    protected Node newNode() {
        return new Mo();
    }

    private float getLspaceAsFloat(LayoutContext layoutContext) {
        if ((Integer)layoutContext.getParameter(Parameter.SCRIPTLEVEL) > 0) {
            return 0.0f;
        }
        return AttributesHelper.convertSizeToPt(this.getLspace(), layoutContext, "pt");
    }

    public float getLargeOpCorrector(LayoutContext layoutContext) {
        if (Display.BLOCK.equals(layoutContext.getParameter(Parameter.DISPLAY))) {
            return 1.5f;
        }
        return 1.2f;
    }

    private float getRspaceAsFloat(LayoutContext layoutContext) {
        if ((Integer)layoutContext.getParameter(Parameter.SCRIPTLEVEL) > 0) {
            return 0.0f;
        }
        return AttributesHelper.convertSizeToPt(this.getRspace(), layoutContext, "pt");
    }

    private boolean isFence() {
        return Boolean.parseBoolean(this.getFence());
    }

    public void setMaxsize(String string) {
        this.setAttribute(ATTR_MAXSIZE, string);
    }

    public String getMaxsize() {
        return this.getMathAttribute(ATTR_MAXSIZE);
    }

    public void setMinsize(String string) {
        this.setAttribute(ATTR_MINSIZE, string);
    }

    public String getMinsize() {
        return this.getMathAttribute(ATTR_MINSIZE);
    }

    private boolean isVerticalDelimeter() {
        return this.getText().length() == 1 && (VER_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0 || this.isFence());
    }

    private boolean isHorizontalDelimeter() {
        return this.getText().length() == 1 && HOR_DELIMITERS.indexOf(this.getText().charAt(0)) >= 0;
    }

    private TextLayout produceUnstrechtedLayout(Graphics2D graphics2D, LayoutContext layoutContext) {
        assert (graphics2D != null) : "Graphics2d is null in produceUnstrechtedLayout";
        float f = GraphicsSupport.getFontsizeInPoint(layoutContext);
        if (Boolean.parseBoolean(this.getLargeop())) {
            f *= this.getLargeOpCorrector(layoutContext);
        }
        String string = this.getText();
        AttributedString attributedString = StringUtil.convertStringtoAttributedString(string, this.getMathvariantAsVariant(), f, layoutContext);
        TextLayout textLayout = StringUtil.createTextLayoutFromAttributedString(graphics2D, attributedString, layoutContext);
        return textLayout;
    }

    public void changeHook() {
        super.changeHook();
        if (!this.inChangeHook) {
            this.inChangeHook = true;
            this.detectFormParameter();
            this.loadAttributeFromDictionary(ATTR_LARGEOP, "false");
            this.loadAttributeFromDictionary(ATTR_SYMMETRIC, "true");
            this.loadAttributeFromDictionary(ATTR_STRETCHY, "false");
            this.loadAttributeFromDictionary(ATTR_FENCE, "false");
            this.loadAttributeFromDictionary(ATTR_LSPACE, "0.277778em");
            this.loadAttributeFromDictionary(ATTR_RSPACE, "0.277778em");
            this.loadAttributeFromDictionary(ATTR_MOVABLELIMITS, "false");
            JEuclidElement jEuclidElement = this.getParent();
            while (jEuclidElement != null) {
                if (jEuclidElement instanceof EventTarget) {
                    ((EventTarget)((Object)jEuclidElement)).addEventListener("DOMSubtreeModified", this, false);
                }
                if (jEuclidElement instanceof Mrow) {
                    jEuclidElement = null;
                    continue;
                }
                jEuclidElement = jEuclidElement.getParent();
            }
            if (this.isFence()) {
                this.setDefaultMathAttribute(ATTR_STRETCHY, "true");
            }
            DOMCustomEvent dOMCustomEvent = new DOMCustomEvent();
            dOMCustomEvent.initCustomEventNS(null, MOEVENT, true, false, null);
            this.dispatchEvent((Event)dOMCustomEvent);
            this.inChangeHook = false;
        }
    }

    private void loadAttributeFromDictionary(String string, String string2) {
        String string3;
        try {
            string3 = this.opDict.getDefaultAttributeValue(this.getText(), this.getForm(), string);
        }
        catch (UnknownAttributeException unknownAttributeException) {
            string3 = string2;
        }
        if (string3.equals("NULL")) {
            string3 = string2;
        }
        this.setDefaultMathAttribute(string, string3);
    }

    private void detectFormParameter() {
        int n;
        JEuclidElement jEuclidElement = this.getParent();
        String string = jEuclidElement != null && jEuclidElement instanceof Mrow ? ((n = jEuclidElement.getIndexOfMathElement(this)) == 0 && jEuclidElement.getMathElementCount() > 0 ? "prefix" : (n == jEuclidElement.getMathElementCount() - 1 && jEuclidElement.getMathElementCount() > 0 ? "postfix" : "infix")) : "infix";
        this.setDefaultMathAttribute(ATTR_FORM, string);
    }

    public String getLargeop() {
        return this.getMathAttribute(ATTR_LARGEOP);
    }

    public String getLspace() {
        return this.getMathAttribute(ATTR_LSPACE);
    }

    public String getMovablelimits() {
        String string = this.getMathAttribute(ATTR_MOVEABLEWRONG, false);
        if (string == null) {
            return this.getMathAttribute(ATTR_MOVABLELIMITS);
        }
        return string;
    }

    public String getRspace() {
        return this.getMathAttribute(ATTR_RSPACE);
    }

    public void setAccent(String string) {
        this.setAttribute(ATTR_ACCENT, string);
    }

    public void setFence(String string) {
        this.setAttribute(ATTR_FENCE, string);
    }

    public void setForm(String string) {
        this.setAttribute(ATTR_FORM, string);
    }

    public void setLargeop(String string) {
        this.setAttribute(ATTR_LARGEOP, string);
    }

    public void setLspace(String string) {
        this.setAttribute(ATTR_LSPACE, string);
    }

    public void setMovablelimits(String string) {
        this.setAttribute(ATTR_MOVABLELIMITS, string);
    }

    public void setRspace(String string) {
        this.setAttribute(ATTR_RSPACE, string);
    }

    public void setSeparator(String string) {
        this.setAttribute(ATTR_SEPARATOR, string);
    }

    public void setStretchy(String string) {
        this.setAttribute(ATTR_STRETCHY, string);
    }

    public void setSymmetric(String string) {
        this.setAttribute(ATTR_SYMMETRIC, string);
    }

    public String getFence() {
        return this.getMathAttribute(ATTR_FENCE);
    }

    public String getForm() {
        return this.getMathAttribute(ATTR_FORM);
    }

    public String getSeparator() {
        return this.getMathAttribute(ATTR_SEPARATOR);
    }

    public String getStretchy() {
        return this.getMathAttribute(ATTR_STRETCHY);
    }

    public String getAccent() {
        return this.getMathAttribute(ATTR_ACCENT);
    }

    public String getSymmetric() {
        return this.getMathAttribute(ATTR_SYMMETRIC);
    }

    public void layoutStage1(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        Graphics2D graphics2D = layoutView.getGraphics();
        TextLayout textLayout = this.produceUnstrechtedLayout(graphics2D, layoutContext2);
        StringUtil.TextLayoutInfo textLayoutInfo = StringUtil.getTextLayoutInfo(textLayout, true);
        float f = textLayoutInfo.getAscent();
        float f2 = textLayoutInfo.getDescent();
        float f3 = textLayoutInfo.getOffset();
        float f4 = textLayoutInfo.getWidth() + f3;
        JEuclidElement jEuclidElement = this.getParent();
        float f5 = this.getLspaceAsFloat(layoutContext2);
        float f6 = this.getRspaceAsFloat(layoutContext2);
        f6 = jEuclidElement != null && jEuclidElement.hasChildPostscripts(this, layoutContext) ? 0.0f : this.getRspaceAsFloat(layoutContext2);
        f5 = jEuclidElement != null && jEuclidElement.hasChildPrescripts(this) ? 0.0f : this.getLspaceAsFloat(layoutContext2);
        layoutInfo.setAscentHeight(f, LayoutStage.STAGE1);
        layoutInfo.setDescentHeight(f2, LayoutStage.STAGE1);
        layoutInfo.setHorizontalCenterOffset(f5 + f4 / 2.0f, LayoutStage.STAGE1);
        layoutInfo.setWidth(f5 + f4 + f6, LayoutStage.STAGE1);
        if (Boolean.parseBoolean(this.getStretchy()) || this.isVerticalDelimeter() || this.isHorizontalDelimeter()) {
            layoutInfo.setLayoutStage(LayoutStage.STAGE1);
        } else {
            layoutInfo.setGraphicsObject(new TextObject(textLayout, f5 + textLayoutInfo.getOffset(), 0.0f, null, (Color)layoutContext2.getParameter(Parameter.MATHCOLOR)));
            layoutInfo.setLayoutStage(LayoutStage.STAGE2);
        }
    }

    public void layoutStage2(LayoutView layoutView, LayoutInfo layoutInfo, LayoutContext layoutContext) {
        float f;
        float f2;
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        Graphics2D graphics2D = layoutView.getGraphics();
        TextLayout textLayout = this.produceUnstrechtedLayout(graphics2D, layoutContext2);
        boolean bl = this.isVerticalDelimeter();
        JEuclidElement jEuclidElement = this.getParent();
        while (jEuclidElement instanceof MathMLUnderOverElement && bl || jEuclidElement instanceof Mrow && jEuclidElement.getMathElementCount() == 1) {
            jEuclidElement = jEuclidElement.getParent();
        }
        LayoutInfo layoutInfo2 = layoutView.getInfo(jEuclidElement);
        StringUtil.TextLayoutInfo textLayoutInfo = StringUtil.getTextLayoutInfo(textLayout, true);
        if (bl) {
            float[] fArray = this.calcYScaleFactorAndBaselineShift(layoutInfo, layoutInfo2, textLayoutInfo, layoutContext2);
            f2 = fArray[0];
            f = fArray[1];
        } else {
            f2 = 1.0f;
            f = 0.0f;
        }
        float f3 = this.calcXScaleFactor(layoutInfo, layoutInfo2, textLayoutInfo);
        layoutInfo.setGraphicsObject(new TextObject(textLayout, this.getLspaceAsFloat(layoutContext2) + textLayoutInfo.getOffset() * f3, f, AffineTransform.getScaleInstance(f3, f2), (Color)layoutContext2.getParameter(Parameter.MATHCOLOR)));
        layoutInfo.setLayoutStage(LayoutStage.STAGE2);
    }

    private float calcXScaleFactor(LayoutInfo layoutInfo, LayoutInfo layoutInfo2, StringUtil.TextLayoutInfo textLayoutInfo) {
        float f;
        float f2 = layoutInfo2.getStretchWidth();
        if (this.isHorizontalDelimeter() && f2 > 0.0f) {
            float f3 = textLayoutInfo.getWidth();
            if (f3 > 0.0f) {
                f = f2 / f3;
                layoutInfo.setWidth(f2, LayoutStage.STAGE2);
                layoutInfo.setHorizontalCenterOffset(f2 / 2.0f, LayoutStage.STAGE2);
            } else {
                f = 1.0f;
            }
        } else {
            f = 1.0f;
        }
        return f;
    }

    private float[] calcYScaleFactorAndBaselineShift(LayoutInfo layoutInfo, LayoutInfo layoutInfo2, StringUtil.TextLayoutInfo textLayoutInfo, LayoutContext layoutContext) {
        float f = layoutInfo2.getStretchAscent();
        float f2 = layoutInfo2.getStretchDescent();
        float f3 = f + f2;
        float f4 = textLayoutInfo.getDescent();
        float f5 = textLayoutInfo.getAscent() + f4;
        float f6 = AttributesHelper.parseRelativeSize(this.getMaxsize(), layoutContext, f5);
        float f7 = AttributesHelper.parseRelativeSize(this.getMinsize(), layoutContext, f5);
        float f8 = Math.max(Math.min(f3, f6), f7);
        float f9 = f8 / f3 * (f3 / 2.0f) - (f3 / 2.0f - f2);
        float f10 = f5 > 0.0f ? f8 / f5 : 1.0f;
        float f11 = f4 * f10;
        float f12 = f9 - f11;
        layoutInfo.setDescentHeight(f9, LayoutStage.STAGE2);
        layoutInfo.setAscentHeight(f8 - f9, LayoutStage.STAGE2);
        return new float[]{f10, f12};
    }

    public void handleEvent(Event event) {
        this.changeHook();
    }
}

