/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import java.nio.IntBuffer;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.x11.glx.GLX;

public class GLXUtil {
    public static final boolean DEBUG = Debug.debug("GLXUtil");
    private static boolean clientMultisampleAvailable = false;
    private static String clientVendorName = null;
    private static VersionNumber clientVersionNumber = null;

    public static synchronized boolean isGLXAvailableOnServer(X11GraphicsDevice x11GraphicsDevice) {
        if (null == x11GraphicsDevice) {
            throw new IllegalArgumentException("null X11GraphicsDevice");
        }
        if (0L == x11GraphicsDevice.getHandle()) {
            throw new IllegalArgumentException("null X11GraphicsDevice display handle");
        }
        boolean bl = false;
        x11GraphicsDevice.lock();
        try {
            bl = GLX.glXQueryExtension(x11GraphicsDevice.getHandle(), null, null);
        }
        catch (Throwable throwable) {
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        return bl;
    }

    public static String getGLXClientString(X11GraphicsDevice x11GraphicsDevice, int n) {
        x11GraphicsDevice.lock();
        try {
            String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), n);
            return string;
        }
        finally {
            x11GraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryGLXServerString(X11GraphicsDevice x11GraphicsDevice, int n, int n2) {
        x11GraphicsDevice.lock();
        try {
            String string = GLX.glXQueryServerString(x11GraphicsDevice.getHandle(), n, n2);
            return string;
        }
        finally {
            x11GraphicsDevice.unlock();
        }
    }

    public static String queryGLXExtensionsString(X11GraphicsDevice x11GraphicsDevice, int n) {
        x11GraphicsDevice.lock();
        try {
            String string = GLX.glXQueryExtensionsString(x11GraphicsDevice.getHandle(), n);
            return string;
        }
        finally {
            x11GraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionNumber getGLXServerVersionNumber(X11GraphicsDevice x11GraphicsDevice) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)1);
        x11GraphicsDevice.lock();
        try {
            if (!GLX.glXQueryVersion(x11GraphicsDevice.getHandle(), intBuffer, intBuffer2)) {
                throw new GLException("glXQueryVersion failed");
            }
            if (intBuffer.get(0) == 1 && intBuffer2.get(0) == 2) {
                String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 2);
                try {
                    intBuffer.put(0, Integer.parseInt(string.substring(0, 1)));
                    intBuffer2.put(0, Integer.parseInt(string.substring(2, 3)));
                }
                catch (Exception exception) {
                    intBuffer.put(0, 1);
                    intBuffer2.put(0, 2);
                }
            }
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        return new VersionNumber(intBuffer.get(0), intBuffer2.get(0), 0);
    }

    public static boolean isMultisampleAvailable(String string) {
        if (string != null) {
            return string.indexOf("GLX_ARB_multisample") >= 0;
        }
        return false;
    }

    public static boolean isVendorNVIDIA(String string) {
        return string != null && string.startsWith("NVIDIA");
    }

    public static boolean isVendorATI(String string) {
        return string != null && string.startsWith("ATI");
    }

    public static boolean isClientMultisampleAvailable() {
        return clientMultisampleAvailable;
    }

    public static String getClientVendorName() {
        return clientVendorName;
    }

    public static VersionNumber getClientVersionNumber() {
        return clientVersionNumber;
    }

    public static synchronized void initGLXClientDataSingleton(X11GraphicsDevice x11GraphicsDevice) {
        if (null != clientVendorName) {
            return;
        }
        if (null == x11GraphicsDevice) {
            throw new IllegalArgumentException("null X11GraphicsDevice");
        }
        if (0L == x11GraphicsDevice.getHandle()) {
            throw new IllegalArgumentException("null X11GraphicsDevice display handle");
        }
        clientMultisampleAvailable = GLXUtil.isMultisampleAvailable(GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 3));
        clientVendorName = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 1);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 2);
        try {
            nArray[0] = Integer.parseInt(string.substring(0, 1));
            nArray2[0] = Integer.parseInt(string.substring(2, 3));
        }
        catch (Exception exception) {
            nArray[0] = 1;
            nArray2[0] = 2;
        }
        clientVersionNumber = new VersionNumber(nArray[0], nArray2[0], 0);
    }
}

