/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import javax.media.nativewindow.util.PixelFormat;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class GLPixelBuffer {
    public static final GLPixelBufferProvider defaultProviderNoRowStride = new DefaultGLPixelBufferProvider(false);
    public static final GLPixelBufferProvider defaultProviderWithRowStride = new DefaultGLPixelBufferProvider(true);
    public final GLPixelAttributes pixelAttributes;
    public final int width;
    public final int height;
    public final int depth;
    public final boolean pack;
    public final int byteSize;
    public final Buffer buffer;
    public final int bufferElemSize;
    public final boolean allowRowStride;
    private boolean disposed = false;

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(this.pixelAttributes).append(", dim ").append(this.width).append("x").append(this.height).append("x").append(this.depth).append(", pack ").append(this.pack).append(", disposed ").append(this.disposed).append(", valid ").append(this.isValid()).append(", buffer[bytes ").append(this.byteSize).append(", elemSize ").append(this.bufferElemSize).append(", ").append(this.buffer).append("]");
        return stringBuilder;
    }

    public String toString() {
        return "GLPixelBuffer[" + this.toString(null).toString() + "]";
    }

    public GLPixelBuffer(GLPixelAttributes gLPixelAttributes, int n, int n2, int n3, boolean bl, Buffer buffer, boolean bl2) {
        this.pixelAttributes = gLPixelAttributes;
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.pack = bl;
        this.buffer = buffer;
        this.byteSize = Buffers.remainingBytes((Object)buffer);
        this.bufferElemSize = Buffers.sizeOfBufferElem((Object)buffer);
        this.allowRowStride = bl2;
    }

    public final boolean getAllowRowStride() {
        return this.allowRowStride;
    }

    public boolean isValid() {
        return !this.disposed && 0 < this.byteSize;
    }

    public Buffer rewind() {
        return this.buffer.rewind();
    }

    public int position() {
        return this.buffer.position() * this.bufferElemSize;
    }

    public Buffer position(int n) {
        return this.buffer.position(n / this.bufferElemSize);
    }

    public int capacity() {
        return this.buffer.capacity() * this.bufferElemSize;
    }

    public int limit() {
        return this.buffer.limit() * this.bufferElemSize;
    }

    public Buffer flip() {
        return this.buffer.flip();
    }

    public Buffer clear() {
        return this.buffer.clear();
    }

    public boolean requiresNewBuffer(GL gL, int n, int n2, int n3) {
        if (!this.isValid()) {
            return true;
        }
        if (0 >= n3) {
            int[] nArray = new int[]{0};
            n3 = GLBuffers.sizeof(gL, nArray, this.pixelAttributes.bytesPerPixel, n, n2, 1, true);
        }
        if (this.allowRowStride) {
            return this.byteSize < n3;
        }
        return this.byteSize < n3 || this.width != n;
    }

    public void dispose() {
        this.disposed = true;
        this.buffer.clear();
    }

    public static class GLPixelAttributes {
        public static final GLPixelAttributes UNDEF = new GLPixelAttributes(0, 0, 0, false);
        public final int componentCount;
        public final int format;
        public final int type;
        public final int bytesPerPixel;

        public GLPixelAttributes(int n, int n2) {
            this(0 < n ? GLBuffers.componentCount(n) : 0, n, n2);
        }

        public GLPixelAttributes(int n, int n2, int n3) {
            this(n, n2, n3, true);
        }

        public static final GLPixelAttributes convert(PixelFormat pixelFormat, GLProfile gLProfile) {
            int n = 0;
            int n2 = 5121;
            switch (pixelFormat) {
                case LUMINANCE: {
                    if (gLProfile.isGL3ES3()) {
                        n = 6403;
                        break;
                    }
                    n = 6409;
                    break;
                }
                case BGR888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 32992;
                    break;
                }
                case RGB888: {
                    n = 6407;
                    break;
                }
                case RGBA8888: {
                    n = 6408;
                    break;
                }
                case ABGR8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 6408;
                    n2 = 32821;
                    break;
                }
                case BGRA8888: {
                    n = 32993;
                    break;
                }
                case ARGB8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n = 32993;
                    n2 = 32821;
                    break;
                }
            }
            if (0 != n) {
                return new GLPixelAttributes(pixelFormat.componentCount, n, n2, true);
            }
            return null;
        }

        private GLPixelAttributes(int n, int n2, int n3, boolean bl) {
            this.componentCount = n;
            this.format = n2;
            this.type = n3;
            int n4 = this.bytesPerPixel = 0 < n2 && 0 < n3 ? GLBuffers.bytesPerPixel(n2, n3) : 0;
            if (bl) {
                if (0 == n || 0 == this.format || 0 == this.type) {
                    throw new GLException("Zero components, format and/or type: " + this);
                }
                if (0 == this.bytesPerPixel) {
                    throw new GLException("Zero bytesPerPixel: " + this);
                }
            }
        }

        public final PixelFormat getPixelFormat() {
            PixelFormat pixelFormat;
            block0 : switch (this.format) {
                case 6403: 
                case 6406: 
                case 6409: {
                    pixelFormat = PixelFormat.LUMINANCE;
                    break;
                }
                case 6407: {
                    pixelFormat = PixelFormat.RGB888;
                    break;
                }
                case 6408: {
                    pixelFormat = PixelFormat.RGBA8888;
                    break;
                }
                case 32992: {
                    pixelFormat = PixelFormat.BGR888;
                    break;
                }
                case 32993: {
                    pixelFormat = PixelFormat.BGRA8888;
                    break;
                }
                default: {
                    switch (this.bytesPerPixel) {
                        case 1: {
                            pixelFormat = PixelFormat.LUMINANCE;
                            break block0;
                        }
                        case 3: {
                            pixelFormat = PixelFormat.RGB888;
                            break block0;
                        }
                        case 4: {
                            pixelFormat = PixelFormat.RGBA8888;
                            break block0;
                        }
                    }
                    pixelFormat = null;
                }
            }
            return pixelFormat;
        }

        public String toString() {
            return "PixelAttributes[comp " + this.componentCount + ", fmt 0x" + Integer.toHexString(this.format) + ", type 0x" + Integer.toHexString(this.type) + ", bytesPerPixel " + this.bytesPerPixel + "]";
        }
    }

    public static class DefaultGLPixelBufferProvider
    implements GLPixelBufferProvider {
        private final boolean allowRowStride;

        public DefaultGLPixelBufferProvider(boolean bl) {
            this.allowRowStride = bl;
        }

        @Override
        public boolean getAllowRowStride() {
            return this.allowRowStride;
        }

        @Override
        public GLPixelAttributes getAttributes(GL gL, int n) {
            int n2;
            int n3;
            GLContext gLContext = gL.getContext();
            if (1 == n) {
                n3 = gL.isGL3ES3() ? 6403 : 6406;
                n2 = 5121;
            } else if (3 == n) {
                n3 = 6407;
                n2 = 5121;
            } else if (4 == n) {
                int n4 = gLContext.getDefaultPixelDataFormat();
                int n5 = GLBuffers.componentCount(n4);
                if (n5 == n) {
                    n3 = n4;
                    n2 = gLContext.getDefaultPixelDataType();
                } else {
                    n3 = 6408;
                    n2 = 5121;
                }
            } else {
                throw new GLException("Unsupported componentCount " + n + ", contact maintainer to enhance");
            }
            return new GLPixelAttributes(n, n3, n2);
        }

        @Override
        public GLPixelBuffer allocate(GL gL, GLPixelAttributes gLPixelAttributes, int n, int n2, int n3, boolean bl, int n4) {
            if (n4 > 0) {
                return new GLPixelBuffer(gLPixelAttributes, n, n2, n3, bl, Buffers.newDirectByteBuffer((int)n4), this.getAllowRowStride());
            }
            int[] nArray = new int[]{0};
            int n5 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.bytesPerPixel, n, n2, n3, bl);
            return new GLPixelBuffer(gLPixelAttributes, n, n2, n3, bl, Buffers.newDirectByteBuffer((int)n5), this.getAllowRowStride());
        }
    }

    public static interface SingletonGLPixelBufferProvider
    extends GLPixelBufferProvider {
        public GLPixelBuffer getSingleBuffer(GLPixelAttributes var1);

        public GLPixelBuffer initSingleton(int var1, int var2, int var3, int var4, boolean var5);
    }

    public static interface GLPixelBufferProvider {
        public boolean getAllowRowStride();

        public GLPixelAttributes getAttributes(GL var1, int var2);

        public GLPixelBuffer allocate(GL var1, GLPixelAttributes var2, int var3, int var4, int var5, boolean var6, int var7);
    }
}

