/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ToolBarConfiguration;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ToolBarBuilder {
    private static final String FILE_NOT_FOUND = "Could not find file: ";
    private static final String CANNOT_CREATE_TOOLBAR = "Cannot create ToolBar.\nCheck if file *_toolbar.xml is available and valid.";
    private static int figureIndex;

    private ToolBarBuilder() {
        throw new UnsupportedOperationException();
    }

    public static Object buildToolBar(Class[] classArray, String string) throws SAXException, IOException, ParserConfigurationException {
        ToolBarConfigurationHandler toolBarConfigurationHandler = new ToolBarConfigurationHandler(string);
        return Proxy.newProxyInstance(toolBarConfigurationHandler.getClass().getClassLoader(), classArray, (InvocationHandler)toolBarConfigurationHandler);
    }

    public static ToolBar buildToolBar(String string) {
        return ToolBarBuilder.buildToolBar(string, 0);
    }

    public static ToolBar buildToolBar(String string, int n) {
        figureIndex = n;
        ToolBar toolBar = ScilabToolBar.createToolBar();
        try {
            ToolBarConfiguration toolBarConfiguration = (ToolBarConfiguration)ToolBarBuilder.buildToolBar(new Class[]{ToolBarConfiguration.class}, string);
            toolBarConfiguration.addPushButtons(toolBar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(CANNOT_CREATE_TOOLBAR);
            System.err.println(FILE_NOT_FOUND + illegalArgumentException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            System.err.println(CANNOT_CREATE_TOOLBAR);
            System.err.println(FILE_NOT_FOUND + sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println(CANNOT_CREATE_TOOLBAR);
            System.err.println(FILE_NOT_FOUND + iOException.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(CANNOT_CREATE_TOOLBAR);
            System.err.println(FILE_NOT_FOUND + parserConfigurationException.getLocalizedMessage());
        }
        return toolBar;
    }

    private static class ToolBarConfigurationHandler
    implements InvocationHandler {
        protected static final String BUTTON = "button";
        protected static final String ICON = "icon";
        protected static final String SEPARATOR = "separator";
        protected static final String ENABLED = "enabled";
        protected static final String CALLBACK = "callback";
        protected static final String TYPE = "type";
        protected static final String INSTRUCTION = "instruction";
        protected static final String TRUE = "true";
        protected static final String TOOLTIPTEXT = "tooltiptext";
        protected static final String TOGGLE = "toggle";
        private final Document dom;
        private final Collection<String> internalMethodNames;

        public ToolBarConfigurationHandler(String string) throws SAXException, IOException, ParserConfigurationException {
            Method[] methodArray;
            if (!new File(string).exists()) {
                throw new IOException();
            }
            this.internalMethodNames = new TreeSet<String>();
            for (Method method : methodArray = this.getClass().getMethods()) {
                this.internalMethodNames.add(method.getName());
            }
            this.dom = ScilabDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(string));
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (this.internalMethodNames.contains(method.getName())) {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, objectArray);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addPushButtons(ToolBar toolBar) {
            Node node = this.dom.getFirstChild();
            NamedNodeMap namedNodeMap = null;
            AbstractButton abstractButton = null;
            try {
                block2: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    int n;
                    boolean bl;
                    if (node2.getNodeName().equals(BUTTON)) {
                        namedNodeMap = node2.getAttributes();
                        bl = false;
                    } else {
                        if (!node2.getNodeName().equals(SEPARATOR)) continue;
                        toolBar.addSeparator();
                        continue;
                    }
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        if (!namedNodeMap.item(n).getNodeName().equals(TOGGLE)) continue;
                        bl = namedNodeMap.item(n).getNodeValue().equals(TRUE);
                        break;
                    }
                    abstractButton = bl ? new JToggleButton() : new JButton();
                    ScilabLAF.setDefaultProperties((AbstractButton)abstractButton);
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        if (namedNodeMap.item(n).getNodeName().equals(ICON)) {
                            abstractButton.setIcon(new ImageIcon(FindIconHelper.findIcon((String)namedNodeMap.item(n).getNodeValue())));
                            continue;
                        }
                        if (namedNodeMap.item(n).getNodeName().equals(ENABLED)) {
                            abstractButton.setEnabled(namedNodeMap.item(n).getNodeValue().equals(TRUE));
                            continue;
                        }
                        if (!namedNodeMap.item(n).getNodeName().equals(TOOLTIPTEXT)) continue;
                        abstractButton.setToolTipText(Messages.gettext((String)namedNodeMap.item(n).getNodeValue()));
                    }
                    ((SwingScilabToolBar)toolBar.getAsSimpleToolBar()).add(abstractButton);
                    Node node3 = node2.getFirstChild();
                    while (true) {
                        if (node3 == null) continue block2;
                        if (node3.getNodeName() == CALLBACK) {
                            NamedNodeMap namedNodeMap2 = node3.getAttributes();
                            String string = null;
                            int n2 = -1;
                            for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                                if (namedNodeMap2.item(i).getNodeName() == INSTRUCTION) {
                                    string = namedNodeMap2.item(i).getNodeValue();
                                    continue;
                                }
                                if (namedNodeMap2.item(i).getNodeName() != TYPE) continue;
                                n2 = Integer.parseInt(namedNodeMap2.item(i).getNodeValue());
                            }
                            if (string != null && n2 != -1) {
                                abstractButton.addActionListener(CommonCallBack.createCallback(this.replaceFigureID(string), n2));
                            }
                        }
                        node3 = node3.getNextSibling();
                    }
                }
                return;
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
        }

        private String replaceFigureID(String string) {
            return string.replaceAll("\\[SCILAB_FIGURE_ID\\]", Integer.toString(figureIndex));
        }
    }
}

