/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.scilab.modules.gui.bridge.CallScilabBridge;

public final class ScilabPrintStream
extends PrintStream {
    private static ScilabPrintStream stream;
    private static SciOutputStream output;

    private ScilabPrintStream() {
        super(output, true);
    }

    public static boolean isAvailable() {
        return false;
    }

    public static ScilabPrintStream getInstance() {
        if (stream == null) {
            output = new SciOutputStream();
            stream = new ScilabPrintStream();
        }
        return stream;
    }

    public static void setRedirect(PrintStream printStream) {
        output.setRedirect(printStream);
    }

    private static final class SciOutputStream
    extends OutputStream {
        private PrintStream out;

        private SciOutputStream() {
        }

        public void setRedirect(PrintStream printStream) {
            this.out = printStream;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            CallScilabBridge.display(new String(byArray));
            if (this.out != null) {
                this.out.write(byArray);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            CallScilabBridge.display(new String(byArray, n, n2));
            if (this.out != null) {
                this.out.write(byArray, n, n2);
            }
        }

        @Override
        public void write(int n) throws IOException {
            CallScilabBridge.display(new String(new byte[]{(byte)n}));
            if (this.out != null) {
                this.out.write(n);
            }
        }
    }
}

