/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.localization.Messages;

public class ScilabAboutBox {
    public static final String SCIDIR = System.getenv("SCI");
    public static final String IMAGEPATH = SCIDIR + "/modules/gui/images/icons/aboutscilab.png";
    private static Icon scilabIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab", (String)"256x256"));
    private static Image imageForIcon = ((ImageIcon)scilabIcon).getImage();

    protected ScilabAboutBox() {
        throw new UnsupportedOperationException();
    }

    public static void displayAndWait() {
        String string = SCIDIR + "/ACKNOWLEDGEMENTS";
        if (!new File(string).exists()) {
            string = SCIDIR + "/../../ACKNOWLEDGEMENTS";
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ScilabAboutBox.createAboutBox(Messages.gettext((String)"About Scilab..."), string);
        } else {
            final String string2 = string;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScilabAboutBox.createAboutBox(Messages.gettext((String)"About Scilab..."), string2);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void createAboutBox(String string, String string2) {
        Window window = null;
        if (ScilabConsole.isExistingConsole()) {
            window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)ScilabConsole.getConsole().getAsSimpleConsole()));
        }
        JDialog jDialog = new JDialog(window);
        jDialog.setIconImage(imageForIcon);
        jDialog.setTitle(Messages.gettext((String)string));
        jDialog.setDefaultCloseOperation(2);
        ScilabSwingUtilities.closeOnEscape(jDialog);
        AboutPanel aboutPanel = new AboutPanel(jDialog, string2);
        jDialog.setContentPane(aboutPanel);
        jDialog.setResizable(false);
        jDialog.pack();
        if (ScilabConsole.isExistingConsole()) {
            jDialog.setLocationRelativeTo((Component)((Object)ScilabConsole.getConsole().getAsSimpleConsole()));
        } else {
            jDialog.setLocation((int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2 - jDialog.getWidth() / 2, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2 - jDialog.getHeight() / 2);
        }
        jDialog.setVisible(true);
        aboutPanel.close.requestFocus();
    }

    private static final class AboutPanel
    extends JPanel {
        private static final String SCIDIR = System.getenv("SCI");
        private static final String IMAGEPATH = SCIDIR + "/modules/gui/images/icons/aboutscilab.png";
        private static final Font FONT = new Font("SansSerif", 0, 10);
        final JDialog parent;
        final String ackFile;
        final ImageIcon background = new ImageIcon(IMAGEPATH);
        private JScrollPane ackScrollPane;
        private JTextPane ackText;
        private JToggleButton acknowledgements;
        JButton close;
        private JPanel topPane;

        public AboutPanel(JDialog jDialog, String string) {
            this.parent = jDialog;
            this.ackFile = string;
            this.initComponents();
        }

        private void initComponents() {
            this.topPane = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(background.getIconWidth(), background.getIconHeight());
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public void paintComponent(Graphics graphics) {
                    graphics.drawImage(background.getImage(), 0, 0, (int)this.getSize().getWidth(), (int)this.getSize().getHeight(), this);
                }
            };
            this.close = new JButton();
            this.acknowledgements = new JToggleButton();
            this.ackScrollPane = new JScrollPane();
            this.ackText = new JTextPane();
            this.ackText.setContentType("text/plain; charset=utf-8");
            this.setLayout(new BorderLayout());
            this.close.setText(Messages.gettext((String)"Close"));
            this.close.setFont(FONT);
            this.close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.closeActionPerformed(actionEvent);
                }
            });
            this.acknowledgements.setText(Messages.gettext((String)"Acknowledgements"));
            this.acknowledgements.setFont(FONT);
            this.acknowledgements.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.acknowledgementsActionPerformed(actionEvent);
                }
            });
            GroupLayout groupLayout = new GroupLayout(this.topPane);
            this.topPane.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.close).addComponent(this.acknowledgements)).addGap(5)));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.acknowledgements).addGap(5).addComponent(this.close).addGap(5)));
            this.add((Component)this.topPane, "First");
            this.ackScrollPane.setViewportView(this.ackText);
            this.ackScrollPane.setPreferredSize(this.topPane.getPreferredSize());
            this.ackScrollPane.setHorizontalScrollBarPolicy(31);
            try {
                URL uRL = new File(this.ackFile).toURI().toURL();
                this.ackText.setPage(uRL);
            }
            catch (IOException iOException) {
                this.acknowledgements.setVisible(false);
            }
            this.ackText.setCaretPosition(0);
        }

        private void closeActionPerformed(ActionEvent actionEvent) {
            this.parent.dispose();
        }

        private void acknowledgementsActionPerformed(ActionEvent actionEvent) {
            if (this.acknowledgements.isSelected()) {
                this.add((Component)this.ackScrollPane, "Center");
            } else {
                this.remove(this.ackScrollPane);
            }
            this.validate();
            this.parent.pack();
        }
    }
}

