/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.gui.filechooser.FileChooserInfos;
import org.scilab.modules.localization.Messages;

public class SciFileFilter
extends FileFilter {
    private String mask;
    private String description;
    private int filterIndex;

    public SciFileFilter(String string, String string2, int n) {
        this.description = string2 == null ? (string.equals("*.sci") ? Messages.gettext((String)"Scilab SCI files") + "(*.sci)" : (string.equals("*.sce") ? Messages.gettext((String)"Scilab SCE files") + "(*.sce)" : (string.equals("*.bin") ? Messages.gettext((String)"Scilab binary files") + "(*.bin)" : (string.equals("*.sc*") ? Messages.gettext((String)"All Scilab files") + "(*.sc*)" : (string.equals("*.xcos") ? Messages.gettext((String)"Xcos files") + "(*.xcos)" : (string.equals("*.cos*") ? Messages.gettext((String)"Scicos files") + "(*.cos*)" : (string.equals("*.tst") ? Messages.gettext((String)"Test files") + "(*.tst)" : (string.equals("*.start") ? Messages.gettext((String)"Scilab Start files") + "(*.start)" : (string.equals("*.quit") ? Messages.gettext((String)"Scilab Quit files") + "(*.quit)" : (string.equals("*.dem") ? Messages.gettext((String)"Scilab Demo files") + "(*.dem)" : (string.equals("all") ? Messages.gettext((String)"All Scilab files") + "(*.sci,*.sce,*.tst,*.start,*.quit,*.dem)" : (string.equals("*.pdf") ? Messages.gettext((String)"All PDF files") + "(*.pdf)" : (string.equals("*.ps") ? Messages.gettext((String)"All Postscript files") + "(*.ps)" : (string.equals("*.eps") ? Messages.gettext((String)"All Encapsulated PS files") + "(*.eps)" : (string.equals("*.png") ? Messages.gettext((String)"All PNG image files") + "(*.png)" : (string.equals("*.rtf") ? Messages.gettext((String)"All RTF (Rich Text Format) files") + "(*.rtf)" : (string.equals("*.html") ? Messages.gettext((String)"All HTML files") + "(*.html)" : (string.equals("*.*") ? Messages.gettext((String)"All files") + "(*.*)" : String.format(Messages.gettext((String)"All %s files"), string))))))))))))))))))) : string2;
        if (string.equals("all")) {
            string = "(*.sci)|(*.sce)|(*.tst)|(*.start)|(*.quit)|(*.dem)";
        }
        this.mask = string.replaceAll("\\.", "\\\\.");
        this.mask = this.mask.replaceAll("\\*", ".\\*");
        this.filterIndex = n;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1 || n == string.length() - 1) {
            return new String("");
        }
        return string.substring(n);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.mask.equals("")) {
            return true;
        }
        if (this.mask.equals(".*\\..*")) {
            int n = this.filterIndex + 1;
            FileChooserInfos.getInstance().setFilterIndex(n);
            return true;
        }
        int n = this.filterIndex + 1;
        FileChooserInfos.getInstance().setFilterIndex(n);
        if (this.isWindows()) {
            Pattern pattern = Pattern.compile(this.mask, 66);
            Matcher matcher = pattern.matcher(file.getName());
            return matcher.find();
        }
        return file.getName().matches(this.mask);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

