/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;

public class HelpSearchField
extends JPanel
implements FocusListener,
KeyListener {
    private static final String SCI = ScilabConstants.SCI.getPath();
    private static final String TAB = "tab";
    private static final String F3 = "F3";
    private static final String KEY = "help-search-field";
    private static final ImageIcon CLOSEICON = new ImageIcon(SCI + "/modules/gui/images/icons/close-tab.png");
    private static final ImageIcon TOPICON = new ImageIcon(FindIconHelper.findIcon((String)"go-top"));
    private static final ImageIcon BOTICON = new ImageIcon(FindIconHelper.findIcon((String)"go-bottom"));
    private static final int BUTTONSIZE = 28;
    private String text;
    private final JTextField field;
    private final JPanel parent;
    private JTextComponent textcomp;
    private final TopBotButtons[] buttons = new TopBotButtons[2];
    private final DefaultHighlighter.DefaultHighlightPainter highlighter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private int currentPos;
    private String currentWord;

    public HelpSearchField(JPanel jPanel, JTextComponent jTextComponent) {
        this(jPanel, jTextComponent, F3);
    }

    public HelpSearchField(JPanel jPanel, JTextComponent jTextComponent, String string) {
        super(new BorderLayout());
        this.parent = jPanel;
        this.setTextComponent(jTextComponent, string);
        this.field = new JTextField();
        this.field.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.field.getInputMap().put(KeyStroke.getKeyStroke(9, 0), TAB);
        this.field.getActionMap().put(TAB, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSearchField.this.textcomp.requestFocus();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(new CloseButton());
        jPanel2.add(new TopBotButtons(true));
        jPanel2.add(new TopBotButtons(false));
        this.add((Component)jPanel2, "West");
        this.add((Component)this.field, "Center");
        this.setVisible(false);
    }

    public void setTextComponent(JTextComponent jTextComponent) {
        this.setTextComponent(jTextComponent, F3);
    }

    public void setTextComponent(JTextComponent jTextComponent, String string) {
        this.textcomp = jTextComponent;
        if (jTextComponent != null) {
            jTextComponent.getInputMap(2).put(ScilabKeyStroke.getKeyStroke((String)string), KEY);
            jTextComponent.getActionMap().put(KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpSearchField.this.showField();
                }
            });
        }
        this.text = null;
        this.currentPos = 0;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        if (this.textcomp != null) {
            this.textcomp.getInputMap(2).put(keyStroke, KEY);
        }
    }

    private void getText() {
        if (this.text == null) {
            Document document = this.textcomp.getDocument();
            try {
                this.text = document.getText(0, document.getLength()).toLowerCase();
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
        }
    }

    @Override
    public void requestFocus() {
        this.field.requestFocus();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.getText();
        this.field.select(0, this.field.getText().length());
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.text = null;
        this.textcomp.getHighlighter().removeAllHighlights();
    }

    public void removeListeners() {
        this.field.removeFocusListener(this);
        this.field.removeKeyListener(this);
    }

    public void hideField() {
        this.parent.requestFocus();
        this.removeListeners();
        this.textcomp.getHighlighter().removeAllHighlights();
        this.setVisible(false);
        this.parent.remove(this);
    }

    public void showField() {
        if (!this.isVisible()) {
            this.currentPos = 0;
            this.field.addKeyListener(this);
            this.field.addFocusListener(this);
            this.parent.add((Component)this, "Last");
            this.setVisible(true);
        }
        this.requestFocus();
    }

    public void highlightText(int n, int n2) {
        if (n != -1) {
            try {
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.textcomp);
                if (jScrollPane != null) {
                    final Rectangle rectangle = this.textcomp.modelToView(n);
                    final JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                    final int n3 = jScrollBar.getValue();
                    final int n4 = jScrollBar.getHeight();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (rectangle.y < n3 || rectangle.y > n3 + n4) {
                                jScrollBar.setValue(Math.max(0, rectangle.y - n4 / 2));
                            }
                        }
                    });
                }
                this.textcomp.getHighlighter().removeAllHighlights();
                this.textcomp.getHighlighter().addHighlight(n, n2, this.highlighter);
                this.currentPos = n;
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
            this.field.setForeground(Color.BLACK);
        } else {
            this.field.setForeground(Color.RED);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        String string;
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.hideField();
            return;
        }
        if (n != 37 && n != 39 && n != 38 && n != 40 && n != 16 && (string = this.field.getText()) != null) {
            int n2;
            if (!(string = string.toLowerCase()).equals(this.currentWord)) {
                this.currentWord = string;
                this.currentPos = 0;
                this.textcomp.getHighlighter().removeAllHighlights();
            }
            this.getText();
            if ((n == 10 || n == 114) && (keyEvent.getModifiers() & 1) != 0) {
                this.currentPos = Math.max(0, this.currentPos - 1);
                n2 = this.text.lastIndexOf(string, this.currentPos);
                if (n2 == -1) {
                    this.currentPos = this.text.length() - 1;
                }
                keyEvent.consume();
            } else {
                if (n == 10 || n == 114) {
                    ++this.currentPos;
                }
                if ((n2 = this.text.indexOf(string, this.currentPos)) == -1) {
                    this.currentPos = 0;
                }
            }
            int n3 = n2 + string.length();
            if (n2 != n3) {
                this.highlightText(n2, n3);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    class TopBotButtons
    extends JButton {
        TopBotButtons(final boolean bl) {
            super(bl ? TOPICON : BOTICON);
            this.setFocusable(false);
            this.setContentAreaFilled(true);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            this.setPreferredSize(new Dimension(28, 28));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = HelpSearchField.this.field.getText();
                    String string2 = "";
                    Document document = HelpSearchField.this.textcomp.getDocument();
                    try {
                        string2 = document.getText(0, document.getLength()).toLowerCase();
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println(badLocationException);
                    }
                    if (string != null && !string.isEmpty()) {
                        int n;
                        string = string.toLowerCase();
                        if (bl) {
                            HelpSearchField.this.currentPos = Math.max(0, HelpSearchField.this.currentPos - 1);
                            n = string2.lastIndexOf(string, HelpSearchField.this.currentPos);
                            if (n == -1) {
                                HelpSearchField.this.currentPos = HelpSearchField.this.text.length() - 1;
                            }
                        } else {
                            HelpSearchField.this.currentPos++;
                            n = string2.indexOf(string, HelpSearchField.this.currentPos);
                            if (n == -1) {
                                HelpSearchField.this.currentPos = 0;
                            }
                        }
                        HelpSearchField.this.highlightText(n, n + string.length());
                    }
                }
            });
        }
    }

    class CloseButton
    extends JButton {
        CloseButton() {
            super(CLOSEICON);
            this.setFocusable(false);
            this.setContentAreaFilled(true);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            this.setPreferredSize(new Dimension(28, 28));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpSearchField.this.hideField();
                }
            });
        }
    }
}

