/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ConfigManager {
    private static final int BUFSIZE = 1024;
    private static final int MARGIN = 20;
    private static final String ERROR_READ = "Could not load file: ";
    private static final String ERROR_WRITE = "Could not save file: ";
    private static final String VERSION = "version";
    private static final String VALUE = "value";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String XCOORD = "x";
    private static final String YCOORD = "y";
    private static final String MAINWINPOSITION = "MainWindowPosition";
    private static final String MAINWINSIZE = "MainWindowSize";
    private static final String HELPWINPOSITION = "HelpWindowPosition";
    private static final String HELPWINSIZE = "HelpWindowSize";
    private static final String HELPFONTSIZE = "HelpFontSize";
    private static final String HELPBROWSER = "HelpBrowser";
    private static final String PROFILE = "Profile";
    private static final String FOREGROUNDCOLOR = "ForegroundColor";
    private static final String BACKGROUNDCOLOR = "BackgroundColor";
    private static final String COLORPREFIX = "#";
    private static final String MAXOUTPUTSIZE = "MaxOutputSize";
    private static final String LASTOPENEDDIR = "LastOpenedDirectory";
    private static final String INDEX = "index";
    private static final String SCILAB_CONFIG_FILE = System.getenv("SCI") + "/modules/console/etc/configuration.xml";
    private static String USER_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/configuration.xml";
    private static final int DEFAULT_WIDTH = 650;
    private static final int DEFAULT_HEIGHT = 550;
    private static final int DEFAULT_MAXOUTPUTSIZE = 10000;
    private static final int DEFAULT_HELPFONTSIZE = 2;
    private static Document document;
    private static boolean updated;
    private static boolean mustSave;

    private ConfigManager() {
        throw new UnsupportedOperationException();
    }

    public static void createUserCopy() {
        File file;
        if (mustSave && (!(file = new File(USER_CONFIG_FILE)).exists() || file.length() == 0L || ConfigManager.checkVersion())) {
            updated = ScilabCommonsUtils.copyFile((File)new File(SCILAB_CONFIG_FILE), (File)new File(USER_CONFIG_FILE));
        }
    }

    public static boolean checkVersion() {
        Document document;
        Element element;
        String string;
        if (updated) {
            return false;
        }
        File file = new File(USER_CONFIG_FILE);
        if (file.exists() && (string = (element = (document = ScilabXMLUtilities.readDocument((String)USER_CONFIG_FILE)).getDocumentElement()).getAttribute(VERSION)) != null && string.length() != 0) {
            float f = Float.parseFloat(string);
            document = ScilabXMLUtilities.readDocument((String)SCILAB_CONFIG_FILE);
            element = document.getDocumentElement();
            string = element.getAttribute(VERSION);
            if (string != null && string.length() != 0) {
                float f2 = Float.parseFloat(string);
                return f != f2;
            }
        }
        return true;
    }

    public static String getUserConfigFile() {
        return USER_CONFIG_FILE;
    }

    public static void saveFont(Font font) {
        ConfigManager.readDocument();
        if (document != null) {
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)"FontSize", (Object[])new Object[]{VALUE, font.getSize()});
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)"FontName", (Object[])new Object[]{VALUE, font.getFontName()});
            String string = !font.isBold() && !font.isItalic() ? "0" : (font.isBold() && font.isItalic() ? "3" : (font.isBold() ? "1" : "2"));
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)"FontStyle", (Object[])new Object[]{VALUE, string});
            ConfigManager.writeDocument();
        }
    }

    public static int getMaxOutputSize() {
        Object[] objectArray;
        Element element;
        ConfigManager.readDocument();
        if (document != null && (element = ScilabXMLUtilities.readNodeAttributes((Document)document, (String)MAXOUTPUTSIZE, (Object[])(objectArray = new Object[]{VALUE, Integer.TYPE}))) != null) {
            return (Integer)objectArray[1];
        }
        return 10000;
    }

    public static int getHelpFontSize() {
        Object[] objectArray;
        Element element;
        ConfigManager.readDocument();
        if (document != null && (element = ScilabXMLUtilities.readNodeAttributes((Document)document, (String)HELPFONTSIZE, (Object[])(objectArray = new Object[]{VALUE, Integer.TYPE}))) != null) {
            return (Integer)objectArray[1];
        }
        return 2;
    }

    public static void setHelpFontSize(int n) {
        ConfigManager.readDocument();
        if (document != null) {
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)HELPFONTSIZE, (Object[])new Object[]{VALUE, n});
            ConfigManager.writeDocument();
        }
    }

    public static void saveHelpBrowserState(String string) {
        ConfigManager.readDocument();
        if (document != null) {
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)HELPBROWSER, (Object[])new Object[]{INDEX, string});
            ConfigManager.writeDocument();
        }
    }

    public static String getHelpBrowserState() {
        Object[] objectArray;
        Element element;
        ConfigManager.readDocument();
        if (document != null && (element = ScilabXMLUtilities.readNodeAttributes((Document)document, (String)HELPBROWSER, (Object[])(objectArray = new Object[]{INDEX, String.class}))) != null) {
            return (String)objectArray[1];
        }
        return null;
    }

    public static void saveLastOpenedDirectory(String string) {
        ConfigManager.readDocument();
        if (document != null) {
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)LASTOPENEDDIR, (Object[])new Object[]{VALUE, string});
            ConfigManager.writeDocument();
        }
    }

    public static String getLastOpenedDirectory() {
        ConfigManager.readDocument();
        String string = new String();
        if (document != null) {
            Object[] objectArray = new Object[]{VALUE, String.class};
            Element element = ScilabXMLUtilities.readNodeAttributes((Document)document, (String)LASTOPENEDDIR, (Object[])objectArray);
            if (element != null) {
                string = (String)objectArray[1];
            }
            if (element == null || string.isEmpty()) {
                string = System.getProperty("user.dir");
                ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)LASTOPENEDDIR, (Object[])new Object[]{VALUE, string, "useCache", "true"});
                ConfigManager.writeDocument();
            }
        }
        return string;
    }

    public static void saveConsoleForeground(Color color) {
        ConfigManager.readDocument();
        if (document != null) {
            String string = Integer.toHexString(color.getRGB());
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)FOREGROUNDCOLOR, (Object[])new Object[]{VALUE, COLORPREFIX + string.substring(2, string.length())});
            ConfigManager.writeDocument();
        }
    }

    public static void saveConsoleBackground(Color color) {
        ConfigManager.readDocument();
        if (document != null) {
            String string = Integer.toHexString(color.getRGB());
            ScilabXMLUtilities.replaceNamedNode((Document)document, (String)PROFILE, (String)BACKGROUNDCOLOR, (Object[])new Object[]{VALUE, COLORPREFIX + string.substring(2, string.length())});
            ConfigManager.writeDocument();
        }
    }

    private static void readDocument() {
        ConfigManager.createUserCopy();
        document = ScilabXMLUtilities.readDocument((String)USER_CONFIG_FILE);
    }

    private static void writeDocument() {
        if (mustSave) {
            ScilabXMLUtilities.writeDocument((Document)document, (String)USER_CONFIG_FILE);
        }
    }

    static {
        mustSave = true;
        if (ScilabConstants.SCIHOME != null && ScilabConstants.SCIHOME.canRead() && ScilabConstants.SCIHOME.canWrite()) {
            USER_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/configuration.xml";
        } else {
            USER_CONFIG_FILE = SCILAB_CONFIG_FILE;
            mustSave = false;
        }
    }
}

