/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.Tab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.SciClosingAction;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.gui.window.Window;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;

public class ClosingOperationsManager {
    private static final String EXIT_CONFIRM = Messages.gettext((String)"Are you sure you want to close %s ?");
    private static final String EXIT_CONFIRM_AND = Messages.gettext((String)"Are you sure you want to close %s and %s ?");
    private static final String DONT_SHOW = Messages.gettext((String)"Do not show this message again");
    private static final String CONFIRMATION_PATH = "//general/confirmation-dialogs/body/tools/tool[@id='console-exit']";
    private static final String EXIT = Messages.gettext((String)"Exit");
    private static final String NULLUUID = new UUID(0L, 0L).toString();
    private static final Map<SwingScilabDockablePanel, ClosingOperation> closingOps = new HashMap<SwingScilabDockablePanel, ClosingOperation>();
    private static final Map<SwingScilabDockablePanel, List<SwingScilabDockablePanel>> deps = new HashMap<SwingScilabDockablePanel, List<SwingScilabDockablePanel>>();
    private static final List<SwingScilabDockablePanel> dunnoList = new ArrayList<SwingScilabDockablePanel>();
    private static List<SwingScilabDockablePanel> savedList;
    private static boolean savedMustSave;
    private static SwingScilabDockablePanel root;

    public static void registerClosingOperation(SwingScilabDockablePanel swingScilabDockablePanel, ClosingOperation closingOperation) {
        if (swingScilabDockablePanel != null) {
            closingOps.put(swingScilabDockablePanel, closingOperation);
        }
    }

    public static void registerClosingOperation(Tab tab, ClosingOperation closingOperation) {
        if (tab != null) {
            ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)tab.getAsSimpleTab(), closingOperation);
        }
    }

    public static void unregisterClosingOperation(SwingScilabDockablePanel swingScilabDockablePanel) {
        if (swingScilabDockablePanel != null) {
            closingOps.remove(swingScilabDockablePanel);
        }
    }

    public static void checkTabForClosing(SwingScilabDockablePanel swingScilabDockablePanel) {
        if (swingScilabDockablePanel != null && !dunnoList.isEmpty()) {
            if (dunnoList.contains(swingScilabDockablePanel)) {
                dunnoList.remove(swingScilabDockablePanel);
            }
            if (dunnoList.isEmpty() && savedList != null) {
                ClosingOperationsManager.close(savedList, null, false, savedMustSave);
                savedList = null;
                savedMustSave = false;
            }
        }
    }

    public static void removeFromDunnoList(SwingScilabDockablePanel swingScilabDockablePanel) {
        if (swingScilabDockablePanel != null && !dunnoList.isEmpty() && dunnoList.contains(swingScilabDockablePanel)) {
            dunnoList.remove(swingScilabDockablePanel);
        }
    }

    public static boolean startClosingOperationOnRoot() {
        if (!GraphicsEnvironment.isHeadless()) {
            if (root != null) {
                SwingScilabWindow swingScilabWindow = ClosingOperationsManager.getWindow(root);
                if (swingScilabWindow == null) {
                    return true;
                }
                return ClosingOperationsManager.startClosingOperation(swingScilabWindow, true, true);
            }
            if (deps.get(null).size() != 0) {
                ArrayList<SwingScilabDockablePanel> arrayList = new ArrayList<SwingScilabDockablePanel>();
                for (SwingScilabDockablePanel swingScilabDockablePanel : deps.get(null)) {
                    ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel, arrayList);
                }
                return ClosingOperationsManager.close(arrayList, null, true, true);
            }
            return true;
        }
        return true;
    }

    public static void forceClosingOperationOnRoot() {
        if (root != null) {
            SwingScilabWindow swingScilabWindow = ClosingOperationsManager.getWindow(root);
            if (swingScilabWindow == null) {
                return;
            }
            ClosingOperationsManager.startClosingOperation(swingScilabWindow, false, false);
        } else if (deps.get(null).size() != 0) {
            ArrayList<SwingScilabDockablePanel> arrayList = new ArrayList<SwingScilabDockablePanel>();
            for (SwingScilabDockablePanel swingScilabDockablePanel : deps.get(null)) {
                ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel, arrayList);
            }
            ClosingOperationsManager.close(arrayList, null, false, false);
        }
    }

    public static boolean startClosingOperation(SwingScilabDockablePanel swingScilabDockablePanel) {
        return ClosingOperationsManager.close(ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel), ClosingOperationsManager.getWindow(swingScilabDockablePanel), true, true);
    }

    public static boolean startClosingOperation(Tab tab) {
        return ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)tab.getAsSimpleTab());
    }

    public static boolean startClosingOperation(SwingScilabDockablePanel swingScilabDockablePanel, boolean bl, boolean bl2) {
        return ClosingOperationsManager.close(ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel), ClosingOperationsManager.getWindow(swingScilabDockablePanel), bl, bl2);
    }

    public static boolean startClosingOperation(List<SwingScilabDockablePanel> list, boolean bl, boolean bl2) {
        SwingScilabWindow swingScilabWindow = list.isEmpty() ? null : ClosingOperationsManager.getWindow(list.get(0));
        return ClosingOperationsManager.close(ClosingOperationsManager.collectTabsToClose(list), swingScilabWindow, bl, bl2);
    }

    public static boolean startClosingOperation(Tab tab, boolean bl, boolean bl2) {
        return ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)tab.getAsSimpleTab(), bl, bl2);
    }

    public static boolean startClosingOperationWithoutSave(SwingScilabDockablePanel swingScilabDockablePanel) {
        return ClosingOperationsManager.close(ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel), ClosingOperationsManager.getWindow(swingScilabDockablePanel), true, false);
    }

    public static boolean startClosingOperationWithoutSave(Tab tab) {
        return ClosingOperationsManager.startClosingOperationWithoutSave((SwingScilabDockablePanel)tab.getAsSimpleTab());
    }

    public static boolean startClosingOperation(SwingScilabWindow swingScilabWindow) {
        return ClosingOperationsManager.startClosingOperation(swingScilabWindow, true, true);
    }

    public static boolean startClosingOperation(SwingScilabWindow swingScilabWindow, boolean bl, boolean bl2) {
        try {
            if (swingScilabWindow != null) {
                ArrayList<SwingScilabDockablePanel> arrayList = new ArrayList<SwingScilabDockablePanel>();
                if (swingScilabWindow.getDockingPort() != null) {
                    Object[] objectArray = swingScilabWindow.getDockingPort().getDockables().toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ClosingOperationsManager.collectTabsToClose((SwingScilabDockablePanel)objectArray[i], arrayList);
                    }
                    return ClosingOperationsManager.close(arrayList, swingScilabWindow, bl, bl2);
                }
                swingScilabWindow.close();
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static boolean startClosingOperation(Window window, boolean bl, boolean bl2) {
        return ClosingOperationsManager.startClosingOperation((SwingScilabWindow)window.getAsSimpleWindow(), bl, bl2);
    }

    public static void addDependency(SwingScilabDockablePanel swingScilabDockablePanel, SwingScilabDockablePanel swingScilabDockablePanel2) {
        if (swingScilabDockablePanel != null && swingScilabDockablePanel2 != null) {
            List<SwingScilabDockablePanel> list = deps.get(swingScilabDockablePanel);
            if (list == null) {
                list = new ArrayList<SwingScilabDockablePanel>();
                deps.put(swingScilabDockablePanel, list);
            }
            list.add(swingScilabDockablePanel2);
        }
    }

    public static void removeDependency(SwingScilabDockablePanel swingScilabDockablePanel) {
        for (SwingScilabDockablePanel swingScilabDockablePanel2 : deps.keySet()) {
            List<SwingScilabDockablePanel> list = deps.get(swingScilabDockablePanel2);
            if (list == null) continue;
            list.remove(swingScilabDockablePanel);
        }
    }

    public static void addDependency(Tab tab, Tab tab2) {
        if (tab != null && tab2 != null) {
            ClosingOperationsManager.addDependency((SwingScilabDockablePanel)tab.getAsSimpleTab(), (SwingScilabDockablePanel)tab2.getAsSimpleTab());
        }
    }

    public static void addDependency(SwingScilabDockablePanel swingScilabDockablePanel, Tab tab) {
        if (swingScilabDockablePanel != null && tab != null) {
            ClosingOperationsManager.addDependency(swingScilabDockablePanel, (SwingScilabDockablePanel)tab.getAsSimpleTab());
        }
    }

    public static void addDependency(Tab tab, SwingScilabDockablePanel swingScilabDockablePanel) {
        if (tab != null && swingScilabDockablePanel != null) {
            ClosingOperationsManager.addDependency((SwingScilabDockablePanel)tab.getAsSimpleTab(), swingScilabDockablePanel);
        }
    }

    public static void addDependencyWithRoot(SwingScilabDockablePanel swingScilabDockablePanel) {
        if (swingScilabDockablePanel != null) {
            ClosingOperationsManager.addDependency(root, swingScilabDockablePanel);
        }
    }

    public static void addDependencyWithRoot(Tab tab) {
        if (tab != null) {
            ClosingOperationsManager.addDependency(root, (SwingScilabDockablePanel)tab.getAsSimpleTab());
        }
    }

    public static void setRoot(SwingScilabDockablePanel swingScilabDockablePanel) {
        List<SwingScilabDockablePanel> list = deps.get(root);
        deps.remove(root);
        deps.put(swingScilabDockablePanel, list);
        root = swingScilabDockablePanel;
    }

    public static void setRoot(Tab tab) {
        ClosingOperationsManager.setRoot((SwingScilabDockablePanel)tab.getAsSimpleTab());
    }

    private static SwingScilabDockablePanel getParent(SwingScilabDockablePanel swingScilabDockablePanel) {
        for (SwingScilabDockablePanel swingScilabDockablePanel2 : deps.keySet()) {
            List<SwingScilabDockablePanel> list = deps.get(swingScilabDockablePanel2);
            if (list == null || !list.contains(swingScilabDockablePanel)) continue;
            return swingScilabDockablePanel2;
        }
        return null;
    }

    public static SwingScilabDockablePanel getElderTab(List<SwingScilabDockablePanel> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        SwingScilabDockablePanel swingScilabDockablePanel = null;
        for (SwingScilabDockablePanel swingScilabDockablePanel2 : list) {
            int n2 = 0;
            SwingScilabDockablePanel swingScilabDockablePanel3 = ClosingOperationsManager.getParent(swingScilabDockablePanel2);
            while (swingScilabDockablePanel3 != null) {
                ++n2;
                swingScilabDockablePanel3 = ClosingOperationsManager.getParent(swingScilabDockablePanel3);
            }
            if (n2 >= n) continue;
            swingScilabDockablePanel = swingScilabDockablePanel2;
            n = n2;
        }
        return swingScilabDockablePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean close(List<SwingScilabDockablePanel> list, SwingScilabWindow swingScilabWindow, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (bl) {
            if (!ClosingOperationsManager.canClose(list, swingScilabWindow, bl2)) return bl3;
        }
        bl3 = true;
        SwingScilabDockablePanel hashMap = null;
        try {
            Object object32;
            Object object2;
            for (SwingScilabDockablePanel object62 : list) {
                if (!object62.getPersistentId().equals(NULLUUID)) continue;
                hashMap = object62;
                break;
            }
            ArrayList arrayList = new ArrayList();
            for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
                if (closingOps.get(swingScilabDockablePanel) != null) continue;
                swingScilabDockablePanel.setVisible(false);
                swingScilabDockablePanel.getActionButton("undock").getAction().actionPerformed(null);
                Action action = ((SciClosingAction)swingScilabDockablePanel.getActionButton("close").getAction()).getAction();
                if (action == null) {
                    object2 = ClosingOperationsManager.getWindow(swingScilabDockablePanel);
                    if (object2 != null) {
                        ((SwingScilabWindow)object2).removeTabs(new SwingScilabDockablePanel[]{swingScilabDockablePanel});
                    }
                } else {
                    action.actionPerformed(null);
                }
                arrayList.add(swingScilabDockablePanel);
            }
            list.removeAll(arrayList);
            HashMap hashMap2 = new HashMap();
            for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
                object2 = ClosingOperationsManager.getWindow(swingScilabDockablePanel);
                if (object2 == null) continue;
                if (!hashMap2.containsKey(object2)) {
                    hashMap2.put((Iterator<SwingScilabDockablePanel>)object2, new ArrayList());
                }
                ((List)hashMap2.get(object2)).add(swingScilabDockablePanel);
            }
            ArrayList<SwingScilabWindow> arrayList2 = new ArrayList<SwingScilabWindow>();
            ArrayList<SwingScilabWindow> arrayList3 = new ArrayList<SwingScilabWindow>();
            for (SwingScilabWindow swingScilabWindow2 : hashMap2.keySet()) {
                object32 = (List)hashMap2.get(swingScilabWindow2);
                int n = swingScilabWindow2.getNbDockedObjects();
                if (n == object32.size()) {
                    if (bl2) {
                        WindowsConfigurationManager.saveWindowProperties(swingScilabWindow2);
                    }
                    arrayList3.add(swingScilabWindow2);
                    continue;
                }
                if (n - object32.size() == 1) {
                    arrayList2.add(swingScilabWindow2);
                }
                if (!bl2) continue;
                Iterator iterator = object32.iterator();
                while (iterator.hasNext()) {
                    SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)iterator.next();
                    WindowsConfigurationManager.saveTabProperties(swingScilabDockablePanel, true);
                }
            }
            for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
                object32 = ClosingOperationsManager.getParent(swingScilabDockablePanel);
                if (list.contains(object32) || object32 == null) {
                    if (object32 != null) {
                        WindowsConfigurationManager.makeDependency(object32.getPersistentId(), swingScilabDockablePanel.getPersistentId());
                        continue;
                    }
                    if (swingScilabDockablePanel.getPersistentId().equals(NULLUUID)) continue;
                    WindowsConfigurationManager.makeDependency(NULLUUID, swingScilabDockablePanel.getPersistentId());
                    continue;
                }
                WindowsConfigurationManager.removeDependency(swingScilabDockablePanel.getPersistentId());
            }
            WindowsConfigurationManager.clean();
            for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
                swingScilabDockablePanel.setVisible(false);
                if (swingScilabDockablePanel.getPersistentId().equals(NULLUUID)) continue;
                try {
                    closingOps.get(swingScilabDockablePanel).destroy();
                    if (swingScilabDockablePanel == hashMap) continue;
                    closingOps.remove(swingScilabDockablePanel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (SwingScilabWindow swingScilabWindow3 : hashMap2.keySet()) {
                swingScilabWindow3.removeTabs(((List)hashMap2.get(swingScilabWindow3)).toArray(new SwingScilabDockablePanel[0]));
            }
            for (SwingScilabWindow swingScilabWindow4 : arrayList2) {
                object32 = swingScilabWindow4.getDockingPort().getDockables().toArray();
                SwingScilabDockablePanel.removeActions((SwingScilabDockablePanel)object32[0]);
            }
            while (arrayList3.size() != 0) {
                object2 = new ArrayList();
                for (Object object32 : arrayList3) {
                    WindowsConfigurationManager.removeWin(((SwingScilabWindow)object32).getUUID());
                    if (((Component)object32).isDisplayable()) {
                        Thread.yield();
                        continue;
                    }
                    object2.add(object32);
                }
                arrayList3.removeAll((Collection<?>)object2);
            }
            for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
                ScilabTabFactory.getInstance().removeFromCache(swingScilabDockablePanel.getPersistentId());
                object32 = ClosingOperationsManager.getParent(swingScilabDockablePanel);
                List<SwingScilabDockablePanel> list2 = deps.get(object32);
                if (list2 != null) {
                    list2.remove(swingScilabDockablePanel);
                }
                deps.remove(swingScilabDockablePanel);
            }
            if (hashMap == null) return bl3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl3;
        }
        try {
            closingOps.get(hashMap).destroy();
            closingOps.remove(hashMap);
            return bl3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl3;
        }
        finally {
            if (hashMap != null) {
                try {
                    closingOps.get(hashMap).destroy();
                    closingOps.remove(hashMap);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static final boolean canClose(List<SwingScilabDockablePanel> list, SwingScilabWindow swingScilabWindow, boolean bl) {
        Object object;
        CheckExitConfirmation checkExitConfirmation = ((CheckExitConfirmation[])XConfiguration.get(CheckExitConfirmation.class, (Document)XConfiguration.getXConfigurationDocument(), (String)CONFIRMATION_PATH))[0];
        dunnoList.clear();
        savedList = null;
        savedMustSave = false;
        if (checkExitConfirmation.checked) {
            Iterator<SwingScilabDockablePanel> iterator = ClosingOperationsManager.makeQuestion(list);
            final boolean[] object22 = new boolean[1];
            object = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    object22[0] = ((JCheckBox)actionEvent.getSource()).isSelected();
                }
            };
            if (iterator != null) {
                final Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (ScilabModalDialog.show(swingScilabWindow, new String[]{iterator}, EXIT, ScilabModalDialog.IconType.WARNING_ICON, ScilabModalDialog.ButtonType.YES_NO, DONT_SHOW, (Action)object) == ScilabModalDialog.AnswerOption.NO_OPTION) {
                    if (object22[0]) {
                        XConfiguration.set((Document)XConfiguration.getXConfigurationDocument(), (String)"//general/confirmation-dialogs/body/tools/tool[@id='console-exit']/@state", (String)"unchecked");
                    }
                    if (component != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                component.requestFocus();
                            }
                        });
                    }
                    return false;
                }
            }
            if (object22[0]) {
                XConfiguration.set((Document)XConfiguration.getXConfigurationDocument(), (String)"//general/confirmation-dialogs/body/tools/tool[@id='console-exit']/@state", (String)"unchecked");
            }
        }
        for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
            object = closingOps.get(swingScilabDockablePanel);
            if (object == null) continue;
            int n = object.canClose();
            if (n == 0) {
                dunnoList.clear();
                return false;
            }
            if (n != -1) continue;
            dunnoList.add(swingScilabDockablePanel);
        }
        if (dunnoList.isEmpty()) {
            return true;
        }
        for (SwingScilabDockablePanel swingScilabDockablePanel : dunnoList) {
            list.remove(swingScilabDockablePanel);
        }
        savedList = list;
        savedMustSave = bl;
        return false;
    }

    private static final String makeQuestion(List<SwingScilabDockablePanel> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<SwingScilabDockablePanel> list2 = Collections.unmodifiableList(list);
        for (SwingScilabDockablePanel object2 : list) {
            String string2;
            ClosingOperation closingOperation = closingOps.get(object2);
            if (closingOperation == null || (string2 = closingOperation.askForClosing(list2)) == null || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        switch (arrayList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return String.format(EXIT_CONFIRM, arrayList.get(0));
            }
        }
        Object object3 = (String)arrayList.remove(0);
        String string = (String)arrayList.remove(arrayList.size() - 1);
        for (String string2 : arrayList) {
            object3 = (String)object3 + ", " + string2;
        }
        return String.format(EXIT_CONFIRM_AND, object3, string);
    }

    private static final void collectTabsToClose(SwingScilabDockablePanel swingScilabDockablePanel, List<SwingScilabDockablePanel> list) {
        List<SwingScilabDockablePanel> list2 = deps.get(swingScilabDockablePanel);
        if (list2 != null) {
            for (SwingScilabDockablePanel object2 : list2) {
                ClosingOperationsManager.collectTabsToClose(object2, list);
            }
        }
        if (!list.contains(swingScilabDockablePanel)) {
            list.add(swingScilabDockablePanel);
        }
        List<SwingScilabDockablePanel> list3 = Collections.unmodifiableList(list);
        ListIterator<SwingScilabDockablePanel> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            SwingScilabDockablePanel swingScilabDockablePanel2 = listIterator.next();
            ClosingOperation closingOperation = closingOps.get(swingScilabDockablePanel2);
            if (closingOperation == null) continue;
            closingOperation.updateDependencies(list3, listIterator);
        }
    }

    private static final List<SwingScilabDockablePanel> collectTabsToClose(SwingScilabDockablePanel swingScilabDockablePanel) {
        ArrayList<SwingScilabDockablePanel> arrayList = new ArrayList<SwingScilabDockablePanel>();
        ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel, arrayList);
        return arrayList;
    }

    private static final List<SwingScilabDockablePanel> collectTabsToClose(List<SwingScilabDockablePanel> list) {
        ArrayList<SwingScilabDockablePanel> arrayList = new ArrayList<SwingScilabDockablePanel>();
        for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
            ClosingOperationsManager.collectTabsToClose(swingScilabDockablePanel, arrayList);
        }
        return arrayList;
    }

    private static final SwingScilabWindow getWindow(SwingScilabDockablePanel swingScilabDockablePanel) {
        return (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)swingScilabDockablePanel));
    }

    static {
        deps.put(null, new ArrayList());
    }

    @XConfiguration.XConfAttribute
    private static class CheckExitConfirmation {
        public boolean checked;

        private CheckExitConfirmation() {
        }

        @XConfiguration.XConfAttribute(attributes={"state"})
        private void set(String string) {
            this.checked = string.equals("checked");
        }
    }

    public static interface ClosingOperation {
        public int canClose();

        public void destroy();

        public String askForClosing(List<SwingScilabDockablePanel> var1);

        public void updateDependencies(List<SwingScilabDockablePanel> var1, ListIterator<SwingScilabDockablePanel> var2);
    }
}

