/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorder;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorderType;

public class BorderConvertor {
    public static Color getColor(String string) {
        try {
            if (string.charAt(0) == '#') {
                return Color.decode(string);
            }
            Field field = Class.forName("java.awt.Color").getField(string);
            return (Color)field.get(null);
        }
        catch (Exception exception) {
            return Color.black;
        }
    }

    public static Border getBorder(Integer n) {
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = (Integer)graphicController.getProperty(n, 391);
        FrameBorderType frameBorderType = n2 == null ? FrameBorderType.NONE : FrameBorderType.intToEnum((Integer)n2);
        Border border = null;
        switch (frameBorderType) {
            case BEVEL: {
                FrameBorder.BorderType borderType = FrameBorder.BorderType.intToEnum((Integer)((Integer)graphicController.getProperty(n, 395)));
                int n3 = borderType == FrameBorder.BorderType.LOWERED ? 1 : 0;
                String string = (String)graphicController.getProperty(n, 382);
                String string2 = (String)graphicController.getProperty(n, 381);
                String string3 = (String)graphicController.getProperty(n, 388);
                String string4 = (String)graphicController.getProperty(n, 387);
                if (string != null && string3 != null) {
                    if (string2 != null && string4 != null) {
                        border = BorderFactory.createBevelBorder(n3, BorderConvertor.getColor(string), BorderConvertor.getColor(string2), BorderConvertor.getColor(string3), BorderConvertor.getColor(string4));
                        break;
                    }
                    border = BorderFactory.createBevelBorder(n3, BorderConvertor.getColor(string), BorderConvertor.getColor(string3));
                    break;
                }
                border = BorderFactory.createBevelBorder(n3);
                break;
            }
            case COMPOUND: {
                Integer n4 = (Integer)graphicController.getProperty(n, 385);
                Integer n5 = (Integer)graphicController.getProperty(n, 383);
                if (n4 != null && n5 != null) {
                    Border border2 = BorderConvertor.getBorder(n4);
                    Border border3 = BorderConvertor.getBorder(n5);
                    border = BorderFactory.createCompoundBorder(border2, border3);
                    break;
                }
                border = BorderFactory.createCompoundBorder();
                break;
            }
            case EMPTY: {
                Double[] doubleArray = (Double[])graphicController.getProperty(n, 80);
                if (doubleArray != null) {
                    border = BorderFactory.createEmptyBorder(doubleArray[0].intValue(), doubleArray[1].intValue(), doubleArray[2].intValue(), doubleArray[3].intValue());
                    break;
                }
                border = BorderFactory.createEmptyBorder();
                break;
            }
            case ETCHED: {
                int n6;
                Integer n7 = (Integer)graphicController.getProperty(n, 395);
                String string = (String)graphicController.getProperty(n, 382);
                String string5 = (String)graphicController.getProperty(n, 388);
                if (n7 == null) {
                    if (string != null && string5 != null) {
                        border = BorderFactory.createEtchedBorder(BorderConvertor.getColor(string), BorderConvertor.getColor(string5));
                        break;
                    }
                    border = BorderFactory.createEtchedBorder();
                    break;
                }
                FrameBorder.BorderType borderType = FrameBorder.BorderType.intToEnum((Integer)n7);
                int n8 = n6 = borderType == FrameBorder.BorderType.RAISED ? 0 : 1;
                if (string != null && string5 != null) {
                    border = BorderFactory.createEtchedBorder(n6, BorderConvertor.getColor(string), BorderConvertor.getColor(string5));
                    break;
                }
                border = BorderFactory.createEtchedBorder(n6);
                break;
            }
            case LINE: {
                String string = (String)graphicController.getProperty(n, 380);
                Integer n9 = (Integer)graphicController.getProperty(n, 191);
                Boolean bl = (Boolean)graphicController.getProperty(n, 386);
                if (n9 != null) {
                    if (bl != null) {
                        border = BorderFactory.createLineBorder(BorderConvertor.getColor(string), n9);
                        break;
                    }
                    border = BorderFactory.createLineBorder(BorderConvertor.getColor(string), n9);
                    break;
                }
                border = BorderFactory.createLineBorder(BorderConvertor.getColor(string));
                break;
            }
            case MATTE: {
                Double[] doubleArray = (Double[])graphicController.getProperty(n, 80);
                String string = (String)graphicController.getProperty(n, 380);
                border = BorderFactory.createMatteBorder(doubleArray[0].intValue(), doubleArray[1].intValue(), doubleArray[2].intValue(), doubleArray[3].intValue(), BorderConvertor.getColor(string));
                break;
            }
            case SOFTBEVEL: {
                FrameBorder.BorderType borderType = FrameBorder.BorderType.intToEnum((Integer)((Integer)graphicController.getProperty(n, 395)));
                int n10 = borderType == FrameBorder.BorderType.LOWERED ? 1 : 0;
                String string = (String)graphicController.getProperty(n, 382);
                String string6 = (String)graphicController.getProperty(n, 381);
                String string7 = (String)graphicController.getProperty(n, 388);
                String string8 = (String)graphicController.getProperty(n, 387);
                if (string != null && string7 != null) {
                    if (string6 != null && string8 != null) {
                        border = BorderFactory.createBevelBorder(n10, BorderConvertor.getColor(string), BorderConvertor.getColor(string6), BorderConvertor.getColor(string7), BorderConvertor.getColor(string8));
                        break;
                    }
                    border = BorderFactory.createBevelBorder(n10, BorderConvertor.getColor(string), BorderConvertor.getColor(string7));
                    break;
                }
                border = BorderFactory.createBevelBorder(n10);
                break;
            }
            case TITLED: {
                Integer n11 = (Integer)graphicController.getProperty(n, 389);
                String string = (String)graphicController.getProperty(n, 161);
                Integer n12 = (Integer)graphicController.getProperty(n, 384);
                String string9 = (String)graphicController.getProperty(n, 291);
                String string10 = (String)graphicController.getProperty(n, 290);
                Integer n13 = (Integer)graphicController.getProperty(n, 292);
                String string11 = (String)graphicController.getProperty(n, 294);
                Integer n14 = (Integer)graphicController.getProperty(n, 390);
                String string12 = (String)graphicController.getProperty(n, 380);
                if (n11 == null && string != null) {
                    border = BorderFactory.createTitledBorder(string);
                    break;
                }
                Border border4 = BorderConvertor.getBorder(n11);
                if (string != null) {
                    if (n12 != null && n14 != null) {
                        int n15 = 4;
                        switch (FrameBorder.JustificationType.intToEnum((Integer)n12)) {
                            case CENTER: {
                                n15 = 2;
                                break;
                            }
                            case LEFT: {
                                n15 = 1;
                                break;
                            }
                            case RIGHT: {
                                n15 = 3;
                                break;
                            }
                            case TRAILING: {
                                n15 = 5;
                                break;
                            }
                            default: {
                                n15 = 4;
                            }
                        }
                        int n16 = 2;
                        switch (FrameBorder.TitlePositionType.intToEnum((Integer)n14)) {
                            case ABOVE_BOTTOM: {
                                n16 = 4;
                                break;
                            }
                            case ABOVE_TOP: {
                                n16 = 1;
                                break;
                            }
                            case BELOW_BOTTOM: {
                                n16 = 6;
                                break;
                            }
                            case BELOW_TOP: {
                                n16 = 3;
                                break;
                            }
                            case BOTTOM: {
                                n16 = 5;
                                break;
                            }
                            default: {
                                n16 = 2;
                            }
                        }
                        if (string9 != null && string10 != null && n13 != null && string11 != null) {
                            int n17 = 0;
                            if (string10.equals("italic")) {
                                n17 |= 2;
                            }
                            if (string11.equals("bold")) {
                                n17 |= 1;
                            }
                            Font font = UIManager.getFont("Button.font");
                            Font font2 = new Font(!string9.equals("") ? string9 : font.getFontName(), n17, n13 != 0 ? n13.intValue() : font.getSize());
                            border = BorderFactory.createTitledBorder(border4, string, n15, n16, font2, BorderConvertor.getColor(string12));
                            break;
                        }
                        border = BorderFactory.createTitledBorder(border4, string, n15, n16);
                        break;
                    }
                    border = BorderFactory.createTitledBorder(border4, string);
                    break;
                }
                border = BorderFactory.createTitledBorder(border4);
                break;
            }
            default: {
                border = BorderFactory.createEmptyBorder();
            }
        }
        return border;
    }
}

