/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.plotbrowser;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.plotbrowser.CheckBoxCellRenderer;
import org.scilab.modules.gui.plotbrowser.MessagesPlotBrowser;
import org.scilab.modules.gui.plotbrowser.SwingPlotBrowser;
import org.scilab.modules.renderer.utils.ObjectSearcher;

public class ListCreator {
    private JList list;
    private final ArrayList<Integer> uids = new ArrayList();
    private ArrayList<Object> cbArray = new ArrayList();

    public ListCreator(Integer n) {
        this.structure();
        this.filler(n);
        this.getVisible();
    }

    private void structure() {
        this.list = new JList();
        this.list.setCellRenderer(new CheckBoxCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (keyEvent.getKeyCode() == 32 && (n = ListCreator.this.list.getSelectedIndex()) != -1) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = ListCreator.this.getCheckbox(n)).isSelected());
                    ListCreator.this.setVisible(!jCheckBox.isSelected(), (Integer)ListCreator.this.uids.get(n));
                    SwingPlotBrowser.pReceive.repaint();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getX() < 20 && (n = ListCreator.this.list.locationToIndex(mouseEvent.getPoint())) != -1) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = ListCreator.this.getCheckbox(n)).isSelected());
                    ListCreator.this.setVisible(!jCheckBox.isSelected(), (Integer)ListCreator.this.uids.get(n));
                    SwingPlotBrowser.pReceive.repaint();
                }
            }
        });
    }

    private void filler(Integer n) {
        ObjectSearcher objectSearcher = new ObjectSearcher();
        Integer[] integerArray = ListCreator.searchAxes(n);
        for (int i = 0; i < integerArray.length; ++i) {
            Integer[] integerArray2;
            Integer[] integerArray3;
            Integer[] integerArray4;
            Integer n2 = (Integer)GraphicController.getController().getProperty(integerArray[i], 161);
            String[] stringArray = (String[])GraphicController.getController().getProperty(n2, 254);
            this.cbArray.add(new JCheckBox(stringArray[0].isEmpty() ? MessagesPlotBrowser.axis : stringArray[0]));
            this.uids.add(integerArray[i]);
            Integer[] integerArray5 = objectSearcher.search(integerArray[i], 236);
            if (integerArray5 != null) {
                for (int j = 0; j < integerArray5.length; ++j) {
                    this.cbArray.add(new JCheckBox(MessagesPlotBrowser.polyline));
                    this.uids.add(integerArray5[j]);
                }
            }
            if ((integerArray4 = objectSearcher.search(integerArray[i], 10)) != null) {
                for (int j = 0; j < integerArray4.length; ++j) {
                    this.cbArray.add(new JCheckBox(MessagesPlotBrowser.surface));
                    this.uids.add(integerArray4[j]);
                }
            }
            if ((integerArray3 = objectSearcher.search(integerArray[i], 6)) != null) {
                for (int j = 0; j < integerArray3.length; ++j) {
                    this.cbArray.add(new JCheckBox(MessagesPlotBrowser.surface));
                    this.uids.add(integerArray3[j]);
                }
            }
            if ((integerArray2 = objectSearcher.search(integerArray[i], 14)) == null) continue;
            for (int j = 0; j < integerArray2.length; ++j) {
                this.cbArray.add(new JCheckBox(MessagesPlotBrowser.surface));
                this.uids.add(integerArray2[j]);
            }
        }
        this.list.setListData(new Vector<Object>(this.cbArray));
        SwingPlotBrowser.pReceive.add(new JScrollPane(this.list));
    }

    private JCheckBox getCheckbox(int n) {
        JCheckBox jCheckBox = (JCheckBox)this.list.getModel().getElementAt(n);
        return jCheckBox;
    }

    private void getVisible() {
        for (int i = 0; i < this.cbArray.size(); ++i) {
            boolean bl = (Boolean)GraphicController.getController().getProperty(this.uids.get(i), 27);
            JCheckBox jCheckBox = this.getCheckbox(i);
            jCheckBox.setSelected(!bl);
        }
    }

    public void setVisible(boolean bl, Integer n) {
        GraphicController.getController().setProperty(n, 27, (Object)bl);
    }

    private static Integer[] searchAxes(Integer n) {
        return new ObjectSearcher().search(n, 1);
    }
}

