/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.messagebox;

import java.awt.Component;
import javax.swing.Action;
import org.scilab.modules.gui.bridge.messagebox.SwingScilabMessageBox;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.localization.Messages;

public final class ScilabModalDialog {
    private ScilabModalDialog() {
    }

    public static AnswerOption show(SimpleTab simpleTab, String[] stringArray) {
        return ScilabModalDialog.show(simpleTab, stringArray, Messages.gettext((String)"Scilab Message"), IconType.SCILAB_ICON, ButtonType.OK);
    }

    public static AnswerOption show(SimpleTab simpleTab, String string) {
        return ScilabModalDialog.show(simpleTab, new String[]{string}, Messages.gettext((String)"Scilab Message"), IconType.SCILAB_ICON, ButtonType.OK);
    }

    public static AnswerOption show(SimpleTab simpleTab, String[] stringArray, String string) {
        return ScilabModalDialog.show(simpleTab, stringArray, string, IconType.SCILAB_ICON, ButtonType.OK);
    }

    public static AnswerOption show(SimpleTab simpleTab, String string, String string2) {
        return ScilabModalDialog.show(simpleTab, new String[]{string}, string2, IconType.SCILAB_ICON, ButtonType.OK);
    }

    public static AnswerOption show(SimpleTab simpleTab, String[] stringArray, String string, IconType iconType) {
        return ScilabModalDialog.show(simpleTab, stringArray, string, iconType, ButtonType.OK);
    }

    public static AnswerOption show(SimpleTab simpleTab, String string, String string2, IconType iconType) {
        return ScilabModalDialog.show(simpleTab, new String[]{string}, string2, iconType, ButtonType.OK);
    }

    public static AnswerOption show(SimpleTab simpleTab, String string, String string2, IconType iconType, ButtonType buttonType) {
        return ScilabModalDialog.show(simpleTab, new String[]{string}, string2, iconType, buttonType);
    }

    public static AnswerOption show(SimpleTab simpleTab, String[] stringArray, String string, IconType iconType, ButtonType buttonType) {
        Component component = simpleTab == null ? null : (Component)((Object)simpleTab);
        return ScilabModalDialog.show(component, stringArray, string, iconType, buttonType);
    }

    public static AnswerOption show(Component component, String[] stringArray, String string, IconType iconType, ButtonType buttonType) {
        return ScilabModalDialog.show(component, stringArray, string, iconType, buttonType, null, null);
    }

    public static AnswerOption show(Component component, String[] stringArray, String string, IconType iconType, ButtonType buttonType, String string2, Action action) {
        SwingScilabMessageBox swingScilabMessageBox = new SwingScilabMessageBox();
        swingScilabMessageBox.setTitle(string);
        swingScilabMessageBox.setMessage(stringArray);
        if (string2 != null && action != null) {
            swingScilabMessageBox.setCheckbox(string2, action);
        }
        String[] stringArray2 = null;
        switch (buttonType) {
            case OK: {
                stringArray2 = new String[]{Messages.gettext((String)"OK")};
                break;
            }
            case OK_CANCEL: {
                stringArray2 = new String[]{Messages.gettext((String)"OK"), Messages.gettext((String)"Cancel")};
                break;
            }
            case YES_NO: {
                stringArray2 = new String[]{Messages.gettext((String)"Yes"), Messages.gettext((String)"No")};
                break;
            }
            case YES_NO_CANCEL: {
                stringArray2 = new String[]{Messages.gettext((String)"Yes"), Messages.gettext((String)"No"), Messages.gettext((String)"Cancel")};
                break;
            }
            case CANCEL_OR_SAVE_AND_EXECUTE: {
                stringArray2 = new String[]{Messages.gettext((String)"Cancel"), Messages.gettext((String)"Save and execute")};
            }
        }
        swingScilabMessageBox.setButtonsLabels(stringArray2);
        String string3 = null;
        switch (iconType) {
            case ERROR_ICON: {
                string3 = "error";
                break;
            }
            case INFORMATION_ICON: {
                string3 = "info";
                break;
            }
            case PASSWORD_ICON: {
                string3 = "passwd";
                break;
            }
            case QUESTION_ICON: {
                string3 = "question";
                break;
            }
            case WARNING_ICON: {
                string3 = "warning";
                break;
            }
            default: {
                string3 = "scilab";
            }
        }
        swingScilabMessageBox.setIcon(string3);
        swingScilabMessageBox.setParentForLocation(component);
        swingScilabMessageBox.displayAndWait();
        int n = swingScilabMessageBox.getSelectedButton() - 1;
        AnswerOption answerOption = AnswerOption.OK_OPTION;
        switch (buttonType) {
            case OK: {
                answerOption = AnswerOption.OK_OPTION;
                break;
            }
            case OK_CANCEL: {
                if (n == 0) {
                    answerOption = AnswerOption.OK_OPTION;
                    break;
                }
                answerOption = AnswerOption.CANCEL_OPTION;
                break;
            }
            case YES_NO: {
                if (n == 0) {
                    answerOption = AnswerOption.YES_OPTION;
                    break;
                }
                answerOption = AnswerOption.NO_OPTION;
                break;
            }
            case YES_NO_CANCEL: {
                if (n == 0) {
                    answerOption = AnswerOption.YES_OPTION;
                    break;
                }
                if (n == 1) {
                    answerOption = AnswerOption.NO_OPTION;
                    break;
                }
                answerOption = AnswerOption.CANCEL_OPTION;
                break;
            }
            case CANCEL_OR_SAVE_AND_EXECUTE: {
                if (n == 0) {
                    answerOption = AnswerOption.CANCEL_OPTION;
                    break;
                }
                if (n != 1) break;
                answerOption = AnswerOption.SAVE_EXECUTE_OPTION;
            }
        }
        return answerOption;
    }

    public static enum AnswerOption {
        OK_OPTION,
        CANCEL_OPTION,
        YES_OPTION,
        NO_OPTION,
        SAVE_EXECUTE_OPTION;

    }

    public static enum IconType {
        ERROR_ICON,
        INFORMATION_ICON,
        PASSWORD_ICON,
        QUESTION_ICON,
        WARNING_ICON,
        SCILAB_ICON;

    }

    public static enum ButtonType {
        OK,
        OK_CANCEL,
        YES_NO,
        YES_NO_CANCEL,
        CANCEL_OR_SAVE_AND_EXECUTE;

    }
}

