/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.ged.graphic_objects.polyline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.gui.ged.MessagesGED;
import org.scilab.modules.gui.ged.graphic_objects.SimpleSection;
import org.scilab.modules.gui.ged.graphic_objects.properties.ClippableContouredObject;
import org.scilab.modules.gui.ged.graphic_objects.properties.GraphicObject;

public class DataProperties
extends SimpleSection {
    private JPanel sectionPanel;
    private static DataProperties instance;
    private Integer currentpolyline;
    private ClippableContouredObject clippableContouredObject = new ClippableContouredObject();
    private GraphicObject graphicObject = new GraphicObject();
    private JLabel lData = new JLabel();
    private JPanel pData = new JPanel();
    private JButton bData = new JButton();
    private JLabel cData = new JLabel();
    private JDialog dataTableDialog = new JDialog();
    private JScrollPane dataScroll = new JScrollPane();
    private JTable dataTable = new JTable();
    private JButton append = new JButton();
    private JButton delete = new JButton();
    private JButton refresh = new JButton();
    private JButton ok = new JButton();

    public DataProperties(Integer n) {
        super(MessagesGED.data_properties, "polyline");
        instance = this;
        this.currentpolyline = n;
        this.sectionPanel = this.getSectionPanel();
        this.initComponents(n);
    }

    public static DataProperties getInstance() {
        return instance;
    }

    @Override
    public final void initComponents(Integer n) {
        int n2 = 0;
        int n3 = 1;
        this.clippableContouredObject.clipState(this.sectionPanel, n2++, n3, 0, n);
        this.clippableContouredObject.clipBox(this.sectionPanel, n2, n3, 0, n);
        this.dataDialog();
        this.addJLabel(this.sectionPanel, this.lData, MessagesGED.data, 1, n2 += 2, 0);
        this.addDataField(this.sectionPanel, this.pData, this.bData, this.cData, 2, n2++);
        this.bData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProperties.this.updateDataTable();
                DataProperties.this.dataTableDialog.setVisible(true);
            }
        });
        this.graphicObject.tag(this.sectionPanel, n2++, n3, 0, n);
        this.graphicObject.userData(this.sectionPanel, n2++, n3, 0);
    }

    private void dataDialog() {
        this.addDataDialog(this.dataTableDialog, this.dataScroll, this.dataTable, this.append, this.delete, this.refresh, this.ok, this.currentpolyline);
        this.dataTableDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DataProperties.this.updateDataTable();
            }
        });
        this.dataTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                DataProperties.this.dataTableEvent(tableModelEvent);
            }
        });
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProperties.this.updateDataTable();
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProperties.this.updateDataTable();
                DataProperties.this.dataTableDialog.dispose();
            }
        });
    }

    public final Object[][] getData() {
        double[] dArray = (double[])PolylineData.getDataX((int)this.currentpolyline);
        double[] dArray2 = (double[])PolylineData.getDataY((int)this.currentpolyline);
        double[] dArray3 = (double[])PolylineData.getDataZ((int)this.currentpolyline);
        Object[][] objectArray = new Object[dArray.length][3];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i][0] = dArray[i];
            objectArray[i][1] = dArray2[i];
            objectArray[i][2] = dArray3[i];
        }
        return objectArray;
    }

    private boolean is3D(Object[][] objectArray) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if ((Double)objectArray[i][2] == 0.0) continue;
            bl = true;
        }
        return bl;
    }

    private void updateDataTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.dataTable.getModel();
        Object[][] objectArray = this.getData();
        if (objectArray.length != 0) {
            if (this.is3D(objectArray)) {
                defaultTableModel.setDataVector(objectArray, new String[]{"X", "Y", "Z"});
                this.cData.setText(objectArray.length + "x3");
            } else {
                defaultTableModel.setDataVector(objectArray, new String[]{"X", "Y"});
                this.cData.setText(objectArray.length + "x2");
            }
        }
    }

    private void dataTableEvent(TableModelEvent tableModelEvent) {
        if (this.dataTable.getSelectedRow() != -1) {
            if (this.dataTable.getRowCount() <= this.dataTable.getSelectedRow()) {
                return;
            }
            Object object = this.dataTable.getValueAt(this.dataTable.getSelectedRow(), 0);
            Object object2 = this.dataTable.getValueAt(this.dataTable.getSelectedRow(), 1);
            if (object == null) {
                object = 0.0;
            } else if (object2 == null) {
                object2 = 0.0;
            }
            PolylineData.setPointValue((int)this.currentpolyline, (int)this.dataTable.getSelectedRow(), (double)((Double)object), (double)((Double)object2), (double)0.0);
        }
    }
}

