/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.events;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.utils.SciTranslator;

public class ScilabEventListener
implements KeyListener,
MouseListener,
MouseMotionListener {
    private String callback;
    private Integer windowsUID;
    private int mouseX = 0;
    private int mouseY = 0;
    private SciTranslator eventTranslator = new SciTranslator();
    private boolean freedom = true;
    private boolean inCanvas = false;
    private boolean useHandle = true;

    public ScilabEventListener(String string, Integer n) {
        this.eventTranslator.setClickAction(-10000);
        this.callback = string;
        this.windowsUID = n;
    }

    public ScilabEventListener(String string, Integer n, boolean bl) {
        this.eventTranslator.setClickAction(-10000);
        this.callback = string;
        this.windowsUID = n;
        this.useHandle = bl;
    }

    private void callScilab() {
        if (this.useHandle) {
            InterpreterManagement.requestScilabExec((String)(this.callback + "(getcallbackobject(" + this.windowsUID + ")," + this.mouseX + ',' + this.mouseY + ',' + this.eventTranslator.getClickAction() + ')'));
        } else {
            int n = (Integer)GraphicController.getController().getProperty(this.windowsUID, 88);
            InterpreterManagement.requestScilabExec((String)(this.callback + '(' + n + ',' + this.mouseX + ',' + this.mouseY + ',' + this.eventTranslator.getClickAction() + ')'));
        }
    }

    private void invokeScilab() {
        if (this.useHandle) {
            InterpreterManagement.requestScilabExec((String)(this.callback + "(getcallbackobject(" + this.windowsUID + ")," + this.mouseX + ',' + this.mouseY + ',' + this.eventTranslator.javaClick2Scilab() + ')'));
        } else {
            int n = (Integer)GraphicController.getController().getProperty(this.windowsUID, 88);
            InterpreterManagement.requestScilabExec((String)(this.callback + '(' + n + ',' + this.mouseX + ',' + this.mouseY + ',' + this.eventTranslator.javaClick2Scilab() + ')'));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.inCanvas) {
            if (Character.isJavaIdentifierStart(keyEvent.getKeyChar())) {
                this.eventTranslator.setClickAction(SciTranslator.javaKey2Scilab(keyEvent.getKeyChar(), keyEvent.isControlDown()));
                this.callScilab();
            } else {
                int n;
                if (keyEvent.isShiftDown()) {
                    n = keyEvent.getKeyCode();
                } else {
                    n = Character.toLowerCase(keyEvent.getKeyCode());
                    this.callScilab();
                }
                this.eventTranslator.setClickAction(SciTranslator.javaKey2Scilab(n, keyEvent.isControlDown()));
                this.callScilab();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.inCanvas && this.eventTranslator.getClickAction() != -10000) {
            this.eventTranslator.setClickAction(-this.eventTranslator.getClickAction());
            this.callScilab();
            this.eventTranslator.setClickAction(-10000);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (mouseEvent.getClickCount() == 1) {
            this.eventTranslator.setClickAction(SciTranslator.javaButton2Scilab(mouseEvent.getButton(), 2, mouseEvent.isControlDown()));
        } else {
            this.eventTranslator.setClickAction(SciTranslator.javaButton2Scilab(mouseEvent.getButton(), 9, mouseEvent.isControlDown()));
            SciTranslator sciTranslator = this.eventTranslator;
            synchronized (sciTranslator) {
                this.eventTranslator.notify();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.inCanvas = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.inCanvas = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.freedom) {
            this.freedom = false;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.eventTranslator.setClickAction(SciTranslator.javaButton2Scilab(mouseEvent.getButton(), -1, mouseEvent.isControlDown()));
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ScilabEventListener.this.invokeScilab();
                    ScilabEventListener.this.freedom = true;
                    ScilabEventListener.this.eventTranslator.setClickAction(-10000);
                }
            };
            thread.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.eventTranslator.getClickAction() == -10000 || this.eventTranslator.getClickAction() == -1) {
            this.eventTranslator.setClickAction(SciTranslator.javaButton2Scilab(mouseEvent.getButton(), -6, mouseEvent.isControlDown()));
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.callScilab();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.eventTranslator.getClickAction() == SciTranslator.javaButton2Scilab(1, -1, false)) {
            this.freedom = false;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.callScilab();
            this.freedom = true;
            this.eventTranslator.setClickAction(-1);
        } else {
            this.eventTranslator.setClickAction(-1);
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.callScilab();
        }
        this.eventTranslator.setClickAction(-10000);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.eventTranslator.setClickAction(-1);
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.callScilab();
        this.eventTranslator.setClickAction(-10000);
    }
}

