/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;

public class SystemClipboard {
    static SystemClipboard instance = null;
    static String name = "png";

    public static SystemClipboard getInstance() {
        if (instance == null) {
            instance = new SystemClipboard();
        }
        return instance;
    }

    public static void copyToSysClipboard(Integer n) {
        BufferedImage bufferedImage = SystemClipboard.bufferFromUID(n);
        ImageTransfer imageTransfer = new ImageTransfer(bufferedImage);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageTransfer, null);
    }

    private static BufferedImage bufferFromUID(Integer n) {
        JoGLCanvas joGLCanvas = null;
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor((Integer)n);
        Canvas canvas = drawerVisitor.getCanvas();
        if (canvas instanceof JoGLCanvas) {
            joGLCanvas = (JoGLCanvas)canvas;
        }
        if (joGLCanvas != null) {
            BufferedImage bufferedImage = joGLCanvas.getImage();
            return bufferedImage;
        }
        return null;
    }

    public static class ImageTransfer
    implements Transferable {
        private Image image;

        public ImageTransfer(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }
    }
}

