/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import java.util.LinkedList;
import java.util.List;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.ObjectData;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.SurfaceData;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.utils.AxesHandler;
import org.scilab.modules.renderer.utils.CommonHandler;

public class GEDPicker {
    private final Double delta = 7.0;
    private Integer axesUID;
    private Axes axes;
    private double Z = 2.0;

    public Integer[] pick(Integer n, Integer[] integerArray) {
        boolean bl = false;
        this.axesUID = AxesHandler.clickedAxes((Integer)n, (Integer[])integerArray);
        this.axes = AxesHandler.getAxesFromUid((Integer)this.axesUID);
        if (this.axes == null) {
            return new Integer[]{n};
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Integer[] integerArray2 = this.getAllObjAsArray(this.axesUID);
        for (int i = 0; i < integerArray2.length; ++i) {
            Integer n2 = (Integer)GraphicController.getController().getProperty(integerArray2[i], 29);
            if (!CommonHandler.isVisible((Integer)integerArray2[i]).booleanValue()) continue;
            switch (n2) {
                case 15: {
                    bl = this.getPolyline(integerArray2[i], integerArray);
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 14: {
                    bl = this.getSurface(integerArray2[i], integerArray);
                    break;
                }
                case 12: {
                    bl = this.getLegend(integerArray2[i], integerArray);
                    break;
                }
                case 11: {
                    bl = this.getLabel(integerArray2[i], integerArray);
                    break;
                }
                case 0: {
                    bl = this.getArc(integerArray2[i], integerArray);
                    break;
                }
                case 4: {
                    bl = this.getChamp(integerArray2[i], integerArray);
                    break;
                }
                case 7: {
                    bl = this.getFec(integerArray2[i], integerArray);
                    break;
                }
                case 16: {
                    bl = this.getRectangle(integerArray2[i], integerArray);
                    break;
                }
                case 17: {
                    bl = this.getSegs(integerArray2[i], integerArray);
                    break;
                }
                case 331: {
                    bl = this.getDatatip(integerArray2[i], integerArray);
                    break;
                }
                case 5: {
                    bl = false;
                }
            }
            if (!bl) continue;
            linkedList.add(integerArray2[i]);
        }
        if (linkedList.size() > 0) {
            return linkedList.toArray(new Integer[linkedList.size()]);
        }
        if (this.isInsideAxes(n, integerArray)) {
            return new Integer[]{this.axesUID};
        }
        return new Integer[]{n};
    }

    boolean getPolyline(Integer n, Integer[] integerArray) {
        Object object;
        Integer n2;
        int n3;
        double[] dArray;
        double[] dArray2 = (double[])PolylineData.getDataX((int)n);
        double[] dArray3 = (double[])PolylineData.getDataY((int)n);
        double[] dArray4 = (double[])PolylineData.getDataZ((int)n);
        if (PolylineData.isXShiftSet((int)n) != 0) {
            dArray = (double[])PolylineData.getShiftX((int)n);
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + dArray[n3];
            }
        }
        if (PolylineData.isYShiftSet((int)n) != 0) {
            dArray = (double[])PolylineData.getShiftY((int)n);
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                int n5 = n3;
                dArray3[n5] = dArray3[n5] + dArray[n3];
            }
        }
        if (PolylineData.isZShiftSet((int)n) != 0) {
            dArray = (double[])PolylineData.getShiftZ((int)n);
            for (n3 = 0; n3 < dArray4.length; ++n3) {
                int n6 = n3;
                dArray4[n6] = dArray4[n6] + dArray[n3];
            }
        }
        dArray2 = CommonHandler.toLogScale((double[])dArray2, (boolean)this.axes.getXAxisLogFlag());
        dArray3 = CommonHandler.toLogScale((double[])dArray3, (boolean)this.axes.getYAxisLogFlag());
        dArray4 = CommonHandler.toLogScale((double[])dArray4, (boolean)this.axes.getZAxisLogFlag());
        dArray = new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 1.0};
        double[] dArray5 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray);
        dArray[0] = dArray[0] + this.delta;
        dArray[1] = dArray[1] + this.delta;
        double[] dArray6 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray);
        double d = Math.abs(dArray5[0] - dArray6[0]);
        double d2 = Math.abs(dArray5[1] - dArray6[1]);
        if (AxesHandler.isZoomBoxEnabled((Integer)this.axesUID).booleanValue() && !AxesHandler.isInZoomBoxBounds((Integer)this.axesUID, (double)dArray5[0], (double)dArray5[1]).booleanValue()) {
            return false;
        }
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(this.axesUID, 168);
        boolean bl = doubleArray[0] == 0.0 && doubleArray[1] == 270.0;
        Object object2 = new double[3];
        if (CommonHandler.isLineEnabled((Integer)n).booleanValue()) {
            if (!bl) {
                object2 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])new double[]{dArray2[0], dArray3[0], dArray4[0]});
            }
            n2 = 0;
            while (n2 < dArray2.length - 1) {
                if (!bl) {
                    object = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])new double[]{dArray2[n2 + 1], dArray3[n2 + 1], dArray4[n2 + 1]});
                    if (this.isInRange(object2[0], (double)object[0], object2[1], (double)object[1], dArray5[0], dArray5[1], d, d2)) {
                        return true;
                    }
                    object2 = object;
                } else if (this.isInRange(dArray2[n2], dArray2[n2 + 1], dArray3[n2], dArray3[n2 + 1], dArray5[0], dArray5[1], d, d2)) {
                    return true;
                }
                n2 = n2 + 1;
            }
        }
        if (CommonHandler.isMarkEnabled((Integer)n).booleanValue()) {
            n2 = CommonHandler.getMarkSize((Integer)n);
            object = CommonHandler.getMarkSizeUnit((Integer)n);
            int n7 = (Integer)object == 1 ? 8 + 2 * n2 : n2;
            double d3 = Math.abs(d / this.delta * (double)(n7 /= 2));
            double d4 = Math.abs(d2 / this.delta * (double)n7);
            for (int i = 0; i < dArray2.length; ++i) {
                if (!bl) {
                    double[] dArray7 = new double[]{dArray2[i], dArray3[i], dArray4[i]};
                    double[] dArray8 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])dArray7);
                    if (!(Math.abs(dArray8[0] - dArray5[0]) <= d3) || !(Math.abs(dArray8[1] - dArray5[1]) <= d4)) continue;
                    return true;
                }
                if (!(Math.abs(dArray2[i] - dArray5[0]) <= d3) || !(Math.abs(dArray3[i] - dArray5[1]) <= d4)) continue;
                return true;
            }
        }
        return false;
    }

    boolean getSurface(Integer n, Integer[] integerArray) {
        Vector3d vector3d;
        double d;
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        Integer n2 = graphicObject.getParentFrameOrFigure();
        double[] dArray = DrawerVisitor.getVisitor((Integer)n2).getAxesDrawer().getProjection(this.axesUID).getMatrix();
        double[][] dArray2 = this.axes.getScaleTranslateFactors();
        Vector3d vector3d2 = AxesDrawer.unProject((Axes)this.axes, (Vector3d)new Vector3d((double)(1.0f * (float)integerArray[0].intValue()), (double)(1.0f * (float)integerArray[1].intValue()), 0.0));
        Vector3d vector3d3 = AxesDrawer.unProject((Axes)this.axes, (Vector3d)new Vector3d((double)(1.0f * (float)integerArray[0].intValue()), (double)(1.0f * (float)integerArray[1].intValue()), 1.0));
        vector3d2 = new Vector3d((vector3d2.getX() - dArray2[1][0]) / dArray2[0][0], (vector3d2.getY() - dArray2[1][1]) / dArray2[0][1], (vector3d2.getZ() - dArray2[1][2]) / dArray2[0][2]);
        vector3d3 = new Vector3d((vector3d3.getX() - dArray2[1][0]) / dArray2[0][0], (vector3d3.getY() - dArray2[1][1]) / dArray2[0][1], (vector3d3.getZ() - dArray2[1][2]) / dArray2[0][2]);
        Vector3d vector3d4 = vector3d2.minus(vector3d3).getNormalized();
        double d2 = SurfaceData.pickSurface((int)n, (double)vector3d2.getX(), (double)vector3d2.getY(), (double)vector3d2.getZ(), (double)vector3d4.getX(), (double)vector3d4.getY(), (double)vector3d4.getZ());
        return d2 != Double.NEGATIVE_INFINITY && (d = (vector3d = new Vector3d(vector3d2.plus(vector3d4.times(d2)))).getX() * dArray[2] + vector3d.getY() * dArray[6] + vector3d.getZ() * dArray[10] + dArray[14]) < this.Z;
    }

    boolean getLegend(Integer n, Integer[] integerArray) {
        Integer[] integerArray2 = new Integer[]{0, 0};
        Double[] doubleArray = new Double[]{0.0, 0.0};
        Double[] doubleArray2 = new Double[]{0.0, 0.0};
        Double[] doubleArray3 = new Double[]{0.0, 0.0};
        Double[] doubleArray4 = new Double[]{0.0, 0.0, 0.0, 0.0};
        Double[] doubleArray5 = new Double[]{0.0, 0.0};
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        Integer n2 = graphicObject.getParentFrameOrFigure();
        integerArray2 = (Integer[])GraphicController.getController().getProperty(n2, 85);
        doubleArray = (Double[])GraphicController.getController().getProperty(this.axesUID, 183);
        doubleArray3 = (Double[])GraphicController.getController().getProperty(n, 80);
        doubleArray2[0] = ((double)integerArray[0].intValue() - doubleArray[0] * (double)integerArray2[0].intValue()) / (doubleArray[2] * (double)integerArray2[0].intValue());
        doubleArray2[1] = ((double)integerArray[1].intValue() - doubleArray[1] * (double)integerArray2[1].intValue()) / (doubleArray[3] * (double)integerArray2[1].intValue());
        doubleArray5 = (Double[])GraphicController.getController().getProperty(n, 81);
        doubleArray4[0] = doubleArray3[0];
        doubleArray4[1] = doubleArray3[1];
        doubleArray4[2] = doubleArray3[0] + doubleArray5[0];
        doubleArray4[3] = doubleArray3[1] + doubleArray5[1];
        return doubleArray2[0] >= doubleArray4[0] && doubleArray2[0] <= doubleArray4[2] && doubleArray2[1] >= doubleArray4[1] && doubleArray2[1] <= doubleArray4[3];
    }

    boolean getLabel(Integer n, Integer[] integerArray) {
        Object object;
        Object object2;
        Object[] objectArray;
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 227);
        Double d = (Double)GraphicController.getController().getProperty(n, 225);
        int n2 = (int)(d * 2.0 / Math.PI) % 2;
        if (n2 == 1) {
            objectArray = new Double[doubleArray.length];
            object2 = 0;
            while ((Integer)object2 < doubleArray.length - 3) {
                objectArray[((Integer)object2).intValue() + 3] = doubleArray[(Integer)object2];
                object = object2;
                object2 = (Integer)object2 + 1;
                Integer n3 = object2;
            }
            objectArray[0] = doubleArray[doubleArray.length - 3];
            objectArray[1] = doubleArray[doubleArray.length - 2];
            objectArray[2] = doubleArray[doubleArray.length - 1];
            doubleArray = objectArray;
        }
        objectArray = new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 1.0};
        object2 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])objectArray);
        object = new boolean[]{(Boolean)GraphicController.getController().getProperty(this.axesUID, 118), (Boolean)GraphicController.getController().getProperty(this.axesUID, 134)};
        object2[0] = CommonHandler.InverseLogScale((Double)((double)object2[0]), (boolean)object[0]);
        object2[1] = CommonHandler.InverseLogScale((Double)((double)object2[1]), (boolean)object[1]);
        return (object2[0] >= doubleArray[0] && object2[0] <= doubleArray[6] || object2[0] <= doubleArray[0] && object2[0] >= doubleArray[6]) && (object2[1] >= doubleArray[1] && object2[1] <= doubleArray[4] || object2[1] <= doubleArray[1] && object2[1] >= doubleArray[4]);
    }

    boolean getArc(Integer n, Integer[] integerArray) {
        double d;
        Vector3d vector3d;
        double[] dArray = (double[])ObjectData.getArcUpperLeftPoint((int)n);
        double[] dArray2 = (double[])ObjectData.getArcData((int)n);
        double[] dArray3 = new double[]{(double)integerArray[0].intValue() * 1.0, (double)integerArray[1].intValue() * 1.0, 0.0};
        double[] dArray4 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray3);
        dArray3[0] = dArray3[0] + this.delta;
        dArray3[1] = dArray3[1] + this.delta;
        double[] dArray5 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray3);
        Boolean bl = (Boolean)GraphicController.getController().getProperty(n, 193);
        double d2 = Math.sqrt(Math.pow(dArray4[0] - dArray5[0], 2.0) + Math.pow(dArray4[1] - dArray5[1], 2.0)) / Math.sqrt(dArray2[0] * dArray2[0] / 4.0 / 2.0 + dArray2[1] * dArray2[1] / 4.0 / 2.0);
        double[] dArray6 = AxesDrawer.compute3dViewCoordinates((Axes)this.axes, (double[])dArray4);
        dArray4[2] = dArray4[2] + 1.0;
        double[] dArray7 = AxesDrawer.compute3dViewCoordinates((Axes)this.axes, (double[])dArray4);
        Vector3d vector3d2 = new Vector3d(dArray7);
        Vector3d vector3d3 = vector3d2.minus(vector3d = new Vector3d(dArray6));
        if (vector3d3.getZ() == 0.0) {
            return false;
        }
        double d3 = (dArray[2] - vector3d.getZ()) / vector3d3.getZ();
        Vector3d vector3d4 = vector3d.plus(vector3d3.times(d3));
        double d4 = dArray2[1] / 2.0;
        double d5 = dArray2[0] / 2.0;
        Vector3d vector3d5 = new Vector3d(dArray[0] + d4, dArray[1] - d5, dArray[2]);
        double d6 = vector3d4.getX() - vector3d5.getX();
        double d7 = d6 * d6 / (d4 * d4) + (d = vector3d4.getY() - vector3d5.getY()) * d / (d5 * d5);
        if (d7 > 1.0 + d2) {
            return false;
        }
        double d8 = this.getAngle360(dArray2[2]);
        double d9 = this.getAngle360(dArray2[3]) + d8;
        vector3d = new Vector3d(1.0, 0.0, 0.0);
        vector3d2 = vector3d4.minus(vector3d5);
        double d10 = Math.acos(vector3d.scalar(vector3d2) / (vector3d.getNorm() * vector3d2.getNorm()));
        if (!(d8 == d9 || (d10 += vector3d2.getY() < 0.0 ? Math.PI : 0.0) >= d8 && d10 <= d9)) {
            return false;
        }
        if (bl.booleanValue()) {
            return true;
        }
        return d7 > 1.0 - d2;
    }

    double getAngle360(double d) {
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        return d;
    }

    boolean getChamp(Integer n, Integer[] integerArray) {
        double[] dArray = (double[])ObjectData.getChampX((int)n);
        double[] dArray2 = (double[])ObjectData.getChampY((int)n);
        double[] dArray3 = (double[])ObjectData.getArrows((int)n);
        double d = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d = dArray3[i] > d ? dArray3[i] : d;
        }
        double[][] dArray4 = this.getAsStdMatrix(dArray3, d);
        if (dArray4 == null) {
            return false;
        }
        double[] dArray5 = new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 1.0};
        double[] dArray6 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray5);
        dArray5[0] = dArray5[0] + this.delta;
        dArray5[1] = dArray5[1] + this.delta;
        double[] dArray7 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray5);
        double d2 = Math.abs(dArray6[0] - dArray7[0]);
        double d3 = Math.abs(dArray6[1] - dArray7[1]);
        int n2 = dArray.length;
        int n3 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double[] dArray8 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])new double[]{dArray[i], dArray2[j], 0.0});
                double[] dArray9 = new double[]{dArray[i] + dArray4[i * n2 + j][0], dArray2[j] + dArray4[i * n2 + j][1], dArray4[i * n2 + j][2]};
                double[] dArray10 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])dArray9);
                if (this.isInRange(dArray8[0], dArray10[0], dArray8[1], dArray10[1], dArray6[0], dArray6[1], d2, d3)) {
                    return true;
                }
                if (Math.abs(dArray6[0] - dArray8[0]) <= d2 && Math.abs(dArray6[1] - dArray8[1]) <= d3) {
                    return true;
                }
                if (!(Math.abs(dArray6[0] - dArray10[0]) <= d2) || !(Math.abs(dArray6[1] - dArray10[1]) <= d3)) continue;
                return true;
            }
        }
        return false;
    }

    boolean getFec(Integer n, Integer[] integerArray) {
        int n2 = ObjectData.getFecNumVerticesByElement((int)n);
        double[] dArray = (double[])ObjectData.getFecElements((int)n);
        double[] dArray2 = (double[])ObjectData.getFecData((int)n);
        double[] dArray3 = new double[]{(double)integerArray[0].intValue() * 1.0, (double)integerArray[1].intValue() * 1.0, 0.0};
        double[] dArray4 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray3);
        double[] dArray5 = AxesDrawer.compute3dViewCoordinates((Axes)this.axes, (double[])dArray4);
        dArray4[2] = dArray4[2] + 1.0;
        double[] dArray6 = AxesDrawer.compute3dViewCoordinates((Axes)this.axes, (double[])dArray4);
        Vector3d vector3d = new Vector3d(dArray5);
        Vector3d vector3d2 = new Vector3d(dArray6);
        Vector3d vector3d3 = vector3d2.minus(vector3d);
        int n3 = dArray.length / (n2 + 2);
        for (int i = 0; i < n3; ++i) {
            int n4 = (int)dArray[n3 + i];
            for (int j = 2; j < n2; ++j) {
                Vector3d vector3d4 = new Vector3d(dArray2[(n4 - 1) * 3], dArray2[(n4 - 1) * 3 + 1], dArray2[(n4 - 1) * 3 + 2]);
                int n5 = (int)dArray[j * n3 + i];
                Vector3d vector3d5 = new Vector3d(dArray2[(n5 - 1) * 3], dArray2[(n5 - 1) * 3 + 1], dArray2[(n5 - 1) * 3 + 2]);
                int n6 = (int)dArray[(j + 1) * n3 + i];
                Vector3d vector3d6 = new Vector3d(dArray2[(n6 - 1) * 3], dArray2[(n6 - 1) * 3 + 1], dArray2[(n6 - 1) * 3 + 2]);
                if (!this.testTri(vector3d4, vector3d5, vector3d6, vector3d, vector3d3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean testTri(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5) {
        Vector3d vector3d6;
        Vector3d vector3d7;
        Vector3d vector3d8 = vector3d2.minus(vector3d);
        double d = vector3d8.scalar(vector3d7 = Vector3d.product((Vector3d)vector3d5, (Vector3d)(vector3d6 = vector3d3.minus(vector3d))));
        if (d > -1.0E-5 && d < 1.0E-5) {
            return false;
        }
        double d2 = 1.0 / d;
        Vector3d vector3d9 = vector3d4.minus(vector3d);
        double d3 = vector3d9.scalar(vector3d7) * d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return false;
        }
        Vector3d vector3d10 = Vector3d.product((Vector3d)vector3d9, (Vector3d)vector3d8);
        double d4 = vector3d5.scalar(vector3d10) * d2;
        return !(d4 < 0.0) && !(d3 + d4 > 1.0);
    }

    boolean getRectangle(Integer n, Integer[] integerArray) {
        Vector3d vector3d;
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 105);
        Double d = (Double)GraphicController.getController().getProperty(n, 107);
        Double d2 = (Double)GraphicController.getController().getProperty(n, 106);
        double[] dArray = new double[]{(double)integerArray[0].intValue() * 1.0, (double)integerArray[1].intValue() * 1.0, 0.0};
        double[] dArray2 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray);
        double[] dArray3 = AxesDrawer.compute3dViewCoordinates((Axes)this.axes, (double[])dArray2);
        dArray2[2] = dArray2[2] + 1.0;
        double[] dArray4 = AxesDrawer.compute3dViewCoordinates((Axes)this.axes, (double[])dArray2);
        Vector3d vector3d2 = new Vector3d(dArray4);
        Vector3d vector3d3 = vector3d2.minus(vector3d = new Vector3d(dArray3));
        if (vector3d3.getZ() == 0.0) {
            return false;
        }
        double d3 = (doubleArray[2] - vector3d.getZ()) / vector3d3.getZ();
        Vector3d vector3d4 = vector3d.plus(vector3d3.times(d3));
        return vector3d4.getX() >= doubleArray[0] && vector3d4.getX() <= doubleArray[0] + d2 && vector3d4.getY() <= doubleArray[1] && vector3d4.getY() >= doubleArray[1] - d;
    }

    boolean getSegs(Integer n, Integer[] integerArray) {
        double[][] dArray = this.getAsStdMatrix((double[])ObjectData.getSegsData((int)n), 1.0);
        double[][] dArray2 = this.getAsStdMatrix((double[])ObjectData.getArrows((int)n), 1.0);
        double[] dArray3 = new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 1.0};
        double[] dArray4 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray3);
        dArray3[0] = dArray3[0] + this.delta;
        dArray3[1] = dArray3[1] + this.delta;
        double[] dArray5 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray3);
        double d = Math.abs(dArray4[0] - dArray5[0]);
        double d2 = Math.abs(dArray4[1] - dArray5[1]);
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray6 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])dArray[i]);
            double[] dArray7 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])dArray2[i]);
            if (!this.isInRange(dArray6[0], dArray7[0], dArray6[1], dArray7[1], dArray4[0], dArray4[1], d, d2)) continue;
            return true;
        }
        return false;
    }

    boolean getDatatip(Integer n, Integer[] integerArray) {
        boolean bl;
        boolean[] blArray = new boolean[]{this.axes.getXAxisLogFlag(), this.axes.getYAxisLogFlag(), this.axes.getZAxisLogFlag()};
        double[] dArray = new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 1.0};
        double[] dArray2 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray);
        dArray[0] = dArray[0] + 1.0;
        dArray[1] = dArray[1] + 1.0;
        double[] dArray3 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axesUID, (double[])dArray);
        double d = Math.abs(dArray2[0] - dArray3[0]);
        double d2 = Math.abs(dArray2[1] - dArray3[1]);
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n, 332);
        double[] dArray4 = new double[]{CommonHandler.logScale((Double)doubleArray[0], (boolean)blArray[0]), CommonHandler.logScale((Double)doubleArray[1], (boolean)blArray[1]), CommonHandler.logScale((Double)doubleArray[2], (boolean)blArray[2])};
        Double[] doubleArray2 = (Double[])GraphicController.getController().getProperty(this.axesUID, 168);
        boolean bl2 = bl = doubleArray2[0] == 0.0 && doubleArray2[1] == 270.0;
        if (!bl) {
            dArray4 = AxesDrawer.compute2dViewCoordinates((Axes)this.axes, (double[])dArray4);
        }
        Integer n2 = CommonHandler.getMarkSize((Integer)n);
        Integer n3 = CommonHandler.getMarkSizeUnit((Integer)n);
        int n4 = n3 == 1 ? 8 + 2 * n2 : n2;
        return Math.abs(dArray4[0] - dArray2[0]) <= d * (double)(n4 /= 2) && Math.abs(dArray4[1] - dArray2[1]) <= d2 * (double)n4;
    }

    boolean isInsideAxes(Integer n, Integer[] integerArray) {
        Double[] doubleArray = (Double[])GraphicController.getController().getProperty(this.axesUID, 168);
        boolean bl = doubleArray[0] == 0.0 && doubleArray[1] == 270.0;
        Double[] doubleArray2 = (Double[])GraphicController.getController().getProperty(this.axesUID, 175);
        double[] dArray = AxesDrawer.compute2dViewFromPixelCoordinates((Axes)this.axes, (double[])new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 0.0});
        return dArray[0] >= doubleArray2[0] && dArray[0] <= doubleArray2[1] && dArray[1] >= doubleArray2[2] && dArray[1] <= doubleArray2[3];
    }

    void getObjects(Integer n, List<Integer> list) {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 23);
        if (n2 > 0) {
            Integer[] integerArray = (Integer[])GraphicController.getController().getProperty(n, 22);
            for (int i = 0; i < n2; ++i) {
                list.add(integerArray[i]);
                this.getObjects(integerArray[i], list);
            }
        }
    }

    Integer[] getAllObjAsArray(Integer n) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        this.getObjects(n, linkedList);
        return linkedList.toArray(new Integer[linkedList.size()]);
    }

    private boolean isInRange(Double d, Double d2, Double d3, Double d4, Double d5, Double d6, Double d7, Double d8) {
        double d9 = (d2 + d) / 2.0;
        double d10 = d9 - d;
        double d11 = (d4 - d3) / (d2 - d);
        double d12 = d3 + d11 * (d5 - d);
        double d13 = d7 / this.delta;
        double d14 = (d4 + d3) / 2.0;
        double d15 = d14 - d3;
        boolean bl = Math.abs(d2 - d) < Math.abs(d13 * 2.0);
        boolean bl2 = Math.abs(d9 - d5) <= Math.abs(d13 * 2.0) && Math.abs(d14 - d6) <= Math.abs(d15);
        return Math.abs(d9 - d5) <= Math.abs(d10) && d6 >= d12 - d8 && d6 <= d12 + d8 || bl && bl2;
    }

    private double[][] getAsStdMatrix(double[] dArray, double d) {
        double[][] dArray2 = null;
        if (dArray.length % 3 != 0) {
            return dArray2;
        }
        dArray2 = new double[dArray.length / 3][3];
        for (int i = 0; i < dArray.length / 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray2[i][j] = dArray[i * 3 + j] / d;
            }
        }
        return dArray2;
    }
}

