/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.gui.datatip.DatatipManager;
import org.scilab.modules.gui.editor.DataEditor;
import org.scilab.modules.gui.editor.GEDPicker;
import org.scilab.modules.gui.editor.LabelHandler;
import org.scilab.modules.gui.editor.ScilabClipboard;
import org.scilab.modules.gui.editor.SystemClipboard;
import org.scilab.modules.gui.editor.action.ActionDelete;
import org.scilab.modules.gui.editor.action.ActionHide;
import org.scilab.modules.gui.editor.action.ActionLegend;
import org.scilab.modules.gui.editor.action.ActionMove;
import org.scilab.modules.gui.editor.action.ActionPaste;
import org.scilab.modules.gui.editor.action.ActionPasteStyle;
import org.scilab.modules.gui.editor.action.ActionTextEdit;
import org.scilab.modules.gui.editor.action.EditorHistory;
import org.scilab.modules.gui.ged.Inspector;
import org.scilab.modules.gui.ged.StartGED;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.renderer.utils.AxesHandler;
import org.scilab.modules.renderer.utils.CommonHandler;
import org.scilab.modules.renderer.utils.EntityPicker;
import org.scilab.modules.renderer.utils.LegendHandler;
import org.scilab.modules.renderer.utils.PolylineHandler;

public class Editor {
    JPopupMenu menu;
    JMenuItem copy;
    JMenuItem copyStyle;
    JMenuItem cut;
    JMenuItem paste;
    JMenuItem pasteStyle;
    JMenuItem delete;
    JMenuItem clear;
    JMenuItem hide;
    JMenuItem unhide;
    JMenuItem clipboardCopy;
    JMenuItem labelX;
    JMenuItem labelY;
    JMenuItem labelZ;
    JMenuItem title;
    JMenuItem insert;
    JMenuItem remove;
    JMenuItem ged;
    JMenuItem editdata;
    JMenuItem undo;
    JMenuItem redo;
    JMenu labels;
    JMenu legends;
    EntityPicker.LegendInfo selectedLegend = null;
    EntityPicker.SurfaceInfo selectedSurface = null;
    Integer selected = null;
    Integer figureUid = null;
    Integer[] lastClick = new Integer[]{0, 0};
    Integer[] dragClick = new Integer[]{0, 0};
    EntityPicker entityPicker;
    DataEditor dataEditor;
    boolean dataModifyEnabled = false;
    boolean dataEditEnabled = false;
    boolean updateDrag = true;
    EditorHistory editorHistory;
    Component dialogComponent;
    SelectionType selectedType;

    public Editor() {
        this.init();
        this.setSelected(null);
        this.setFigure(null);
        this.editorHistory = new EditorHistory();
        this.entityPicker = new EntityPicker();
        this.dataEditor = new DataEditor();
        this.dataEditor.setLeaveAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.leaveDataEditor();
            }
        });
    }

    public void setDataModifyEnabled(boolean bl) {
        this.dataModifyEnabled = bl;
        if (!this.dataModifyEnabled) {
            this.leaveDataEditor();
        } else if (this.getSelected() != null) {
            this.enterDataEditor();
        }
    }

    public boolean isDataModifyEnabled() {
        return this.dataModifyEnabled;
    }

    public void setUpdateDrag(boolean bl) {
        this.updateDrag = bl;
    }

    public void onRightMouseClick(MouseEvent mouseEvent) {
        if (!this.dataEditEnabled) {
            this.lastClick[0] = mouseEvent.getX();
            this.lastClick[1] = mouseEvent.getY();
            boolean bl = ScilabClipboard.getInstance().canPaste();
            this.paste.setEnabled(bl);
            boolean bl2 = AxesHandler.isAxesNotBlank((Integer)this.figureUid);
            this.clipboardCopy.setEnabled(bl2);
            this.pasteStyle.setEnabled(ScilabClipboard.getInstance().canPasteStyle());
            this.undo.setEnabled(this.editorHistory.isUndoEnabled());
            this.redo.setEnabled(this.editorHistory.isRedoEnabled());
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            this.dialogComponent = mouseEvent.getComponent();
        } else {
            this.dataEditor.onRightClick(mouseEvent);
        }
    }

    public void onLeftMouseDown(MouseEvent mouseEvent) {
        this.lastClick[0] = mouseEvent.getX();
        this.lastClick[1] = mouseEvent.getY();
        if (!this.dataEditEnabled) {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.setSelected(this.tryPickAnyObject(this.lastClick));
                    break;
                }
                case 2: {
                    if (this.selected != null && this.selectedType == SelectionType.POLYLINE && this.dataModifyEnabled) {
                        this.enterDataEditor();
                        break;
                    }
                    if (this.selectedLegend != null) {
                        this.onClickInsert(this.selectedLegend.polyline);
                        break;
                    }
                    this.onClickLabel(EntityPicker.pickLabel((Integer)this.figureUid, (Integer[])this.lastClick));
                    break;
                }
            }
        } else {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    this.dataEditor.onLeftMouseDown(mouseEvent);
                    break;
                }
                case 2: {
                    this.dataEditor.onLeftDoubleClick(mouseEvent);
                    break;
                }
            }
        }
        this.dragClick[0] = this.lastClick[0];
        this.dragClick[1] = this.lastClick[1];
    }

    public void onLeftMouseRelease(MouseEvent mouseEvent) {
        Integer n = this.getSelected();
        if (this.dataModifyEnabled && !this.dataEditEnabled && n != null) {
            this.editorHistory.addAction(new ActionMove(n, this.lastClick, this.dragClick, this.selectedType == SelectionType.LEGEND));
        } else {
            this.dataEditor.onLeftMouseRelease(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        Integer[] integerArray = new Integer[]{mouseEvent.getX(), mouseEvent.getY()};
        if (this.dataModifyEnabled) {
            if (!this.dataEditEnabled) {
                Integer n = this.getSelected();
                if (n != null) {
                    if (this.selectedType == SelectionType.LEGEND) {
                        LegendHandler.dragLegend((Integer)n, (Integer[])this.dragClick, (Integer[])integerArray);
                    } else if (this.selectedType == SelectionType.POLYLINE) {
                        PolylineHandler.getInstance().dragPolyline(n, this.dragClick, integerArray);
                    }
                } else {
                    LabelHandler.dragLabel(this.figureUid, this.dragClick, integerArray, this.updateDrag);
                }
            } else {
                this.dataEditor.onDrag(this.dragClick, integerArray);
            }
        }
        this.dragClick[0] = integerArray[0];
        this.dragClick[1] = integerArray[1];
    }

    void onKeyPressed(KeyEvent keyEvent) {
        block17: {
            block16: {
                if (!keyEvent.isControlDown()) break block16;
                switch (keyEvent.getKeyCode()) {
                    case 67: {
                        if (this.getSelected() != null) {
                            this.onClickCopy();
                            break;
                        }
                        break block17;
                    }
                    case 86: {
                        if (ScilabClipboard.getInstance().canPaste()) {
                            this.onClickPaste();
                            break;
                        }
                        break block17;
                    }
                    case 88: {
                        this.onClickCut();
                        break;
                    }
                    case 90: {
                        if (this.editorHistory.isUndoEnabled()) {
                            this.onClickUndo();
                            break;
                        }
                        break block17;
                    }
                    case 78: {
                        try {
                            ScilabInterpreterManagement.asynchronousScilabExec(null, (String)"scf();");
                        }
                        catch (Exception exception) {
                            System.err.println(exception);
                        }
                        break;
                    }
                }
                break block17;
            }
            switch (keyEvent.getKeyCode()) {
                case 127: {
                    if (this.dataEditEnabled) break;
                    this.onClickDelete();
                    break;
                }
                case 27: {
                    this.leaveDataEditor();
                    break;
                }
            }
        }
    }

    public void init() {
        this.menu = new JPopupMenu();
        this.labels = new JMenu(Messages.gettext((String)"Label"));
        this.legends = new JMenu(Messages.gettext((String)"Legend"));
        this.copy = new JMenuItem(Messages.gettext((String)"Copy"));
        this.copy.setToolTipText(Messages.gettext((String)"Copy selected object"));
        this.cut = new JMenuItem(Messages.gettext((String)"Cut"));
        this.cut.setToolTipText(Messages.gettext((String)"Cut selected object"));
        this.paste = new JMenuItem(Messages.gettext((String)"Paste"));
        this.paste.setToolTipText(Messages.gettext((String)"Paste copied object on this figure"));
        this.delete = new JMenuItem(Messages.gettext((String)"Delete"));
        this.delete.setToolTipText(Messages.gettext((String)"Delete selected object"));
        this.clear = new JMenuItem(Messages.gettext((String)"Clear axes"));
        this.clear.setToolTipText(Messages.gettext((String)"Delete axes contents and labels"));
        this.hide = new JMenuItem(Messages.gettext((String)"Hide"));
        this.hide.setToolTipText(Messages.gettext((String)"Hide selected object"));
        this.unhide = new JMenuItem(Messages.gettext((String)"Unhide all"));
        this.unhide.setToolTipText(Messages.gettext((String)"Unhide all objects"));
        this.clipboardCopy = new JMenuItem(Messages.gettext((String)"Copy to Clipboard"));
        this.clipboardCopy.setToolTipText(Messages.gettext((String)"Copy figure to system clipboard"));
        this.title = new JMenuItem(Messages.gettext((String)"Title"));
        this.title.setToolTipText(Messages.gettext((String)"Set the axes main title"));
        this.labelX = new JMenuItem(Messages.gettext((String)"Label X"));
        this.labelX.setToolTipText(Messages.gettext((String)"Set the X axis label"));
        this.labelY = new JMenuItem(Messages.gettext((String)"Label Y"));
        this.labelY.setToolTipText(Messages.gettext((String)"Set the Y axis label"));
        this.labelZ = new JMenuItem(Messages.gettext((String)"Label Z"));
        this.labelZ.setToolTipText(Messages.gettext((String)"Set the Z axis label"));
        this.insert = new JMenuItem(Messages.gettext((String)"Insert"));
        this.insert.setToolTipText(Messages.gettext((String)"Insert a legend into the selected curve"));
        this.remove = new JMenuItem(Messages.gettext((String)"Remove"));
        this.remove.setToolTipText(Messages.gettext((String)"Remove the legend from the selected curve"));
        this.ged = new JMenuItem(Messages.gettext((String)"Open Quick Editor"));
        this.ged.setToolTipText(Messages.gettext((String)"Initialize the graphics editor"));
        this.editdata = new JMenuItem(Messages.gettext((String)"Edit curve data"));
        this.editdata.setToolTipText(Messages.gettext((String)"Enables curve data modification"));
        this.undo = new JMenuItem(Messages.gettext((String)"Undo"));
        this.undo.setToolTipText(Messages.gettext((String)"Undo last action"));
        this.redo = new JMenuItem(Messages.gettext((String)"Redo"));
        this.redo.setToolTipText(Messages.gettext((String)"Redo last undo action"));
        this.copyStyle = new JMenuItem(Messages.gettext((String)"Copy style"));
        this.copyStyle.setToolTipText(Messages.gettext((String)"Copy the style of the axes"));
        this.pasteStyle = new JMenuItem(Messages.gettext((String)"Paste style"));
        this.pasteStyle.setToolTipText(Messages.gettext((String)"Paste the copied style on these axes"));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickCopy();
            }
        });
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickCut();
            }
        });
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickPaste();
            }
        });
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickDelete();
            }
        });
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickClear();
            }
        });
        this.hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickHide();
            }
        });
        this.unhide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickUnhide();
            }
        });
        this.clipboardCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickCCopy();
            }
        });
        this.labelX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickLabel(AxesHandler.axisTo.__X__);
            }
        });
        this.labelY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickLabel(AxesHandler.axisTo.__Y__);
            }
        });
        this.labelZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickLabel(AxesHandler.axisTo.__Z__);
            }
        });
        this.title.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickLabel(AxesHandler.axisTo.__TITLE__);
            }
        });
        this.insert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickInsert(Editor.this.getSelected());
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickRemove();
            }
        });
        this.ged.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickGED();
            }
        });
        this.editdata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.setDataModifyEnabled(true);
            }
        });
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickUndo();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickRedo();
            }
        });
        this.copyStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickCopyStyle();
            }
        });
        this.pasteStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.onClickPasteStyle();
            }
        });
        this.labels.add(this.labelX);
        this.labels.add(this.labelY);
        this.labels.add(this.labelZ);
        this.labels.add(this.title);
        this.legends.add(this.insert);
        this.legends.add(this.remove);
        this.menu.add(this.copy);
        this.menu.add(this.cut);
        this.menu.add(this.paste);
        this.menu.add(this.copyStyle);
        this.menu.add(this.pasteStyle);
        this.menu.addSeparator();
        this.menu.add(this.delete);
        this.menu.add(this.clear);
        this.menu.add(this.undo);
        this.menu.add(this.redo);
        this.menu.addSeparator();
        this.menu.add(this.hide);
        this.menu.add(this.unhide);
        this.menu.addSeparator();
        this.menu.add(this.clipboardCopy);
        this.menu.addSeparator();
        this.menu.add(this.labels);
        this.menu.add(this.legends);
        this.menu.add(this.editdata);
        if (StartGED.enableNewGed) {
            this.menu.addSeparator();
            this.menu.add(this.ged);
        }
    }

    public void setSelected(Integer n) {
        if (CommonHandler.objectExists((Integer)this.selected).booleanValue()) {
            CommonHandler.setSelected((Integer)this.selected, (boolean)false);
        }
        this.selected = n;
        if (this.selected != null) {
            CommonHandler.setSelected((Integer)this.selected, (boolean)true);
            boolean bl = this.selectedType == SelectionType.SURFACE || this.selectedType == SelectionType.POLYLINE || this.selectedType == SelectionType.LEGEND;
            boolean bl2 = this.selectedType == SelectionType.SURFACE || this.selectedType == SelectionType.POLYLINE;
            boolean bl3 = this.selectedType == SelectionType.POLYLINE;
            this.delete.setEnabled(bl);
            this.copy.setEnabled(bl2);
            this.cut.setEnabled(bl2);
            this.hide.setEnabled(bl2);
            this.legends.setEnabled(bl3);
            this.editdata.setEnabled(bl3);
        } else {
            this.copy.setEnabled(false);
            this.cut.setEnabled(false);
            this.delete.setEnabled(false);
            this.hide.setEnabled(false);
            this.legends.setEnabled(false);
            this.editdata.setEnabled(false);
        }
    }

    public Integer getSelected() {
        if (CommonHandler.objectExists((Integer)this.selected).booleanValue()) {
            return this.selected;
        }
        this.setSelected(null);
        return null;
    }

    public void setFigure(Integer n) {
        this.figureUid = n;
    }

    public Integer getFigureUid() {
        return this.figureUid;
    }

    public void onClickCopy() {
        if (this.selectedType != SelectionType.LEGEND) {
            ScilabClipboard.getInstance().copy(this.getSelected());
        }
    }

    public void onClickPaste() {
        String string;
        int n;
        boolean bl = false;
        Integer n2 = ScilabClipboard.getInstance().getCurrentObject();
        Integer n3 = CommonHandler.getParent((Integer)n2);
        Integer n4 = CommonHandler.getParentFigure((Integer)n2);
        if (!CommonHandler.cmpColorMap((Integer)this.figureUid, (Integer)n4) && (n = JOptionPane.showConfirmDialog(this.dialogComponent, Messages.gettext((String)(string = "The colormap from source figure seems to be different from the destination figure.\nThis may influence the final appearance from the object.\nDo you want copy the color map too?")), Messages.gettext((String)"Warning"), 0)) == 0) {
            CommonHandler.cloneColorMap((Integer)n4, (Integer)this.figureUid);
        }
        AxesHandler.pasteRotationAngles((Integer)n2, (Integer)this.figureUid, (Integer[])this.lastClick);
        Integer n5 = ScilabClipboard.getInstance().paste(this.figureUid, this.lastClick);
        Integer n6 = CommonHandler.getParent((Integer)n5);
        if (n5 == n2) {
            bl = false;
        }
        this.editorHistory.addAction(new ActionPaste(n5, n3, n6, bl));
    }

    public void onClickCut() {
        Integer n = this.getSelected();
        if (n != null && this.selectedType != SelectionType.LEGEND) {
            this.setSelected(null);
            ScilabClipboard.getInstance().cut(n);
        }
    }

    public void onClickDelete() {
        Integer n = this.getSelected();
        if (n != null) {
            this.setSelected(null);
            this.editorHistory.addAction(new ActionDelete(n, CommonHandler.getParent((Integer)n)));
            CommonHandler.cut((Integer)n);
        }
    }

    public void onClickClear() {
        this.setSelected(null);
        Integer n = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        if (n != null) {
            PolylineHandler.getInstance().deleteAll(n);
        }
    }

    public void onClickHide() {
        if (this.getSelected() != null) {
            CommonHandler.setVisible((Integer)this.selected, (boolean)false);
            this.editorHistory.addAction(new ActionHide(this.selected));
            this.setSelected(null);
        }
    }

    public void onClickUnhide() {
        CommonHandler.unhideAll((Integer)this.figureUid);
    }

    public void onClickCCopy() {
        SystemClipboard.copyToSysClipboard(this.figureUid);
    }

    public void onClickLabel(AxesHandler.axisTo axisTo2) {
        Integer n = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        if (n != null && axisTo2 != null) {
            String string = LabelHandler.getLabelText(n, axisTo2);
            String string2 = (String)JOptionPane.showInputDialog(this.dialogComponent, Messages.gettext((String)"Enter the text"), Messages.gettext((String)"Set label text"), -1, null, null, string);
            if (string2 != null) {
                String[] stringArray = new String[]{string2};
                String[] stringArray2 = new String[]{string};
                Integer n2 = LabelHandler.setLabel(n, stringArray, axisTo2);
                this.editorHistory.addAction(new ActionTextEdit(n2, stringArray2, stringArray));
            }
        }
    }

    public void onClickInsert(Integer n) {
        Integer n2 = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        if (n2 != null) {
            String string = LegendHandler.getLegendText((Integer)n2, (Integer)n);
            String string2 = (String)JOptionPane.showInputDialog(this.dialogComponent, Messages.gettext((String)"Enter the text"), Messages.gettext((String)"Set legend text"), -1, null, null, string);
            if (string2 != null && !string2.equals(string)) {
                Integer n3 = LegendHandler.searchLegend((Integer)n2);
                Integer[] integerArray = LegendHandler.getLinks((Integer)n3);
                String[] stringArray = LegendHandler.getText((Integer)n3);
                Double[] doubleArray = LegendHandler.getPosition((Integer)n3);
                LegendHandler.setLegend((Integer)n3, (Integer)n2, (Integer)n, (String)string2);
                this.editorHistory.addAction(new ActionLegend(n2, integerArray, stringArray, doubleArray));
            }
        }
    }

    public void onClickRemove() {
        Integer n = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        Integer n2 = LegendHandler.searchLegend((Integer)n);
        Integer[] integerArray = LegendHandler.getLinks((Integer)n2);
        String[] stringArray = LegendHandler.getText((Integer)n2);
        Double[] doubleArray = LegendHandler.getPosition((Integer)n2);
        LegendHandler.removeLegend((Integer)n, (Integer)this.selected);
        this.editorHistory.addAction(new ActionLegend(n, integerArray, stringArray, doubleArray));
    }

    public void enterDataEditor() {
        if (!this.dataEditEnabled && this.selectedType == SelectionType.POLYLINE) {
            this.dataEditor.beginEdit(this.selected);
            this.dataEditEnabled = true;
        }
    }

    public void leaveDataEditor() {
        if (this.dataEditEnabled) {
            this.dataEditor.endEdit();
            this.dataEditEnabled = false;
        }
    }

    public void onClickGED() {
        if (DatatipManager.getFromUid(this.figureUid).pickAndHighlight(this.lastClick[0], this.lastClick[1])) {
            Inspector.getInspector(DatatipManager.getFromUid(this.figureUid).getSelectedTip());
        } else {
            Integer[] integerArray = new GEDPicker().pick(this.figureUid, this.lastClick);
            Inspector.getInspector(integerArray[integerArray.length - 1]);
        }
    }

    public void onClickUndo() {
        this.editorHistory.undo();
    }

    public void onClickRedo() {
        this.editorHistory.redo();
    }

    public void onClickCopyStyle() {
        Integer n = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        ScilabClipboard.getInstance().copyStyle(n);
    }

    public void onClickPasteStyle() {
        Double[] doubleArray;
        int n;
        boolean bl = true;
        Integer n2 = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        if (!AxesHandler.isAxesEmpty((Integer)n2) && (n = JOptionPane.showConfirmDialog(this.dialogComponent, Messages.gettext((String)(doubleArray = "The axes which the style was copied is not in CubeView\nIf you don't copy the data bounds the view angles can appear different\nDo you want copy the data bounds too?(it can shrink/stretch the current view)")), Messages.gettext((String)"Warning"), 0)) == 1) {
            bl = false;
        }
        doubleArray = CommonHandler.getColorMap((Integer)this.figureUid);
        Integer n3 = CommonHandler.getBackground((Integer)this.figureUid);
        Integer n4 = AxesHandler.clickedAxes((Integer)this.figureUid, (Integer[])this.lastClick);
        Integer n5 = ScilabClipboard.getInstance().pasteStyle(n4, bl);
        this.editorHistory.addAction(new ActionPasteStyle(n5, n4, doubleArray, n3));
    }

    private Integer tryPickAnyObject(Integer[] integerArray) {
        this.selectedLegend = this.entityPicker.pickLegend(this.figureUid, integerArray);
        if (this.selectedLegend != null) {
            this.selectedType = SelectionType.LEGEND;
            return this.selectedLegend.legend;
        }
        Integer n = this.entityPicker.pick(this.figureUid, integerArray[0], integerArray[1]);
        if (n != null) {
            this.selectedType = SelectionType.POLYLINE;
            return n;
        }
        this.selectedSurface = this.entityPicker.pickSurface(this.figureUid, integerArray);
        if (this.selectedSurface != null && this.selectedSurface.surface != null) {
            this.selectedType = SelectionType.SURFACE;
            return this.selectedSurface.surface;
        }
        return null;
    }

    static enum SelectionType {
        POLYLINE,
        LEGEND,
        SURFACE;

    }
}

