/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.rmi.server.UID;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.flexdock.docking.DockingPort;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.gui.bridge.menubar.SwingScilabMenuBar;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.textbox.SwingScilabTextBox;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.OSXAdapter;
import org.scilab.modules.gui.bridge.window.SwingScilabDockingWindow;
import org.scilab.modules.gui.bridge.window.SwingScilabStaticWindow;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.SimpleMenuBar;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.textbox.SimpleTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.SimpleToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.window.SimpleWindow;

public abstract class SwingScilabWindow
extends JFrame
implements SimpleWindow {
    private static final long serialVersionUID = -5661926417765805660L;
    private static final int DEFAULTWIDTH = 500;
    private static final int DEFAULTHEIGHT = 500;
    public static Map<String, SwingScilabWindow> allScilabWindows = Collections.synchronizedMap(new HashMap());
    protected SimpleMenuBar menuBar;
    protected SimpleToolBar toolBar;
    protected SimpleTextBox infoBar;
    private String uuid;
    private int elementId;
    protected String windowUID;
    private final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private Dimension lastDimension;
    private Point lastPosition;
    private boolean isRestoring;

    public SwingScilabWindow() {
        this.uuid = UUID.randomUUID().toString();
        this.setDefaultCloseOperation(0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingScilabWindow.this.processWindowEvent(new WindowEvent(SwingScilabWindow.this, 201));
            }
        };
        this.getRootPane().registerKeyboardAction(actionListener, ScilabKeyStroke.getKeyStroke((String)"OSSCKEY W"), 2);
        this.setDims(new Size(500, 500));
        this.setTitle("Scilab");
        this.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"scilab", (String)"256x256")).getImage());
        super.setLayout(new BorderLayout());
        this.windowUID = new UID().toString();
        allScilabWindows.put(this.windowUID, this);
        this.menuBar = null;
        this.toolBar = null;
        this.infoBar = null;
        this.setLocationByPlatform(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (SwingScilabWindow.this.getExtendedState() == 0) {
                    SwingScilabWindow.this.lastDimension = SwingScilabWindow.this.getSize();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (SwingScilabWindow.this.getExtendedState() == 0) {
                    SwingScilabWindow.this.lastPosition = SwingScilabWindow.this.getLocation();
                }
            }
        });
        if (this.MAC_OS_X) {
            this.registerForMacOSXEvents();
        }
    }

    public void setIsRestoring(boolean bl) {
        this.isRestoring = bl;
    }

    public boolean isRestoring() {
        return this.isRestoring;
    }

    public Dimension getLastDimension() {
        if (this.lastDimension == null) {
            return this.getSize();
        }
        return this.lastDimension;
    }

    public Point getLastPosition() {
        if (this.lastPosition == null) {
            return this.getLocation();
        }
        return this.lastPosition;
    }

    private void registerForMacOSXEvents() {
        try {
            OSXAdapter.setAboutHandler(this, this.getClass().getMethod("macosxAbout", null));
            OSXAdapter.setQuitHandler(this, this.getClass().getMethod("macosxQuit", null));
            OSXAdapter.setPreferencesHandler(this, this.getClass().getMethod("macosxPreferences", null));
            OSXAdapter.setDockIcon(new ImageIcon(FindIconHelper.findIcon((String)"puffin", (String)"256x256")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("OSXAdapter could not find the method: " + noSuchMethodException.getLocalizedMessage());
        }
    }

    public void macosxAbout() {
        InterpreterManagement.requestScilabExec((String)"about();");
    }

    public boolean macosxQuit() {
        InterpreterManagement.requestScilabExec((String)"exit();");
        return false;
    }

    public void macosxPreferences() {
        InterpreterManagement.requestScilabExec((String)"preferences();");
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String string) {
        this.uuid = string;
    }

    public static SwingScilabWindow createWindow(boolean bl) {
        if (bl) {
            return new SwingScilabDockingWindow();
        }
        return new SwingScilabStaticWindow();
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    private void raiseToFront() {
        this.setVisible(true);
        this.setState(0);
        this.toFront();
    }

    @Override
    public void raise() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingScilabWindow.this.raiseToFront();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            this.raiseToFront();
        }
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public void setDims(Size size) {
        if (this.getDims().getWidth() != size.getWidth() || this.getDims().getHeight() != size.getHeight()) {
            Dimension dimension = new Dimension(size.getWidth(), size.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.validate();
        }
    }

    @Override
    public Position getPosition() {
        return new Position(this.getX(), this.getY());
    }

    @Override
    public void setPosition(Position position) {
        if (this.getPosition().getX() != position.getX() || this.getPosition().getY() != position.getY()) {
            this.setLocation(position.getX(), position.getY());
        }
    }

    @Override
    public String getTitle() {
        return super.getTitle();
    }

    @Override
    public void setTitle(String string) {
        if (string != null && !string.equals(this.getTitle())) {
            super.setTitle(string);
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.setTitle(string);
    }

    public abstract DockingPort getDockingPort();

    public abstract void addTab(SwingScilabPanel var1);

    public abstract void removeTabs(SwingScilabPanel[] var1);

    public void removeTab(SimpleTab simpleTab) {
        this.removeTabs(new SwingScilabDockablePanel[]{(SwingScilabDockablePanel)simpleTab});
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        if (menuBar == null) {
            if (this.menuBar != null) {
                this.menuBar = null;
                this.setJMenuBar(null);
            }
        } else if (this.menuBar != menuBar.getAsSimpleMenuBar()) {
            this.menuBar = menuBar.getAsSimpleMenuBar();
            this.setJMenuBar((SwingScilabMenuBar)menuBar.getAsSimpleMenuBar());
        }
    }

    public boolean compareMenuBar(MenuBar menuBar) {
        if (menuBar == null ^ this.menuBar == null) {
            return false;
        }
        if (menuBar == null && this.menuBar == null) {
            return true;
        }
        return menuBar.getAsSimpleMenuBar() == this.menuBar;
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        if (toolBar == null) {
            if (this.toolBar != null) {
                super.remove((SwingScilabToolBar)this.toolBar);
                this.toolBar = null;
            }
        } else if (this.toolBar != toolBar.getAsSimpleToolBar()) {
            if (this.toolBar != null) {
                super.remove((SwingScilabToolBar)this.toolBar);
            }
            this.toolBar = toolBar.getAsSimpleToolBar();
            super.add((Component)((SwingScilabToolBar)this.toolBar), "First");
        }
    }

    public boolean compareToolBar(ToolBar toolBar) {
        if (toolBar == null ^ this.toolBar == null) {
            return false;
        }
        if (toolBar == null && this.toolBar == null) {
            return true;
        }
        return toolBar.getAsSimpleToolBar() == this.toolBar;
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        if (textBox == null) {
            if (this.infoBar != null) {
                super.remove((SwingScilabTextBox)this.infoBar);
                this.infoBar = null;
            }
        } else if (this.infoBar != textBox.getAsSimpleTextBox()) {
            if (this.infoBar != null) {
                super.remove((SwingScilabTextBox)this.infoBar);
            }
            this.infoBar = textBox.getAsSimpleTextBox();
            super.add((Component)((SwingScilabTextBox)this.infoBar), "Last");
        }
    }

    public boolean compareInfoBar(TextBox textBox) {
        if (textBox == null ^ this.infoBar == null) {
            return false;
        }
        if (textBox == null && this.infoBar == null) {
            return true;
        }
        return textBox.getAsSimpleTextBox() == this.infoBar;
    }

    @Override
    public int getElementId() {
        return this.elementId;
    }

    @Override
    public void setElementId(int n) {
        this.elementId = n;
    }

    @Override
    public abstract void close();

    @Override
    public abstract int getNbDockedObjects();

    @Override
    public void updateDimensions() {
        this.pack();
    }

    @Override
    public void windowDeiconified() {
        super.setState(0);
    }

    @Override
    public void windowIconified() {
        super.setState(1);
    }

    @Override
    public void windowMaximized() {
        super.setExtendedState(6);
    }

    @Override
    public void windowNormal() {
        super.setState(0);
    }

    public String getId() {
        return this.windowUID;
    }
}

