/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.window;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Set;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.defaults.DefaultDockingStrategy;
import org.flexdock.docking.drag.effects.DragPreview;
import org.flexdock.docking.drag.effects.EffectsManager;
import org.flexdock.docking.drag.preview.GhostPreview;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.event.hierarchy.DockingPortTracker;
import org.scilab.modules.gui.bridge.menubar.SwingScilabMenuBar;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.SciDockingListener;

public class SwingScilabDockingWindow
extends SwingScilabWindow {
    private DefaultDockingPort sciDockingPort = new DefaultDockingPort();
    private SciDockingListener sciDockingListener;

    public SwingScilabDockingWindow() {
        EffectsManager.setPreview((DragPreview)new GhostPreview());
        super.add((Component)this.sciDockingPort, "Center");
        this.sciDockingListener = new SciDockingListener();
        this.sciDockingPort.addDockingListener((DockingListener)this.sciDockingListener);
        this.sciDockingListener.setAssociatedWindowId(this.windowUID);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ClosingOperationsManager.startClosingOperation(SwingScilabDockingWindow.this);
            }
        });
    }

    @Override
    public DockingPort getDockingPort() {
        return this.sciDockingPort;
    }

    @Override
    public void addTab(SwingScilabPanel swingScilabPanel) {
        SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)swingScilabPanel;
        swingScilabDockablePanel.setParentWindowId(this.windowUID);
        DockingManager.dock((Component)((Object)swingScilabDockablePanel), (DockingPort)this.getDockingPort());
        ActiveDockableTracker.requestDockableActivation((Component)((Object)swingScilabDockablePanel));
    }

    @Override
    public void removeTabs(SwingScilabPanel[] swingScilabPanelArray) {
        for (SwingScilabDockablePanel swingScilabDockablePanel : (SwingScilabDockablePanel[])swingScilabPanelArray) {
            DockingManager.unregisterDockable((Dockable)swingScilabDockablePanel);
            swingScilabDockablePanel.close();
            DockingManager.close((Dockable)swingScilabDockablePanel);
        }
        if (this.getDockingPort() == null || this.getDockingPort().getDockables().isEmpty()) {
            if (this.toolBar != null) {
                ((SwingScilabToolBar)this.toolBar).removeAll();
            }
            if (this.menuBar != null) {
                ((SwingScilabMenuBar)this.menuBar).removeAll();
            }
            this.removeAll();
            this.close();
        } else {
            Set set = this.sciDockingPort.getDockables();
            Iterator iterator = set.iterator();
            ActiveDockableTracker.requestDockableActivation((Component)((Component)iterator.next()));
        }
    }

    @Override
    public int getNbDockedObjects() {
        return this.sciDockingPort.getDockables().size();
    }

    @Override
    public void close() {
        try {
            this.dispose();
            ActiveDockableTracker.getTracker((Component)this).setActive(null);
            if (this.sciDockingPort != null) {
                this.sciDockingPort.removeDockingListener((DockingListener)this.sciDockingListener);
                this.sciDockingPort = null;
                this.sciDockingListener = null;
            }
            DockingPortTracker.remove((Component)this);
        }
        catch (IllegalStateException illegalStateException) {
            this.enableInputMethods(false);
        }
        allScilabWindows.remove(this.windowUID);
    }

    static {
        DefaultDockingStrategy.setDefaultResizeWeight((double)0.5);
        DefaultDockingStrategy.keepConstantPercentage((boolean)true);
    }
}

