/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.uitable;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.bridge.uitable.RowHeaderRenderer;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabUiTable
extends JScrollPane
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -5497171010652701217L;
    private Integer uid;
    private Border defaultBorder = null;
    private JTable uiTable;
    private JList rowHeader;
    private Object[] colNames = new Object[0];
    private Object[] rowNames = new Object[0];
    private Object[][] data = new Object[0][];
    private int nCol;
    private int nRow;
    private JLabel label;

    public SwingScilabUiTable() {
        this.getViewport().add(this.getUiTable());
        this.setRowHeaderView(this.getCustomRowHeader());
    }

    @Override
    public void setFont(Font font) {
        this.getLabel().setFont(font);
    }

    @Override
    public Font getFont() {
        return this.getLabel().getFont();
    }

    @Override
    public Color getForeground() {
        return this.getLabel().getForeground();
    }

    @Override
    public void setForeground(Color color) {
        this.getLabel().setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        this.getLabel().setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.getLabel().getBackground();
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.getLabel().setHorizontalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.getLabel().setVerticalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    private JTable getUiTable() {
        if (this.uiTable == null) {
            this.uiTable = this.createTable(this.data, this.colNames);
            this.uiTable.setFillsViewportHeight(true);
            if (this.uiTable.getGridColor().equals(Color.WHITE)) {
                this.uiTable.setGridColor(new Color(128, 128, 128));
            }
            this.uiTable.setShowHorizontalLines(true);
            this.uiTable.setShowVerticalLines(true);
        }
        return this.uiTable;
    }

    private JList getCustomRowHeader() {
        if (this.rowHeader == null) {
            this.rowHeader = new JList<Object>(this.rowNames);
            this.rowHeader.setFixedCellWidth(50);
            this.rowHeader.setFixedCellHeight(this.uiTable.getRowHeight());
            this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.uiTable));
        }
        return this.rowHeader;
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
        }
        return this.label;
    }

    @Override
    public String getText() {
        return this.getLabel().getText();
    }

    @Override
    public void setText(String string) {
        this.getLabel().setText(string);
    }

    @Override
    public void setEmptyText() {
        this.setColumnNames(new String[]{""});
        this.setRowNames(new String[]{""});
        this.setData(new String[]{""});
    }

    public void setColumnNames(String[] stringArray) {
        this.nCol = stringArray.length;
        this.colNames = stringArray;
        this.uiTable = this.createTable(this.data, stringArray);
        this.getViewport().add(this.uiTable);
        this.uiTable.doLayout();
    }

    public void setRowNames(String[] stringArray) {
        this.nRow = stringArray.length;
        this.rowNames = stringArray;
        this.rowHeader = new JList<String>(stringArray);
        this.rowHeader.setFixedCellWidth(50);
        this.rowHeader.setFixedCellHeight(this.uiTable.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.uiTable));
        this.setRowHeaderView(this.rowHeader);
        this.uiTable.doLayout();
    }

    public void setData(String[] stringArray) {
        if (this.nRow == 0) {
            this.nRow = stringArray.length / this.nCol;
        }
        this.data = new Object[this.nRow][this.nCol];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length && n < this.nRow && n2 < this.nCol; ++i) {
            this.data[n][n2] = stringArray[i];
            if (++n != this.nRow) continue;
            n = 0;
            ++n2;
        }
        if (this.nRow == 0) {
            this.nRow = n2;
            this.rowNames = new Object[this.nRow];
            for (int i = 0; i < this.nRow; ++i) {
                this.rowNames[i] = i;
            }
            this.rowHeader = new JList<Object>(this.rowNames);
            this.rowHeader.setFixedCellWidth(50);
            this.rowHeader.setFixedCellHeight(this.uiTable.getRowHeight());
            this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.uiTable));
            this.setRowHeaderView(this.rowHeader);
        }
        this.uiTable = this.createTable(this.data, this.colNames);
        this.getViewport().add(this.uiTable);
        this.uiTable.doLayout();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.uiTable.setEnabled(bl);
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 302: {
                String[] stringArray = (String[])object;
                if (stringArray.length == 0) {
                    this.setColumnNames(new String[]{""});
                    this.setRowNames(new String[]{""});
                    this.setData(new String[]{""});
                    return;
                }
                int n2 = (Integer)graphicController.getProperty(this.uid, 305);
                String[] stringArray2 = new String[n2 - 1];
                for (int i = 1; i < n2; ++i) {
                    stringArray2[i - 1] = stringArray[i * (stringArray.length / n2)];
                }
                this.setColumnNames(stringArray2);
                String[] stringArray3 = new String[stringArray.length / n2 - 1];
                for (int i = 1; i < stringArray.length / n2; ++i) {
                    stringArray3[i - 1] = stringArray[i];
                }
                this.setRowNames(stringArray3);
                String[] stringArray4 = new String[stringArray3.length * stringArray2.length];
                int n3 = 0;
                for (int i = 1; i <= stringArray2.length; ++i) {
                    for (int j = 1; j <= stringArray3.length; ++j) {
                        stringArray4[n3++] = stringArray[i * (stringArray.length / n2) + j];
                    }
                }
                if (stringArray4.length == 0) break;
                this.setData(stringArray4);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollPane.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollPane.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    private JTable createTable(Object[][] objectArray, Object[] objectArray2) {
        JTable jTable = new JTable(objectArray, objectArray2);
        jTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                Object object = ((TableModel)tableModelEvent.getSource()).getValueAt(n, n2);
                String[] stringArray = (String[])GraphicController.getController().getProperty(SwingScilabUiTable.this.uid, 302);
                int n3 = (Integer)GraphicController.getController().getProperty(SwingScilabUiTable.this.uid, 305);
                int n4 = stringArray.length / n3;
                stringArray[(n2 + 1) * n4 + n + 1] = object.toString();
                GraphicController.getController().setProperty(SwingScilabUiTable.this.uid, 302, (Object)stringArray);
            }
        });
        return jTable;
    }
}

