/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.tab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.uicontrol.Uicontrol;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.dockable.Dockable;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabTabGroup
extends JTabbedPane
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = 965704348405077905L;
    private Integer id;
    private Border defaultBorder = null;
    private CommonCallBack callback = null;
    private ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingScilabTabGroup.this.updateModelProperties();
            if (SwingScilabTabGroup.this.callback != null) {
                SwingScilabTabGroup.this.callback.actionPerformed(null);
            }
        }
    };

    public SwingScilabTabGroup() {
        this.addChangeListener(this.listener);
    }

    @Override
    public void setId(Integer n) {
        this.id = n;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void update(int n, Object object) {
        block0 : switch (n) {
            case 27: {
                this.setVisible((Boolean)object);
                break;
            }
            case 393: {
                Integer n2 = (Integer)object;
                switch (Uicontrol.TitlePositionType.intToEnum((Integer)n2)) {
                    case BOTTOM: {
                        this.setTabPlacement(3);
                        break block0;
                    }
                    case LEFT: {
                        this.setTabPlacement(2);
                        break block0;
                    }
                    case RIGHT: {
                        this.setTabPlacement(4);
                        break block0;
                    }
                }
                this.setTabPlacement(1);
                break;
            }
            case 394: {
                if (((Boolean)object).booleanValue()) {
                    this.setTabLayoutPolicy(1);
                    break;
                }
                this.setTabLayoutPolicy(0);
                break;
            }
            case 290: 
            case 291: 
            case 292: 
            case 294: {
                for (int i = 0; i < this.getTabCount(); ++i) {
                    this.setTitleAt(i, null);
                }
                break;
            }
            case 80: {
                Double[] doubleArray = (Double[])object;
                this.setSize(doubleArray[2].intValue(), doubleArray[3].intValue());
                Position position = PositionConverter.scilabToJava(new Position(doubleArray[0].intValue(), doubleArray[1].intValue()), new Size(this.getSize().width, this.getSize().height), this.getParent());
                this.setLocation(position.getX(), position.getY());
                break;
            }
            case 310: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length == 0) {
                    return;
                }
                Integer n3 = doubleArray[0].intValue();
                if (n3 <= 0 || n3 > this.getTabCount()) break;
                this.setSelectedIndex(n3 - 1);
                break;
            }
            case 302: {
                String string = ((String[])object)[0];
                for (int i = 0; i < this.getTabCount(); ++i) {
                    JLabel jLabel = (JLabel)this.getTabComponentAt(i);
                    if (jLabel == null || jLabel.getText() == null || !jLabel.getText().equals(string)) continue;
                    this.setSelectedIndex(i);
                    break block0;
                }
                break;
            }
            case 36: {
                int n4 = (Integer)GraphicController.getController().getProperty(this.getId(), 37);
                this.callback = CommonCallBack.createCallback((String)object, n4, this.getId());
                break;
            }
            case 37: {
                String string = (String)GraphicController.getController().getProperty(this.getId(), 36);
                if ((Integer)object == -1) {
                    this.callback = null;
                    break;
                }
                this.callback = CommonCallBack.createCallback(string, (Integer)object, this.getId());
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        this.setTitleAt(n, string);
        this.setSelectedIndex(n);
    }

    public void updateModelProperties() {
        GraphicController graphicController = GraphicController.getController();
        int n = this.getSelectedIndex();
        Double[] doubleArray = (Double[])graphicController.getProperty(this.getId(), 310);
        Integer n2 = null;
        if (doubleArray != null && doubleArray[0] != null) {
            if (doubleArray[0] == 0.0) {
                doubleArray[0] = 1.0;
            }
            n2 = ((SwingViewObject)((Object)this.getComponentAt(doubleArray[0].intValue() - 1))).getId();
        }
        Integer n3 = ((SwingViewObject)((Object)this.getComponentAt(n))).getId();
        if (n2 != null && n2 != 0) {
            graphicController.setProperty(n2, 27, (Object)false);
        }
        if (n3 != null && n3 != 0) {
            graphicController.setProperty(n3, 27, (Object)true);
        }
        graphicController.setProperty(this.getId(), 311, (Object)new Double[]{n + 1});
        String string = (String)graphicController.getProperty(n3, 100);
        graphicController.setProperty(this.getId(), 303, (Object)new String[]{string});
    }

    @Override
    public void setTitleAt(int n, String string) {
        String string2 = (String)GraphicController.getController().getProperty(this.getId(), 291);
        Double d = (Double)GraphicController.getController().getProperty(this.getId(), 292);
        String string3 = (String)GraphicController.getController().getProperty(this.getId(), 290);
        String string4 = (String)GraphicController.getController().getProperty(this.getId(), 294);
        int n2 = 0;
        if (string3.equals("italic")) {
            n2 |= 2;
        }
        if (string4.equals("bold")) {
            n2 |= 1;
        }
        JLabel jLabel = null;
        Component component = this.getTabComponentAt(n);
        jLabel = component instanceof JLabel ? (JLabel)component : new JLabel();
        Font font = jLabel.getFont();
        Font font2 = new Font(!string2.equals("") ? string2 : font.getFontName(), n2, d != 0.0 ? d.intValue() : font.getSize());
        jLabel.setFont(font2);
        if (string != null) {
            jLabel.setText(string);
        }
        this.setTabComponentAt(n, jLabel);
    }

    public Boolean isTabActive(Component component) {
        if (this.getSelectedComponent() == component) {
            return true;
        }
        return false;
    }

    public Integer getIndex(Component component) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getComponentAt(i) != component) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setEnabledAt(int n, boolean bl) {
        super.setEnabledAt(n, bl);
        this.getTabComponentAt(n).setEnabled(bl);
        if (!bl && n == this.getSelectedIndex()) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (!this.getComponentAt(i).isEnabled()) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        if (bl) {
            super.setEnabled(bl);
            Integer[] integerArray = (Integer[])GraphicController.getController().getProperty(this.getId(), 22);
            for (int i = 0; i < integerArray.length; ++i) {
                Boolean bl2 = (Boolean)GraphicController.getController().getProperty(integerArray[i], 289);
                SwingView.getFromId(integerArray[i]).update(289, bl2);
            }
        } else {
            super.setEnabled(bl);
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(false);
            }
        }
    }

    public int addMember(Dockable dockable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("TabbedPane.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    @Override
    public void setText(String string) {
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        this.getParent().remove(this);
        this.setVisible(false);
    }

    public void setIconAt(int n, String string) {
        try {
            Object object;
            File file = new File(string);
            if (!file.exists()) {
                object = FindIconHelper.findImage((String)string);
                file = new File((String)object);
            }
            if ((object = (JLabel)this.getTabComponentAt(n)) != null) {
                ((JLabel)object).setIcon(new ImageIcon(ImageIO.read(file)));
            }
        }
        catch (IOException iOException) {
            super.setIconAt(n, null);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("TabbedPane.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

