/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.tab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.bridge.canvas.SwingScilabCanvas;
import org.scilab.modules.gui.bridge.tab.SwingScilabAxes;
import org.scilab.modules.gui.bridge.tab.SwingScilabCommonPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabScrollPane;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.editor.EditorEventListener;
import org.scilab.modules.gui.events.ScilabEventListener;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabStaticPanel
extends SwingScilabScrollPane
implements SwingScilabPanel {
    private static final long serialVersionUID = -3887923938827929317L;
    private Integer id;
    private TextBox infoBar;
    private MenuBar menuBar;
    private ToolBar toolBar;
    private String parentWindowId;
    private JLayeredPane uiContentPane;
    private JLayeredPane layeredPane;
    private boolean eventEnabled = false;
    private ComponentListener componentListener;
    private HierarchyBoundsListener ancestorListener;
    private ScilabEventListener eventHandler;
    private EditorEventListener editorEventHandler = null;
    private SwingScilabCanvas contentCanvas;
    protected boolean hasLayout;
    private Dimension deltaSize = null;
    private CommonCallBack callback;

    public SwingScilabStaticPanel(String string, Integer n, Figure figure) {
        super((Component)new JLayeredPane(), new JLayeredPane(), figure);
        this.editorEventHandler = new EditorEventListener(figure.getIdentifier());
        this.uiContentPane = (JLayeredPane)this.getUIComponent();
        this.layeredPane = (JLayeredPane)this.getGlobalComponent();
        this.setVisible(true);
        this.layeredPane.setLayout(null);
        this.layeredPane.setOpaque(true);
        this.setHasLayout(false);
        this.uiContentPane.setOpaque(false);
        this.uiContentPane.setLayout(null);
        this.layeredPane.add(this.uiContentPane, JLayeredPane.DEFAULT_LAYER + 1, 0);
        this.layeredPane.setVisible(true);
        this.uiContentPane.setVisible(true);
        this.ancestorListener = new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
            }

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getChanged() instanceof SwingScilabWindow) {
                    Position position = SwingScilabWindow.allScilabWindows.get(SwingScilabStaticPanel.this.parentWindowId).getPosition();
                    Integer[] integerArray = new Integer[]{position.getX(), position.getY()};
                    GraphicController.getController().setProperty(SwingScilabStaticPanel.this.id, 80, (Object)integerArray);
                }
            }
        };
        this.addHierarchyBoundsListener(this.ancestorListener);
        this.componentListener = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Integer[] integerArray;
                Size size = SwingScilabWindow.allScilabWindows.get(SwingScilabStaticPanel.this.parentWindowId).getDims();
                Integer[] integerArray2 = new Integer[]{size.getWidth(), size.getHeight()};
                GraphicController.getController().setProperty(SwingScilabStaticPanel.this.id, 81, (Object)integerArray2);
                Boolean bl = (Boolean)GraphicController.getController().getProperty(SwingScilabStaticPanel.this.id, 83);
                if (bl != null && bl.booleanValue()) {
                    integerArray = new Integer[]{SwingScilabStaticPanel.this.getContentPane().getWidth(), SwingScilabStaticPanel.this.getContentPane().getHeight()};
                    GraphicController.getController().setProperty(SwingScilabStaticPanel.this.id, 85, (Object)integerArray);
                }
                if ((integerArray = (Integer[])GraphicController.getController().getProperty(SwingScilabStaticPanel.this.id, 102)) != null && !integerArray.equals("")) {
                    String string = "if exists(\"gcbo\") then %oldgcbo = gcbo; end;gcbo = getcallbackobject(" + SwingScilabStaticPanel.this.id + ");" + (String)integerArray + ";if exists(\"%oldgcbo\") then gcbo = %oldgcbo; else clear gcbo; end;";
                    InterpreterManagement.requestScilabExec((String)string);
                } else if (!SwingScilabStaticPanel.this.hasLayout) {
                    for (Component component : SwingScilabStaticPanel.this.getWidgetPane().getComponents()) {
                        if (!(component instanceof Widget)) continue;
                        Widget widget = (Widget)((Object)component);
                        SwingViewObject swingViewObject = (SwingViewObject)((Object)component);
                        SwingViewWidget.update(widget, 80, GraphicController.getController().getProperty(swingViewObject.getId(), 80));
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        };
        this.addComponentListener(this.componentListener);
    }

    private void enableEventHandler() {
        if (this.contentCanvas != null) {
            this.contentCanvas.addEventHandlerKeyListener(this.eventHandler);
            this.contentCanvas.addEventHandlerMouseListener(this.eventHandler);
            this.contentCanvas.addEventHandlerMouseMotionListener(this.eventHandler);
        }
    }

    private void disableEventHandler() {
        if (this.eventHandler != null && this.contentCanvas != null) {
            this.contentCanvas.removeEventHandlerKeyListener(this.eventHandler);
            this.contentCanvas.removeEventHandlerMouseListener(this.eventHandler);
            this.contentCanvas.removeEventHandlerMouseMotionListener(this.eventHandler);
        }
    }

    @Override
    public void setId(Integer n) {
        this.id = n;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void update(int n, Object object) {
        SwingScilabCommonPanel.update(this, n, object);
    }

    @Override
    public void setFigureBackground(Color color) {
        if (this.layeredPane != null) {
            this.layeredPane.setBackground(color);
        }
    }

    @Override
    public TextBox getInfoBar() {
        return this.infoBar;
    }

    @Override
    public void setInfoBar(TextBox textBox) {
        this.infoBar = textBox;
    }

    @Override
    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Override
    public void setEventHandler(String string) {
        this.disableEventHandler();
        this.eventHandler = new ScilabEventListener(string, this.getId(), false);
        if (this.eventEnabled) {
            this.editorEventHandler.setEnable(false);
            this.enableEventHandler();
        }
    }

    @Override
    public void setEventHandlerEnabled(boolean bl) {
        if (bl && this.eventEnabled) {
            return;
        }
        if (bl) {
            this.editorEventHandler.setEnable(false);
            this.enableEventHandler();
            this.eventEnabled = true;
        } else {
            this.editorEventHandler.setEnable(true);
            this.disableEventHandler();
            this.eventEnabled = false;
        }
    }

    @Override
    public void setParentWindowId(String string) {
        this.parentWindowId = string;
        SwingScilabWindow.allScilabWindows.get(string).setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"graphic-window", (String)"256x256")).getImage());
    }

    @Override
    public void setWindowIcon(String string) {
    }

    @Override
    public void addMember(SwingViewObject swingViewObject) {
        if (swingViewObject instanceof SwingScilabAxes) {
            if (this.contentCanvas == null) {
                this.contentCanvas = new SwingScilabCanvas((AxesContainer)((Figure)GraphicController.getController().getObjectFromId(((SwingScilabAxes)swingViewObject).getFigureId())));
                this.contentCanvas.addEventHandlerKeyListener(this.editorEventHandler);
                this.contentCanvas.addEventHandlerMouseListener(this.editorEventHandler);
                this.contentCanvas.addEventHandlerMouseMotionListener(this.editorEventHandler);
                if (this.eventEnabled) {
                    this.editorEventHandler.setEnable(false);
                    this.enableEventHandler();
                }
                this.layeredPane.add((Component)this.contentCanvas, JLayeredPane.FRAME_CONTENT_LAYER);
                this.setCanvas(this.contentCanvas);
            }
            return;
        }
        SwingScilabCommonPanel.addMember(this, swingViewObject);
    }

    @Override
    public String getParentWindowId() {
        return this.parentWindowId;
    }

    @Override
    public SwingScilabWindow getParentWindow() {
        return (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, this);
    }

    @Override
    public JLayeredPane getWidgetPane() {
        return this.uiContentPane;
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    public CommonCallBack getCallback() {
        return this.callback;
    }

    @Override
    public Container getContentPane() {
        return this.getAsContainer();
    }

    @Override
    public void close() {
        this.setMenuBar(null);
        this.setToolBar(null);
        this.setInfoBar(null);
        this.removeAll();
        SwingScilabWindow swingScilabWindow = this.getParentWindow();
        Container container = new Container();
        swingScilabWindow.setContentPane(container);
        swingScilabWindow.close();
        this.setVisible(false);
    }

    @Override
    public void removeMember(SwingViewObject swingViewObject) {
        SwingScilabCommonPanel.removeMember(this, swingViewObject);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.getParentWindow().setName(string);
    }

    @Override
    public void setHasLayout(boolean bl) {
        this.hasLayout = bl;
    }

    @Override
    public void applyDeltaSize() {
        if (this.deltaSize != null) {
            if (this.deltaSize.getWidth() != 0.0 || this.deltaSize.getHeight() != 0.0) {
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.allScilabWindows.get(this.getParentWindowId());
                Size size = swingScilabWindow.getDims();
                swingScilabWindow.setDims(new Size((int)((double)size.getWidth() + this.deltaSize.getWidth()), (int)((double)size.getHeight() + this.deltaSize.getHeight())));
            }
            this.deltaSize = null;
        }
    }

    @Override
    public void storeSizeDelta() {
        Dimension dimension = this.getContentPane().getSize();
        SwingScilabWindow swingScilabWindow = SwingScilabWindow.allScilabWindows.get(this.getParentWindowId());
        Size size = swingScilabWindow.getDims();
        this.deltaSize = new Dimension((int)((double)size.getWidth() - dimension.getWidth()), (int)((double)size.getHeight() - dimension.getHeight()));
    }

    @Override
    public void disableResizeEvent() {
        this.removeComponentListener(this.componentListener);
    }

    @Override
    public void enableResizeEvent() {
        this.addComponentListener(this.componentListener);
    }
}

