/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.slider;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scilab.modules.commons.OS;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabSlider
extends JSlider
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -4262320156090829309L;
    private static final int MINIMUM_VALUE = 0;
    private static final int MAXIMUM_VALUE = 10000;
    private Integer uid;
    private CommonCallBack callback;
    private ChangeListener changeListener;
    private Border defaultBorder = null;
    private int previousValueCallback = 0;

    public SwingScilabSlider() {
        this.setOpaque(true);
        this.setMinimum(0);
        this.setMaximum(10000);
        this.setValue(0);
        this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "LeftAction");
        this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "LeftAction");
        this.getActionMap().put("LeftAction", new LeftAction());
        this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "RightAction");
        this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "RightAction");
        this.getActionMap().put("RightAction", new RightAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlRightAction");
        this.getInputMap().put(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlRightAction");
        this.getActionMap().put("CtrlRightAction", new CtrlRightAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlLeftAction");
        this.getInputMap().put(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "CtrlLeftAction");
        this.getActionMap().put("CtrlLeftAction", new CtrlLeftAction());
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    SwingScilabSlider.this.previousValueCallback = SwingScilabSlider.this.getValue();
                    SwingScilabSlider.this.updateModel();
                    if (SwingScilabSlider.this.callback != null) {
                        SwingScilabSlider.this.callback.actionPerformed(null);
                    }
                } else {
                    int n = Math.abs(SwingScilabSlider.this.getValue() - SwingScilabSlider.this.previousValueCallback);
                    SwingScilabSlider.this.previousValueCallback = SwingScilabSlider.this.getValue();
                    if (n != SwingScilabSlider.this.getMajorTickSpacing() && n != 0) {
                        SwingScilabSlider.this.updateModel();
                        if (SwingScilabSlider.this.callback != null) {
                            SwingScilabSlider.this.callback.actionPerformed(null);
                        }
                    }
                }
            }
        };
        this.addChangeListener(this.changeListener);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2 = mouseWheelEvent.getWheelRotation();
                int n3 = n = mouseWheelEvent.isControlDown() ? SwingScilabSlider.this.getMajorTickSpacing() : SwingScilabSlider.this.getMinorTickSpacing();
                if (n2 < 0) {
                    SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() + n);
                } else {
                    SwingScilabSlider.this.setValue(SwingScilabSlider.this.getValue() - n);
                }
            }
        });
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(super.getSize().width, super.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        super.setSize(size.getWidth(), size.getHeight());
        super.doLayout();
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public void setText(String string) {
        this.setName(string);
    }

    @Override
    public void setEmptyText() {
        this.setName(null);
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    public void setMinimumValue(double d) {
        this.updateModel();
    }

    public void setMaximumValue(double d) {
        this.updateModel();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    public void setMajorTickSpacing(double d) {
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        double d4 = 10000.0 / (d3 - d2);
        int n = (int)(d * d4);
        super.setMajorTickSpacing(n);
    }

    public void setMinorTickSpacing(double d) {
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        double d4 = 10000.0 / (d3 - d2);
        int n = (int)(d * d4);
        super.setMinorTickSpacing(n);
    }

    public void setVertical() {
        this.setOrientation(1);
    }

    public void setHorizontal() {
        this.setOrientation(0);
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    public void setUserValue(double d) {
        this.removeChangeListener(this.changeListener);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        this.setValue(0 + (int)((d - d2) * 10000.0 / (d3 - d2)));
        this.addChangeListener(this.changeListener);
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 299: {
                Double d = (Double)object;
                Double d2 = (Double)graphicController.getProperty(this.uid, 300);
                this.setMaximumValue(d);
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 308);
                double d3 = doubleArray[0];
                double d4 = doubleArray[1];
                if (!(d2 <= d)) break;
                this.setMinorTickSpacing(d3);
                this.setMajorTickSpacing(d4);
                break;
            }
            case 300: {
                Double d = (Double)object;
                Double d5 = (Double)graphicController.getProperty(this.uid, 299);
                this.setMinimumValue(d);
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 308);
                double d6 = doubleArray[0];
                double d7 = doubleArray[1];
                if (!(d <= d5)) break;
                this.setMinorTickSpacing(d6);
                this.setMajorTickSpacing(d7);
                break;
            }
            case 80: {
                Double[] doubleArray = SwingViewWidget.updatePosition(this, this.uid, object);
                if (doubleArray[2].intValue() > doubleArray[3].intValue()) {
                    this.setHorizontal();
                    break;
                }
                this.setVertical();
                break;
            }
            case 308: {
                Double[] doubleArray = (Double[])object;
                double d = doubleArray[0];
                double d8 = doubleArray[1];
                this.setMinorTickSpacing(d);
                this.setMajorTickSpacing(d8);
                break;
            }
            case 310: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length != 0) {
                    this.setUserValue(doubleArray[0]);
                    break;
                }
                Double d = (Double)graphicController.getProperty(this.uid, 300);
                this.setUserValue(d);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    private void updateModel() {
        Double[] doubleArray = new Double[1];
        double d = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        doubleArray[0] = d + (double)(this.getValue() - 0) * (d2 - d) / 10000.0;
        GraphicController.getController().setProperty(this.uid, 310, (Object)doubleArray);
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Slider.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Slider.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    static {
        if (OS.get() == OS.UNIX) {
            UIManager.put("Slider.paintValue", false);
        }
    }

    class CtrlRightAction
    extends AbstractAction {
        private static final long serialVersionUID = -1364255463511656338L;

        CtrlRightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 300);
            double d2 = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 299);
            Double[] doubleArray = (Double[])GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 308);
            int n = SwingScilabSlider.this.getValue();
            double d3 = 10000.0 / (d2 - d);
            int n2 = Math.min(10000, n + (int)(doubleArray[1] * d3));
            SwingScilabSlider.this.setValue(n2);
        }
    }

    class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = 8666161246122371904L;

        RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 300);
            double d2 = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 299);
            Double[] doubleArray = (Double[])GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 308);
            int n = SwingScilabSlider.this.getValue();
            double d3 = 10000.0 / (d2 - d);
            int n2 = Math.min(10000, n + (int)(doubleArray[0] * d3));
            SwingScilabSlider.this.setValue(n2);
        }
    }

    class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 2099826485447918397L;

        LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 300);
            double d2 = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 299);
            Double[] doubleArray = (Double[])GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 308);
            int n = SwingScilabSlider.this.getValue();
            double d3 = 10000.0 / (d2 - d);
            int n2 = Math.max(0, n - (int)(doubleArray[0] * d3));
            SwingScilabSlider.this.setValue(n2);
        }
    }

    class CtrlLeftAction
    extends AbstractAction {
        private static final long serialVersionUID = -3289281207742516486L;

        CtrlLeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 300);
            double d2 = (Double)GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 299);
            Double[] doubleArray = (Double[])GraphicController.getController().getProperty(SwingScilabSlider.this.uid, 308);
            int n = SwingScilabSlider.this.getValue();
            double d3 = 10000.0 / (d2 - d);
            int n2 = Math.max(0, n - (int)(doubleArray[1] * d3));
            SwingScilabSlider.this.setValue(n2);
        }
    }
}

