/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.slider;

import java.awt.Color;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabScroll
extends JScrollBar
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -4262320156090829309L;
    private static final int MIN_KNOB_SIZE = 40;
    private static final int MINIMUM_VALUE = 0;
    private static final int MAXIMUM_VALUE = 10000;
    private Integer uid;
    private CommonCallBack callback;
    private AdjustmentListener adjustmentListener;
    private Border defaultBorder = null;

    public SwingScilabScroll() {
        this.setOpaque(true);
        this.setFocusable(true);
        this.setMinimum(0);
        this.setMaximum(10000 + this.getVisibleAmount());
        this.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SwingScilabScroll.this.updateModel();
                if (SwingScilabScroll.this.callback != null) {
                    SwingScilabScroll.this.callback.actionPerformed(null);
                }
            }
        };
        this.addAdjustmentListener(this.adjustmentListener);
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(super.getSize().width, super.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        super.setSize(size.getWidth(), size.getHeight());
        super.doLayout();
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public void setText(String string) {
        this.setName(string);
    }

    @Override
    public void setEmptyText() {
        this.setName(null);
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    public void setMinimumValue(double d) {
        this.updateModel();
    }

    public void setMaximumValue(double d) {
        this.updateModel();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    public void setMajorTickSpacing(double d) {
        this.removeAdjustmentListener(this.adjustmentListener);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        this.setBlockIncrement((int)(d * 10000.0 / (d3 - d2)));
        int n = this.getMaximum() - this.getVisibleAmount();
        this.setVisibleAmount(Math.max((int)(10000.0 / d), 40));
        this.setMaximum(n + this.getVisibleAmount());
        this.addAdjustmentListener(this.adjustmentListener);
    }

    public void setMinorTickSpacing(double d) {
        this.removeAdjustmentListener(this.adjustmentListener);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        this.setUnitIncrement((int)(d * 10000.0 / (d3 - d2)));
        this.addAdjustmentListener(this.adjustmentListener);
    }

    public void setVertical() {
        this.setOrientation(1);
    }

    public void setHorizontal() {
        this.setOrientation(0);
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    public void setUserValue(double d) {
        this.removeAdjustmentListener(this.adjustmentListener);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d3 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        super.setValue(0 + (int)((d - d2) * 10000.0 / (d3 - d2)));
        this.addAdjustmentListener(this.adjustmentListener);
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 299: {
                Double d = (Double)object;
                Double d2 = (Double)graphicController.getProperty(this.uid, 300);
                this.setMaximumValue(d);
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 308);
                double d3 = doubleArray[0];
                double d4 = doubleArray[1];
                if (!(d2 <= d)) break;
                this.setMinorTickSpacing(d3);
                this.setMajorTickSpacing(d4);
                break;
            }
            case 300: {
                Double d = (Double)object;
                Double d5 = (Double)graphicController.getProperty(this.uid, 299);
                this.setMinimumValue(d);
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 308);
                double d6 = doubleArray[0];
                double d7 = doubleArray[1];
                if (!(d <= d5)) break;
                this.setMinorTickSpacing(d6);
                this.setMajorTickSpacing(d7);
                break;
            }
            case 80: {
                Double[] doubleArray = SwingViewWidget.updatePosition(this, this.uid, object);
                if (doubleArray[2].intValue() > doubleArray[3].intValue()) {
                    this.setHorizontal();
                    break;
                }
                this.setVertical();
                break;
            }
            case 308: {
                Double[] doubleArray = (Double[])object;
                double d = doubleArray[0];
                double d8 = doubleArray[1];
                this.setMinorTickSpacing(d);
                this.setMajorTickSpacing(d8);
                break;
            }
            case 310: {
                Double[] doubleArray = (Double[])object;
                this.setUserValue(doubleArray[0]);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    private void updateModel() {
        Double[] doubleArray = new Double[1];
        double d = (Double)GraphicController.getController().getProperty(this.uid, 300);
        double d2 = (Double)GraphicController.getController().getProperty(this.uid, 299);
        doubleArray[0] = d + (double)(this.getValue() - 0) * (d2 - d) / 10000.0;
        GraphicController.getController().setProperty(this.uid, 310, (Object)doubleArray);
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollBar.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollBar.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

