/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.pushbutton;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabPushButton
extends JButton
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = 2277539556048935959L;
    private Integer uid;
    private CommonCallBack callback;
    private String text = "";
    private boolean isLaTeX;
    private int fontSize;
    private Border defaultBorder = null;

    public SwingScilabPushButton() {
        if (Console.getConsole().getUseDeprecatedLF()) {
            this.setContentAreaFilled(false);
            this.setOpaque(true);
            this.addPropertyChangeListener("icon", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Icon icon = (Icon)propertyChangeEvent.getNewValue();
                    boolean bl = icon != null;
                    SwingScilabPushButton.this.setContentAreaFilled(bl);
                    SwingScilabPushButton.this.setOpaque(!bl);
                }
            });
        }
    }

    public String getBaseText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            this.text = null;
            this.isLaTeX = false;
            super.setIcon(null);
            super.setText(null);
        } else {
            this.text = string;
            this.isLaTeX = ScilabSpecialTextUtilities.setText((JComponent)this, (String)string);
            if (this.isLaTeX) {
                super.setText("");
            } else {
                super.setText(string);
            }
        }
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font.getSize() != this.fontSize && this.isLaTeX) {
            ScilabSpecialTextUtilities.setText((JComponent)this, (String)this.text);
            this.fontSize = font.getSize();
        }
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(super.getSize().width, super.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    public void setIcon(String string) {
        super.setIcon(new ImageIcon(string));
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        if (this.callback != null) {
            this.removeActionListener(this.callback);
        }
        this.callback = commonCallBack;
        this.addActionListener(this.callback);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.setHorizontalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.setVerticalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        switch (n) {
            case 322: {
                Object object2;
                String string = (String)object;
                if (string == null || string.equals("")) {
                    super.setIcon(null);
                    break;
                }
                File file = new File((String)object);
                if (!file.exists()) {
                    object2 = FindIconHelper.findImage((String)((String)object));
                    file = new File((String)object2);
                }
                try {
                    object2 = ImageIO.read(file);
                    this.setIcon(new ImageIcon((Image)object2));
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        super.setBackground(color);
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Button.background");
        if (color != null) {
            this.setContentAreaFilled(true);
            this.setOpaque(false);
            super.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Button.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

