/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.popupmenu;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ColorBox;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.SwingScilabListItem;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabPopupMenu
extends JComboBox
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -4366581303317502544L;
    private Integer uid;
    private CommonCallBack callback;
    private ActionListener defaultActionListener;
    private Border defaultBorder = null;
    private ListCellRenderer defaultRenderer = this.getRenderer();
    private ListCellRenderer listRenderer = new ListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)SwingScilabPopupMenu.this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof SwingScilabListItem) {
                SwingScilabListItem swingScilabListItem = (SwingScilabListItem)object;
                jLabel.setText(swingScilabListItem.toString());
                jLabel.setIcon(swingScilabListItem.getIcon());
                if (n != -1 && !bl && swingScilabListItem.getBackground() != null) {
                    jLabel.setBackground(swingScilabListItem.getBackground());
                }
                if (n != -1 && !bl && swingScilabListItem.getForeground() != null) {
                    jLabel.setForeground(swingScilabListItem.getForeground());
                }
            } else {
                jLabel.setText("");
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    };

    public SwingScilabPopupMenu() {
        this.setRenderer(this.listRenderer);
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.defaultActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Double d = SwingScilabPopupMenu.this.getUserSelectedIndex();
                if (d == -1.0) {
                    GraphicController.getController().setProperty(SwingScilabPopupMenu.this.uid, 310, (Object)new Double[0]);
                } else {
                    GraphicController.getController().setProperty(SwingScilabPopupMenu.this.uid, 310, (Object)new Double[]{d});
                }
                if (SwingScilabPopupMenu.this.callback != null) {
                    SwingScilabPopupMenu.this.callback.actionPerformed(null);
                }
            }
        };
        this.addActionListener(this.defaultActionListener);
    }

    @Override
    public void draw() {
        this.setVisible(true);
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
        this.doLayout();
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    public void setUserSelectedIndex(int n) {
        this.removeActionListener(this.defaultActionListener);
        if (n >= 0 && n <= this.getItemCount()) {
            this.setSelectedIndex(n - 1);
        }
        this.addActionListener(this.defaultActionListener);
    }

    public int getUserSelectedIndex() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return -1;
        }
        return n + 1;
    }

    public String[] getAllItemsText() {
        String[] stringArray = new String[this.getItemCount()];
        for (int i = 0; i < this.getItemCount(); ++i) {
            stringArray[i] = this.getItemAt(i).toString();
        }
        return stringArray;
    }

    public int getNumberOfItems() {
        return this.getItemCount();
    }

    public void setText(String[] stringArray) {
        DefaultComboBoxModel<SwingScilabListItem> defaultComboBoxModel = new DefaultComboBoxModel<SwingScilabListItem>();
        GraphicController graphicController = GraphicController.getController();
        Integer n = (Integer)graphicController.getProperty(this.getId(), 305);
        this.removeActionListener(this.defaultActionListener);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = stringArray.length / n;
        for (int i = 0; i < n2; ++i) {
            Icon icon = null;
            String string = null;
            Color color = null;
            Color color2 = null;
            if (bl) {
                try {
                    if (!stringArray[i].startsWith("#")) {
                        throw new NumberFormatException();
                    }
                    Color color3 = Color.decode(stringArray[i]);
                    icon = ColorBox.createColorBox(16, 16, color3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    defaultComboBoxModel.removeAllElements();
                    i = -1;
                    continue;
                }
            }
            if (bl3) {
                try {
                    icon = FindIconHelper.loadIcon((String)stringArray[i]);
                }
                catch (IOException iOException) {
                    bl3 = false;
                    defaultComboBoxModel.removeAllElements();
                    i = -1;
                    continue;
                }
            }
            if (bl2) {
                try {
                    int n3 = 0;
                    if (bl || bl3) {
                        n3 = 1;
                    }
                    string = stringArray[n2 * n3 + i];
                    if (n > 1 + n3) {
                        if (!stringArray[n2 * (1 + n3) + i].startsWith("#")) {
                            throw new NumberFormatException();
                        }
                        color = Color.decode(stringArray[n2 * (1 + n3) + i]);
                        if (n > 2 + n3) {
                            if (!stringArray[n2 * (2 + n3) + i].startsWith("#")) {
                                throw new NumberFormatException();
                            }
                            color2 = Color.decode(stringArray[n2 * (2 + n3) + i]);
                        }
                    }
                    defaultComboBoxModel.addElement(new SwingScilabListItem(string, icon, color, color2));
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                    defaultComboBoxModel.removeAllElements();
                    i = -1;
                }
                continue;
            }
            for (int j = 0; j < n; ++j) {
                defaultComboBoxModel.addElement(new SwingScilabListItem(stringArray[n2 * j + i], icon, color, color2));
            }
        }
        this.setSelectedIndex(-1);
        this.setModel(defaultComboBoxModel);
        this.invalidate();
        this.addActionListener(this.defaultActionListener);
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        switch (n) {
            case 302: {
                this.setText((String[])object);
                break;
            }
            case 299: {
                Integer n2 = ((Double)object).intValue();
                if (n2 <= 1) break;
                char[] cArray = new char[n2.intValue()];
                Arrays.fill(cArray, '*');
                String string = new String(cArray);
                this.setPrototypeDisplayValue(string);
                break;
            }
            case 310: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length == 0 || doubleArray[0] == 0.0) {
                    this.setUserSelectedIndex(0);
                    return;
                }
                int[] nArray = new int[doubleArray.length];
                for (int i = 0; i < doubleArray.length; ++i) {
                    nArray[i] = doubleArray[i].intValue();
                }
                this.setUserSelectedIndex(nArray[0]);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ComboBox.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ComboBox.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    @Override
    public void setEmptyText() {
        this.setText(new String[0]);
    }
}

