/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.listbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ColorBox;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.SwingScilabListItem;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabListBox
extends JScrollPane
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = 3507396207331058895L;
    private static final int COLORS_COEFF = 255;
    private Integer uid;
    private Border defaultBorder = null;
    private CommonCallBack callback;
    private ListSelectionListener listListener;
    private AdjustmentListener adjustmentListener;
    private JList list;
    private ListCellRenderer defaultRenderer = null;
    private ListCellRenderer listRenderer = null;

    public SwingScilabListBox() {
        this.getViewport().add(this.getList());
        this.defaultRenderer = this.getList().getCellRenderer();
        this.listRenderer = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)SwingScilabListBox.this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof SwingScilabListItem) {
                    SwingScilabListItem swingScilabListItem = (SwingScilabListItem)object;
                    jLabel.setText(swingScilabListItem.toString());
                    jLabel.setIcon(swingScilabListItem.getIcon());
                    if (!bl && swingScilabListItem.getBackground() != null) {
                        jLabel.setBackground(swingScilabListItem.getBackground());
                    }
                    if (!bl && swingScilabListItem.getForeground() != null) {
                        jLabel.setForeground(swingScilabListItem.getForeground());
                    }
                } else {
                    jLabel.setText("");
                    jLabel.setIcon(null);
                }
                return jLabel;
            }
        };
        this.getList().setCellRenderer(this.listRenderer);
        this.listListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = (int[])SwingScilabListBox.this.getList().getSelectedIndices().clone();
                Double[] doubleArray = new Double[nArray.length];
                for (int i = 0; i < SwingScilabListBox.this.getList().getSelectedIndices().length; ++i) {
                    doubleArray[i] = (double)nArray[i] + 1.0;
                }
                GraphicController.getController().setProperty(SwingScilabListBox.this.uid, 310, (Object)doubleArray);
                if (SwingScilabListBox.this.callback != null) {
                    SwingScilabListBox.this.callback.actionPerformed(null);
                }
            }
        };
        this.getList().addListSelectionListener(this.listListener);
        this.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                int n = SwingScilabListBox.this.getList().getUI().locationToIndex(SwingScilabListBox.this.getList(), SwingScilabListBox.this.getViewport().getViewPosition()) + 1;
                GraphicController.getController().setProperty(SwingScilabListBox.this.uid, 297, (Object)new Integer[]{n});
            }
        };
        this.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
    }

    @Override
    public Color getBackground() {
        return this.getList().getBackground();
    }

    @Override
    public Font getFont() {
        return this.getList().getFont();
    }

    @Override
    public Color getForeground() {
        return this.getList().getForeground();
    }

    public void setListBackground(Color color) {
        this.getList().setBackground(color);
    }

    @Override
    public void setFont(Font font) {
        this.getList().setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        this.getList().setForeground(color);
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.list.setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        this.getList().setEnabled(bl);
        if (bl) {
            if (this.listListener != null) {
                this.getList().addListSelectionListener(this.listListener);
            }
        } else if (this.listListener != null) {
            this.getList().removeListSelectionListener(this.listListener);
        }
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        throw new UnsupportedOperationException();
    }

    public String[] getAllItemsText() {
        String[] stringArray = new String[this.getList().getModel().getSize()];
        for (int i = 0; i < this.getList().getModel().getSize(); ++i) {
            stringArray[i] = this.getList().getModel().getElementAt(i).toString();
        }
        return stringArray;
    }

    public int getNumberOfItems() {
        return this.getList().getModel().getSize();
    }

    @Override
    public void setText(String string) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(string);
        this.getList().setModel(defaultListModel);
        this.revalidate();
    }

    public void setText(String[] stringArray) {
        DefaultListModel<SwingScilabListItem> defaultListModel = new DefaultListModel<SwingScilabListItem>();
        GraphicController graphicController = GraphicController.getController();
        Integer n = (Integer)graphicController.getProperty(this.getId(), 305);
        this.getList().removeListSelectionListener(this.listListener);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = stringArray.length / n;
        for (int i = 0; i < n2; ++i) {
            Icon icon = null;
            String string = null;
            Color color = null;
            Color color2 = null;
            if (bl) {
                try {
                    if (!stringArray[i].startsWith("#")) {
                        throw new NumberFormatException();
                    }
                    Color color3 = Color.decode(stringArray[i]);
                    icon = ColorBox.createColorBox(16, 16, color3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    defaultListModel.clear();
                    i = -1;
                    continue;
                }
            }
            if (bl3) {
                try {
                    icon = FindIconHelper.loadIcon((String)stringArray[i]);
                }
                catch (IOException iOException) {
                    bl3 = false;
                    defaultListModel.clear();
                    i = -1;
                    continue;
                }
            }
            if (bl2) {
                try {
                    int n3 = 0;
                    if (bl || bl3) {
                        n3 = 1;
                    }
                    string = stringArray[n2 * n3 + i];
                    if (n > 1 + n3) {
                        if (!stringArray[n2 * (1 + n3) + i].startsWith("#")) {
                            throw new NumberFormatException();
                        }
                        color = Color.decode(stringArray[n2 * (1 + n3) + i]);
                        if (n > 2 + n3) {
                            if (!stringArray[n2 * (2 + n3) + i].startsWith("#")) {
                                throw new NumberFormatException();
                            }
                            color2 = Color.decode(stringArray[n2 * (2 + n3) + i]);
                        }
                    }
                    defaultListModel.addElement(new SwingScilabListItem(string, icon, color, color2));
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                    defaultListModel.clear();
                    i = -1;
                }
                continue;
            }
            for (int j = 0; j < n; ++j) {
                defaultListModel.addElement(new SwingScilabListItem(stringArray[n2 * j + i], icon, color, color2));
            }
        }
        this.getList().setSelectedIndex(-1);
        this.getList().setModel(defaultListModel);
        this.invalidate();
        this.getList().addListSelectionListener(this.listListener);
    }

    @Override
    public void setEmptyText() {
        this.setText(new String[0]);
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    public void setMultipleSelectionEnabled(boolean bl) {
        if (bl) {
            this.getList().setSelectionMode(2);
        } else {
            this.getList().setSelectionMode(0);
        }
    }

    public void setSelectedIndices(int[] nArray) {
        int[] nArray2 = (int[])nArray.clone();
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray2[i] - 1;
        }
        if (this.listListener != null) {
            this.getList().removeListSelectionListener(this.listListener);
        }
        this.getList().setSelectedIndices(nArray2);
        if (this.listListener != null) {
            this.getList().addListSelectionListener(this.listListener);
        }
    }

    public int[] getSelectedIndices() {
        int[] nArray = (int[])this.getList().getSelectedIndices().clone();
        int[] nArray2 = (int[])nArray.clone();
        for (int i = 0; i < this.getList().getSelectedIndices().length; ++i) {
            nArray2[i] = nArray2[i] + 1;
        }
        return nArray2;
    }

    public int getSelectionSize() {
        return this.getList().getSelectedIndices().length;
    }

    private JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setLayoutOrientation(0);
            this.list.setModel(new DefaultListModel());
        }
        return this.list;
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    public void setListBoxTop(int n) {
        this.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
        if (n > 0 & n != this.getListBoxTop() && this.getList().getModel().getSize() != 0) {
            this.getViewport().setViewPosition(this.getList().getUI().indexToLocation(this.getList(), n - 1));
            this.doLayout();
        }
        this.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
    }

    public int getListBoxTop() {
        return this.getList().getUI().locationToIndex(this.getList(), this.getViewport().getViewPosition()) + 1;
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 310: {
                Double[] doubleArray = (Double[])object;
                int[] nArray = new int[doubleArray.length];
                for (int i = 0; i < doubleArray.length; ++i) {
                    nArray[i] = doubleArray[i].intValue();
                }
                this.setSelectedIndices(nArray);
                break;
            }
            case 288: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray[0] != -1.0) {
                    this.setListBackground(new Color((int)(doubleArray[0] * 255.0), (int)(doubleArray[1] * 255.0), (int)(doubleArray[2] * 255.0)));
                    break;
                }
                this.resetBackground();
                break;
            }
            case 302: {
                this.setText((String[])object);
                break;
            }
            case 299: {
                Double d = (Double)object;
                double d2 = (Double)graphicController.getProperty(this.uid, 300);
                this.setMultipleSelectionEnabled(d - d2 > 1.0);
                break;
            }
            case 300: {
                Double d = (Double)object;
                Double d3 = (Double)graphicController.getProperty(this.uid, 299);
                this.setMultipleSelectionEnabled(d3 - d > 1.0);
                break;
            }
            case 297: {
                Integer[] integerArray = (Integer[])object;
                if (integerArray.length <= 0) break;
                this.setListBoxTop(integerArray[0]);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("List.background");
        if (color != null) {
            this.getList().setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("List.foreground");
        if (color != null) {
            this.getList().setForeground(color);
        }
    }
}

