/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.helpbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.DefaultHelpHistoryModel;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.JHelpIndexNavigator;
import javax.help.JHelpNavigator;
import javax.help.JHelpSearchNavigator;
import javax.help.JHelpTOCNavigator;
import javax.help.SwingHelpUtilities;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.basic.BasicSearchNavigatorUI;
import javax.help.plaf.basic.BasicTOCNavigatorUI;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowserViewer;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.helpbrowser.SimpleHelpBrowser;
import org.scilab.modules.gui.messagebox.MessageBox;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.gui.utils.HelpSearchField;
import org.scilab.modules.localization.Messages;

public class SwingScilabHelpBrowser
extends JPanel
implements SimpleHelpBrowser,
HelpModelListener {
    private static final long serialVersionUID = 5306766011092074961L;
    private static String defaultLanguage = "en_US";
    private static String jarExtension = "_help.jar";
    private static String mainJarPath = System.getenv("SCI") + "/modules/helptools/jar/scilab_";
    private String currentLanguage = "";
    private JHelp jhelp = new JHelp();
    private HelpSet helpSet;
    private URL homePageURL;
    private HelpSearchField searchField;
    private static DefaultHelpHistoryModel helpHistory;

    public static DefaultHelpHistoryModel getHelpHistory() {
        return helpHistory;
    }

    public SwingScilabHelpBrowser(String[] stringArray, String string) {
        super(new BorderLayout());
        Object object;
        Comparable<File> comparable;
        int n;
        this.add((Component)this.jhelp);
        this.setFocusable(true);
        this.searchField = new HelpSearchField(this, null);
        if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null) {
            ScilabConsole.getConsole().getInfoBar().setText(Messages.gettext((String)"Loading help browser..."));
            ScilabConsole.getConsole().setCursor(Cursor.getPredefinedCursor(3));
        }
        File[] fileArray = stringArray != null ? new File[stringArray.length + 1] : new File[1];
        File file = new File(mainJarPath + string + jarExtension);
        this.currentLanguage = string;
        if (!file.exists()) {
            file = new File(mainJarPath + defaultLanguage + jarExtension);
            this.currentLanguage = defaultLanguage;
        }
        if (!file.exists()) {
            String string2 = "'SCI/modules/helptools/jar/scilab_" + defaultLanguage + jarExtension + "' has not been found on the system.\n" + "" + "Are you sure you built it?\nThe help will not be available.";
            if (ScilabConsole.isExistingConsole()) {
                MessageBox messageBox = ScilabMessageBox.createMessageBox();
                messageBox.setMessage(string2);
                messageBox.setModal(true);
                messageBox.setIcon("error");
                messageBox.displayAndWait();
            } else {
                System.out.println(string2);
            }
            return;
        }
        int n2 = 0;
        fileArray[n2++] = file;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                comparable = new File(stringArray[n]);
                object = comparable.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.endsWith(jarExtension);
                    }
                });
                if (object == null || ((String[])object).length == 0) {
                    comparable = new File(stringArray[n] + "/../../jar");
                    object = comparable.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(jarExtension);
                        }
                    });
                }
                int n3 = -1;
                int n4 = -1;
                if (object == null) continue;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (((String)object[i]).indexOf(defaultLanguage) != -1) {
                        n3 = i;
                    }
                    if (((String)object[i]).indexOf(string) == -1) continue;
                    n4 = i;
                }
                if (n4 != -1) {
                    fileArray[n2++] = new File(comparable + File.separator + (String)object[n4]);
                    continue;
                }
                if (n3 != -1) {
                    fileArray[n2++] = new File(comparable + File.separator + (String)object[n3]);
                    continue;
                }
                if (object == null || ((Object)object).length == 0) continue;
                fileArray[n2++] = new File(comparable + File.separator + (String)object[0]);
            }
        }
        this.jhelp.setModel((TextHelpModel)new DefaultHelpModel(new HelpSet()));
        for (n = 0; n < n2; ++n) {
            comparable = fileArray[n].toURI();
            object = new StringBuilder("jar:");
            ((StringBuilder)object).append(comparable);
            ((StringBuilder)object).append("!/");
            ((StringBuilder)object).append(SwingScilabHelpBrowser.rootName((URI)comparable));
            ((StringBuilder)object).append("/jhelpset.hs");
            URL uRL = null;
            try {
                uRL = new URL(((StringBuilder)object).toString());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                continue;
            }
            try {
                this.helpSet = new HelpSet(null, uRL);
            }
            catch (HelpSetException helpSetException) {
                System.err.println("Could not load file: " + fileArray[n] + ". Please check its contents, must be a Java Help file.");
                System.err.println("Error message: " + helpSetException.getLocalizedMessage());
                if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null) {
                    ScilabConsole.getConsole().getInfoBar().setText("");
                    ScilabConsole.getConsole().setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            this.jhelp.getModel().getHelpSet().add(this.helpSet);
        }
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            comparable = enumeration.nextElement();
            if (!(comparable instanceof JHelpIndexNavigator)) continue;
            this.jhelp.removeHelpNavigator((JHelpNavigator)((JHelpIndexNavigator)comparable));
            break;
        }
        enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            Field field;
            comparable = enumeration.nextElement();
            if (!(comparable instanceof JHelpTOCNavigator)) continue;
            object = (BasicTOCNavigatorUI)((JHelpTOCNavigator)comparable).getUI();
            JScrollPane jScrollPane = null;
            try {
                field = BasicTOCNavigatorUI.class.getDeclaredField("sp");
                field.setAccessible(true);
                jScrollPane = (JScrollPane)field.get(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jScrollPane == null) break;
            field = jScrollPane;
            ((Component)((Object)field)).addComponentListener(new ComponentAdapter((JScrollPane)((Object)field)){
                final /* synthetic */ JScrollPane val$sp;
                {
                    this.val$sp = jScrollPane;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.val$sp.getHorizontalScrollBar().setValue(0);
                    this.val$sp.getVerticalScrollBar().setValue(0);
                    this.val$sp.removeComponentListener(this);
                }
            });
            break;
        }
        if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null) {
            ScilabConsole.getConsole().getInfoBar().setText("");
            ScilabConsole.getConsole().setCursor(Cursor.getPredefinedCursor(0));
        }
        helpHistory = (DefaultHelpHistoryModel)this.jhelp.getHistoryModel();
        try {
            this.homePageURL = new URL(this.jhelp.getModel().getHelpSet().getHelpSetURL().toString().replace("jhelpset.hs", "ScilabHomePage.html"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.jhelp.getContentViewer().addHelpModelListener((HelpModelListener)this);
        this.setVisible(true);
    }

    public static boolean isMainJarExists(String string) {
        File file = new File(mainJarPath + string + jarExtension);
        return file.exists() || (file = new File(mainJarPath + defaultLanguage + jarExtension)).exists();
    }

    public String getCurrentURL() {
        return ((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).getCurrentURL();
    }

    public String getCurrentID() {
        if (this.jhelp.getModel().getCurrentID() != null) {
            String string = this.jhelp.getModel().getCurrentID().toString();
            int n = string.indexOf(" ");
            int n2 = string.indexOf(",");
            if (n != -1 && n2 != -1) {
                string = string.substring(n + 1, n2);
            }
            return string;
        }
        return null;
    }

    public void setCurrentID(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingScilabHelpBrowser.this.jhelp.setCurrentID(string);
                }
                catch (BadIDException badIDException) {
                    SwingScilabHelpBrowser.this.jhelp.setCurrentURL(SwingScilabHelpBrowser.this.homePageURL);
                }
            }
        });
    }

    public void showSearchField() {
        this.searchField.setTextComponent(((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).getAccessibleHTML());
        this.searchField.showField();
    }

    public void hideSearchField() {
        this.searchField.hideField();
    }

    public void increaseFont() {
        ((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).increaseFont();
    }

    public void decreaseFont() {
        ((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).decreaseFont();
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        this.searchField.setTextComponent(((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).getAccessibleHTML());
    }

    public void displayHomePage() {
        if (this.homePageURL != null) {
            this.setCurrentURL(this.homePageURL);
        }
    }

    public void setCurrentURL(final URL uRL) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingScilabHelpBrowser.this.jhelp.setCurrentURL(uRL);
            }
        });
    }

    public void setCurrentURL(String string) {
        URL uRL = this.homePageURL;
        try {
            if (string != null) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.setCurrentURL(uRL);
    }

    @Override
    public void display() {
    }

    @Override
    public void searchKeywork(String string) {
        Enumeration enumeration;
        if (string == null) {
            this.displayHomePage();
            return;
        }
        if (string.length() > 0 && string.charAt(0) == '%') {
            string = string.replace("%", "percent");
        }
        if (!(enumeration = this.jhelp.getHelpNavigators()).hasMoreElements()) {
            System.out.println("Scilab help files not loaded. Please check if " + mainJarPath + "*" + jarExtension + " files exist and are Java Help files.");
            return;
        }
        this.jhelp.setCurrentNavigator((JHelpNavigator)((JHelpTOCNavigator)enumeration.nextElement()));
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingScilabHelpBrowser.this.jhelp.setCurrentID(string2);
                }
                catch (BadIDException badIDException) {
                    SwingScilabHelpBrowser.this.fullTextSearch(string2);
                }
            }
        });
    }

    @Override
    public void fullTextSearch(String string) {
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof JHelpSearchNavigator)) continue;
            JHelpSearchNavigator jHelpSearchNavigator = (JHelpSearchNavigator)e;
            this.jhelp.setCurrentNavigator((JHelpNavigator)jHelpSearchNavigator);
            SearchQuery searchQuery = jHelpSearchNavigator.getSearchEngine().createQuery();
            searchQuery.addSearchListener((SearchListener)((BasicSearchNavigatorUI)jHelpSearchNavigator.getUI()));
            searchQuery.start(string, new Locale(this.currentLanguage));
            break;
        }
    }

    @Override
    public void close() {
    }

    private static String rootName(URI uRI) {
        String string = uRI.toString();
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? string : string.substring(n + 1);
        n = string2.lastIndexOf(46);
        String string3 = n < 0 ? string2 : string2.substring(0, n);
        return string3;
    }

    static {
        SwingHelpUtilities.setContentViewerUI((String)"org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowserViewer");
    }
}

