/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.uicontrol.Uicontrol;
import org.scilab.modules.graphic_objects.utils.LayoutType;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.bridge.canvas.SwingScilabCanvas;
import org.scilab.modules.gui.bridge.console.SwingScilabConsole;
import org.scilab.modules.gui.bridge.frame.SwingScilabLayer;
import org.scilab.modules.gui.bridge.tab.SwingScilabAxes;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabTabGroup;
import org.scilab.modules.gui.bridge.textbox.SwingScilabTextBox;
import org.scilab.modules.gui.canvas.Canvas;
import org.scilab.modules.gui.console.Console;
import org.scilab.modules.gui.dockable.Dockable;
import org.scilab.modules.gui.events.ScilabEventListener;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.tab.Tab;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.BorderConvertor;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.UnitsConverter;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabFrame
extends JPanel
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -7401084975837285447L;
    private Integer uid = -1;
    int redraw = 0;
    protected boolean hasLayout = false;
    private Border defaultBorder = null;
    private SwingScilabCanvas canvas = null;
    private ScilabEventListener eventHandler;
    private boolean eventEnabled = false;

    public SwingScilabFrame() {
        super.setLayout(null);
        this.hasLayout = false;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (SwingScilabFrame.this.getId() != -1 && SwingScilabFrame.this.getParent() != null) {
                    Serializable[] serializableArray = new Double[4];
                    Double[] doubleArray = (Double[])GraphicController.getController().getProperty(SwingScilabFrame.this.getId(), 80);
                    if (doubleArray == null) {
                        return;
                    }
                    UnitsConverter.UicontrolUnits uicontrolUnits = UnitsConverter.stringToUnitsEnum((String)GraphicController.getController().getProperty(SwingScilabFrame.this.uid, 309));
                    if (uicontrolUnits != UnitsConverter.UicontrolUnits.NORMALIZED) {
                        serializableArray[0] = Double.valueOf(UnitsConverter.convertFromPixel(SwingScilabFrame.this.getPosition().getX(), uicontrolUnits, (SwingScilabFrame)SwingView.getFromId(SwingScilabFrame.this.uid), true));
                        serializableArray[1] = Double.valueOf(UnitsConverter.convertFromPixel(SwingScilabFrame.this.getPosition().getY(), uicontrolUnits, (SwingScilabFrame)SwingView.getFromId(SwingScilabFrame.this.uid), true));
                        serializableArray[2] = Double.valueOf(UnitsConverter.convertFromPixel(SwingScilabFrame.this.getWidth(), uicontrolUnits, (SwingScilabFrame)SwingView.getFromId(SwingScilabFrame.this.uid), true));
                        serializableArray[3] = Double.valueOf(UnitsConverter.convertFromPixel(SwingScilabFrame.this.getHeight(), uicontrolUnits, (SwingScilabFrame)SwingView.getFromId(SwingScilabFrame.this.uid), true));
                        doubleArray[2] = serializableArray[2];
                        doubleArray[3] = serializableArray[3];
                        if (SwingScilabFrame.this.getParent() != null && SwingScilabFrame.this.getParent().getLayout() == null) {
                            GraphicController.getController().setProperty(SwingScilabFrame.this.getId(), 80, (Object)serializableArray);
                        } else {
                            GraphicController.getController().setProperty(SwingScilabFrame.this.getId(), 80, (Object)doubleArray);
                        }
                    }
                }
                if (!SwingScilabFrame.this.hasLayout) {
                    for (Serializable serializable : SwingScilabFrame.this.getComponents()) {
                        if (!(serializable instanceof Widget)) continue;
                        SwingViewObject swingViewObject = (SwingViewObject)((Object)serializable);
                        swingViewObject.update(80, GraphicController.getController().getProperty(swingViewObject.getId(), 80));
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    public void addMember(SwingViewObject swingViewObject) {
        if (!this.isEnabled()) {
            ((Component)((Object)swingViewObject)).setEnabled(false);
        }
        if (swingViewObject instanceof SwingScilabAxes) {
            if (this.canvas == null) {
                AxesContainer axesContainer = (AxesContainer)GraphicModel.getModel().getObjectFromId(this.getId());
                this.canvas = new SwingScilabCanvas(axesContainer);
                this.setLayout(new GridLayout(1, 1));
                this.hasLayout = true;
                this.add(this.canvas);
            }
            return;
        }
        Uicontrol uicontrol = (Uicontrol)GraphicModel.getModel().getObjectFromId(swingViewObject.getId());
        if (this.getLayout() instanceof BorderLayout) {
            switch (uicontrol.getBorderPositionAsEnum()) {
                case BOTTOM: {
                    this.add((Component)((Object)swingViewObject), "South");
                    break;
                }
                case TOP: {
                    this.add((Component)((Object)swingViewObject), "North");
                    break;
                }
                case LEFT: {
                    this.add((Component)((Object)swingViewObject), "West");
                    break;
                }
                case RIGHT: {
                    this.add((Component)((Object)swingViewObject), "East");
                    break;
                }
                case CENTER: {
                    this.add((Component)((Object)swingViewObject), "Center");
                    break;
                }
            }
            Integer[] integerArray = uicontrol.getBorderPreferredSize();
            if (!integerArray[0].equals(-1) && !integerArray[1].equals(-1)) {
                ((Component)((Object)swingViewObject)).setPreferredSize(new Dimension(integerArray[0], integerArray[1]));
            }
        } else if (this.getLayout() instanceof GridBagLayout) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Integer[] integerArray = uicontrol.getGridBagGrid();
            gridBagConstraints.gridx = integerArray[0];
            gridBagConstraints.gridy = integerArray[1];
            gridBagConstraints.gridwidth = integerArray[2];
            gridBagConstraints.gridheight = integerArray[3];
            Double[] doubleArray = uicontrol.getGridBagWeight();
            gridBagConstraints.weightx = doubleArray[0];
            gridBagConstraints.weighty = doubleArray[1];
            switch (uicontrol.getGridBagAnchorAsEnum()) {
                case LEFT: {
                    gridBagConstraints.anchor = 17;
                    break;
                }
                case UPPER: {
                    gridBagConstraints.anchor = 11;
                    break;
                }
                case LOWER: {
                    gridBagConstraints.anchor = 15;
                    break;
                }
                case LOWER_LEFT: {
                    gridBagConstraints.anchor = 16;
                    break;
                }
                case LOWER_RIGHT: {
                    gridBagConstraints.anchor = 14;
                    break;
                }
                case RIGHT: {
                    gridBagConstraints.anchor = 13;
                    break;
                }
                case UPPER_LEFT: {
                    gridBagConstraints.anchor = 18;
                    break;
                }
                case UPPER_RIGHT: {
                    gridBagConstraints.anchor = 12;
                    break;
                }
                default: {
                    gridBagConstraints.anchor = 10;
                }
            }
            switch (uicontrol.getGridBagFillAsEnum()) {
                case BOTH: {
                    gridBagConstraints.fill = 1;
                    break;
                }
                case HORIZONTAL: {
                    gridBagConstraints.fill = 2;
                    break;
                }
                case VERTICAL: {
                    gridBagConstraints.fill = 3;
                    break;
                }
                default: {
                    gridBagConstraints.fill = 0;
                }
            }
            Double[] doubleArray2 = uicontrol.getMargins();
            gridBagConstraints.insets = new Insets(doubleArray2[0].intValue(), doubleArray2[1].intValue(), doubleArray2[2].intValue(), doubleArray2[3].intValue());
            Integer[] integerArray2 = uicontrol.getGridBagPadding();
            gridBagConstraints.ipadx = integerArray2[0];
            gridBagConstraints.ipady = integerArray2[1];
            Integer[] integerArray3 = uicontrol.getGridBagPreferredSize();
            if (!integerArray3[0].equals(-1) && !integerArray3[1].equals(-1)) {
                ((Component)((Object)swingViewObject)).setPreferredSize(new Dimension(integerArray3[0], integerArray3[1]));
            }
            this.add((Component)((Object)swingViewObject), gridBagConstraints);
            this.revalidate();
        } else if (this.getLayout() instanceof GridLayout) {
            this.add((Component)((Object)swingViewObject), 0);
        } else {
            this.add((Component)((Object)swingViewObject));
        }
        swingViewObject.update(80, GraphicController.getController().getProperty(swingViewObject.getId(), 80));
    }

    public int addMember(Console console) {
        return this.addMember((SwingScilabConsole)console.getAsSimpleConsole());
    }

    private int addMember(SwingScilabConsole swingScilabConsole) {
        this.add((Component)((Object)swingScilabConsole));
        return this.getComponentZOrder((Component)((Object)swingScilabConsole));
    }

    public int addMember(Canvas canvas) {
        return this.addMember((SwingScilabCanvas)canvas.getAsSimpleCanvas());
    }

    private int addMember(SwingScilabCanvas swingScilabCanvas) {
        return 0;
    }

    public int addMember(Tab tab) {
        return this.addMember((SwingScilabDockablePanel)tab.getAsSimpleTab());
    }

    private int addMember(SwingScilabDockablePanel swingScilabDockablePanel) {
        this.add((Component)((Object)swingScilabDockablePanel));
        return this.getComponentZOrder((Component)((Object)swingScilabDockablePanel));
    }

    public int addMember(TextBox textBox) {
        return this.addMember((SwingScilabTextBox)textBox.getAsSimpleTextBox());
    }

    private int addMember(SwingScilabTextBox swingScilabTextBox) {
        this.add(swingScilabTextBox);
        return this.getComponentZOrder(swingScilabTextBox);
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public void setText(String string) {
        this.setName(string);
    }

    @Override
    public void setEmptyText() {
        this.setText("");
    }

    public int addMember(Dockable dockable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        this.setVisible(false);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 310: {
                if (!(this instanceof SwingScilabLayer)) break;
                SwingScilabLayer swingScilabLayer = (SwingScilabLayer)this;
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length == 0) {
                    return;
                }
                Integer n2 = doubleArray[0].intValue();
                swingScilabLayer.setActiveLayer(n2);
                break;
            }
            case 302: {
                JComponent jComponent;
                int n3;
                Container container = this.getParent();
                if (container instanceof SwingScilabTabGroup && (n3 = ((JTabbedPane)(jComponent = (SwingScilabTabGroup)container)).indexOfComponent(this)) != -1) {
                    ((SwingScilabTabGroup)jComponent).setTitleAt(n3, ((String[])object)[0]);
                }
                if (!(this instanceof SwingScilabLayer)) break;
                jComponent = (SwingScilabLayer)this;
                ((SwingScilabLayer)jComponent).setActiveLayerFromName(((String[])object)[0]);
                break;
            }
            case 322: {
                SwingScilabTabGroup swingScilabTabGroup;
                int n4;
                Container container = this.getParent();
                if (!(container instanceof SwingScilabTabGroup) || (n4 = (swingScilabTabGroup = (SwingScilabTabGroup)container).indexOfComponent(this)) == -1) break;
                swingScilabTabGroup.setIconAt(n4, (String)object);
                break;
            }
            case 80: {
                SwingViewWidget.updatePosition(this, this.uid, object);
                this.validate();
                this.doLayout();
                break;
            }
            case 379: {
                Integer n5 = (Integer)object;
                Border border = BorderConvertor.getBorder(n5);
                this.setBorder(border);
                break;
            }
            case 363: {
                this.hasLayout = false;
                this.invalidate();
                LayoutType layoutType = LayoutType.intToEnum((Integer)((Integer)object));
                switch (layoutType) {
                    case BORDER: {
                        Integer[] integerArray = (Integer[])graphicController.getProperty(this.getId(), 378);
                        this.setLayout(new BorderLayout(integerArray[0], integerArray[1]));
                        this.hasLayout = true;
                        break;
                    }
                    case GRIDBAG: {
                        this.setLayout(new GridBagLayout());
                        this.hasLayout = true;
                        break;
                    }
                    case GRID: {
                        Integer[] integerArray = (Integer[])graphicController.getProperty(this.getId(), 377);
                        Integer[] integerArray2 = (Integer[])graphicController.getProperty(this.getId(), 376);
                        if (integerArray2[0] == 0 && integerArray2[1] == 0) {
                            integerArray2[0] = 1;
                        }
                        this.setLayout(new GridLayout(integerArray2[0], integerArray2[1], integerArray[0], integerArray[1]));
                        this.hasLayout = true;
                        break;
                    }
                    default: {
                        this.setLayout(null);
                        this.hasLayout = false;
                    }
                }
                this.validate();
                break;
            }
            case 376: 
            case 377: {
                Integer n6 = (Integer)GraphicController.getController().getProperty(this.getId(), 363);
                LayoutType layoutType = LayoutType.intToEnum((Integer)n6);
                if (layoutType != LayoutType.GRID) break;
                Integer[] integerArray = (Integer[])GraphicController.getController().getProperty(this.getId(), 377);
                Integer[] integerArray3 = (Integer[])GraphicController.getController().getProperty(this.getId(), 376);
                Integer[] integerArray4 = new Integer[]{0, 0};
                integerArray4[0] = integerArray3[0];
                integerArray4[1] = integerArray3[1];
                if (integerArray4[0] == 0 && integerArray4[1] == 0) {
                    integerArray4[0] = 1;
                }
                this.invalidate();
                GridLayout gridLayout = (GridLayout)this.getLayout();
                gridLayout.setRows(integerArray4[0]);
                gridLayout.setColumns(integerArray4[1]);
                gridLayout.setHgap(integerArray[0]);
                gridLayout.setVgap(integerArray[1]);
                this.validate();
                break;
            }
            case 378: {
                Integer n7 = (Integer)GraphicController.getController().getProperty(this.getId(), 363);
                LayoutType layoutType = LayoutType.intToEnum((Integer)n7);
                if (layoutType != LayoutType.BORDER) break;
                this.invalidate();
                Integer[] integerArray = (Integer[])object;
                BorderLayout borderLayout = (BorderLayout)this.getLayout();
                borderLayout.setHgap(integerArray[0]);
                borderLayout.setVgap(integerArray[1]);
                this.validate();
                break;
            }
            case 27: {
                boolean bl = true;
                Container container = this.getParent();
                if (container instanceof SwingScilabLayer) {
                    Boolean bl2 = (Boolean)object;
                    SwingScilabLayer swingScilabLayer = (SwingScilabLayer)container;
                    Boolean bl3 = swingScilabLayer.isLayerActive(this);
                    if (bl3 != bl2) {
                        graphicController.setProperty(this.uid, 27, (Object)bl3);
                    }
                    bl = false;
                } else if (container instanceof SwingScilabTabGroup) {
                    Boolean bl4 = (Boolean)object;
                    SwingScilabTabGroup swingScilabTabGroup = (SwingScilabTabGroup)container;
                    Boolean bl5 = swingScilabTabGroup.isTabActive(this);
                    if (bl5 != bl4) {
                        graphicController.setProperty(this.uid, 27, (Object)bl5);
                    }
                    bl = false;
                }
                if (!bl) break;
                this.setVisible((Boolean)object);
                break;
            }
            case 100: {
                Container container = this.getParent();
                if (container instanceof SwingScilabLayer) {
                    SwingScilabLayer swingScilabLayer = (SwingScilabLayer)container;
                    swingScilabLayer.updateModelProperties(null, swingScilabLayer.getActiveLayer());
                    break;
                }
                if (!(container instanceof SwingScilabTabGroup)) break;
                ((SwingScilabTabGroup)container).updateModelProperties();
                break;
            }
            case 99: {
                Boolean bl = (Boolean)GraphicController.getController().getProperty(this.getId(), 99);
                this.setEventHandlerEnabled(bl);
                break;
            }
            case 98: {
                String string = (String)GraphicController.getController().getProperty(this.getId(), 98);
                this.setEventHandler(string);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        SwingScilabTabGroup swingScilabTabGroup;
        Integer n;
        int n2;
        Object object;
        if (bl) {
            super.setEnabled(bl);
            object = (Integer[])GraphicController.getController().getProperty(this.uid, 22);
            for (n2 = 0; n2 < ((Serializable[])object).length; ++n2) {
                n = (Integer)GraphicController.getController().getProperty((Integer)object[n2], 29);
                if (n != 19) continue;
                Boolean bl2 = (Boolean)GraphicController.getController().getProperty((Integer)object[n2], 289);
                SwingView.getFromId((Integer)object[n2]).update(289, bl2);
            }
        } else {
            super.setEnabled(bl);
            object = this.getComponents();
            for (n2 = 0; n2 < ((Component[])object).length; ++n2) {
                ((Component)object[n2]).setEnabled(false);
            }
        }
        if ((object = this.getParent()) instanceof SwingScilabTabGroup && (n = (swingScilabTabGroup = (SwingScilabTabGroup)object).getIndex(this)) != -1) {
            swingScilabTabGroup.setEnabledAt(n, bl);
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Panel.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Panel.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    public void removeAxes() {
        if (this.canvas != null) {
            this.canvas.setEnabled(false);
            this.remove(this.canvas);
            this.canvas.removeNotify();
            this.canvas = null;
            this.repaint();
        }
    }

    public void setEventHandler(String string) {
        this.disableEventHandler();
        this.eventHandler = new ScilabEventListener(string, this.getId());
        if (this.eventEnabled) {
            this.enableEventHandler();
        }
    }

    public void setEventHandlerEnabled(boolean bl) {
        if (bl && this.eventEnabled) {
            return;
        }
        if (bl) {
            this.enableEventHandler();
            this.eventEnabled = true;
        } else {
            this.disableEventHandler();
            this.eventEnabled = false;
        }
    }

    private void enableEventHandler() {
        if (this.canvas != null) {
            this.canvas.addEventHandlerKeyListener(this.eventHandler);
            this.canvas.addEventHandlerMouseListener(this.eventHandler);
            this.canvas.addEventHandlerMouseMotionListener(this.eventHandler);
        }
    }

    private void disableEventHandler() {
        if (this.eventHandler != null && this.canvas != null) {
            this.canvas.removeEventHandlerKeyListener(this.eventHandler);
            this.canvas.removeEventHandlerMouseListener(this.eventHandler);
            this.canvas.removeEventHandlerMouseMotionListener(this.eventHandler);
        }
    }
}

