/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.fontchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.fontchooser.SimpleFontChooser;
import org.scilab.modules.gui.utils.ScilabFontUtils;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.localization.Messages;

public class SwingScilabFontChooser
extends JDialog
implements SimpleFontChooser {
    private static final long serialVersionUID = 1L;
    private static final int HGAP = 10;
    private static final int VGAP = 2;
    private static final int PREVIEW_WIDTH = 120;
    private static final int PREVIEW_HEIGHT = 40;
    private static final int DEFAULT_FONT_SIZE = 12;
    private int elementId;
    private final JList fontNameList;
    private final String[] availableFontNames;
    private final JList fontSizeList;
    private final String[] availableFontSizes = new String[]{"8", "10", "11", "12", "13", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72"};
    private final boolean calledFromScinotes;
    private final JCheckBox boldCheckbox;
    private final JCheckBox italicCheckbox;
    private final JCheckBox monospacedCheckbox;
    private JCheckBox scinotesCompatibleCheckbox;
    private final JLabel preview;
    private final String previewText = "The Quick Brown Fox Jumps Over The Lazy Dog";
    private Font selectedFont;

    public SwingScilabFontChooser(Font font) {
        this(new JFrame(), font, false);
    }

    public SwingScilabFontChooser(JFrame jFrame, Font font, boolean bl) {
        super(jFrame, Messages.gettext((String)"Font Chooser"), true);
        int n;
        this.calledFromScinotes = bl;
        ((JFrame)this.getParent()).setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"scilab", (String)"256x256")).getImage());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 2));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Messages.gettext((String)"Font")));
        this.fontNameList = new JList();
        this.fontNameList.setModel(new DefaultListModel());
        this.fontNameList.setSelectionMode(0);
        jPanel.add(new JScrollPane(this.fontNameList));
        this.availableFontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (n = 0; n < this.availableFontNames.length; ++n) {
            ((DefaultListModel)this.fontNameList.getModel()).addElement(this.availableFontNames[n]);
            if (font == null || !this.availableFontNames[n].equals(font.getFamily())) continue;
            this.fontNameList.setSelectedIndex(n);
        }
        if (this.fontNameList.getSelectedIndex() == -1) {
            this.fontNameList.setSelectedIndex(0);
        }
        ScilabSwingUtilities.closeOnEscape(this);
        this.fontSizeList = new JList();
        this.fontSizeList.setModel(new DefaultListModel());
        this.fontSizeList.setSelectionMode(0);
        jPanel.add(new JScrollPane(this.fontSizeList));
        for (n = 0; n < this.availableFontSizes.length; ++n) {
            ((DefaultListModel)this.fontSizeList.getModel()).addElement(this.availableFontSizes[n]);
            if (font == null || !this.availableFontSizes[n].equals(Integer.toString(font.getSize()))) continue;
            this.fontSizeList.setSelectedIndex(n);
        }
        if (this.fontSizeList.getSelectedIndex() == -1) {
            this.fontSizeList.setSelectedIndex(0);
        }
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2, 10, 2));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Messages.gettext((String)"Attributes")));
        this.boldCheckbox = new JCheckBox(Messages.gettext((String)"Bold"), font != null && font.isBold());
        jPanel2.add(this.boldCheckbox);
        this.italicCheckbox = new JCheckBox(Messages.gettext((String)"Italic"), font != null && font.isItalic());
        jPanel2.add(this.italicCheckbox);
        this.monospacedCheckbox = new JCheckBox(Messages.gettext((String)"Monospaced"), false);
        jPanel2.add(this.monospacedCheckbox);
        this.monospacedCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SwingScilabFontChooser.this.updateFontNameList();
            }
        });
        if (bl) {
            this.boldCheckbox.setEnabled(false);
            this.italicCheckbox.setEnabled(false);
            this.scinotesCompatibleCheckbox = new JCheckBox(Messages.gettext((String)"SciNotes compatible"), false);
            jPanel2.add(this.scinotesCompatibleCheckbox);
            this.scinotesCompatibleCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SwingScilabFontChooser.this.updateFontNameList();
                }
            });
        }
        this.getContentPane().add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Messages.gettext((String)"Preview")));
        this.preview = new JLabel("The Quick Brown Fox Jumps Over The Lazy Dog", 0);
        this.preview.setBackground(Color.white);
        this.preview.setForeground(Color.black);
        this.preview.setOpaque(true);
        this.preview.setBorder(new LineBorder(Color.black));
        this.preview.setPreferredSize(new Dimension(120, 40));
        jPanel3.add((Component)this.preview, "Center");
        this.getContentPane().add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton jButton = new JButton(Messages.gettext((String)"Ok"));
        jPanel5.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingScilabFontChooser.this.previewFont();
                SwingScilabFontChooser.this.dispose();
                SwingScilabFontChooser.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(Messages.gettext((String)"Cancel"));
        jPanel5.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingScilabFontChooser.this.selectedFont = null;
                SwingScilabFontChooser.this.dispose();
                SwingScilabFontChooser.this.setVisible(false);
            }
        });
        jPanel4.add(jPanel5);
        this.getContentPane().add(jPanel4);
        this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SwingScilabFontChooser.this.previewFont();
            }
        });
        this.fontNameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SwingScilabFontChooser.this.previewFont();
            }
        });
        this.boldCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SwingScilabFontChooser.this.previewFont();
            }
        });
        this.italicCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SwingScilabFontChooser.this.previewFont();
            }
        });
        this.previewFont();
        this.pack();
        this.setPreferredSize(this.getSize());
        this.setResizable(false);
    }

    @Override
    public void setElementId(int n) {
        this.elementId = n;
    }

    @Override
    public int getElementId() {
        return this.elementId;
    }

    @Override
    public Font getSelectedFont() {
        return this.selectedFont;
    }

    protected void previewFont() {
        if (this.fontNameList.getSelectedIndex() == -1 || this.fontSizeList.getSelectedIndex() == -1) {
            return;
        }
        String string = (String)this.fontNameList.getSelectedValue();
        String string2 = (String)this.fontSizeList.getSelectedValue();
        int n = Integer.parseInt(string2);
        int n2 = 0;
        boolean bl = this.boldCheckbox.isSelected();
        boolean bl2 = this.italicCheckbox.isSelected();
        if (bl) {
            n2 = 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        this.selectedFont = new Font(string, n2, n);
        this.preview.setFont(this.selectedFont);
        this.pack();
    }

    @Override
    public void setDefaultFontName(String string) {
        for (int i = 0; i < this.availableFontNames.length; ++i) {
            if (!this.availableFontNames[i].equalsIgnoreCase(string)) continue;
            this.fontNameList.setSelectedIndex(i);
        }
    }

    @Override
    public void setDefaultFontSize(int n) {
        for (int i = 0; i < this.availableFontSizes.length; ++i) {
            if (!this.availableFontSizes[i].equals(Integer.toString(n))) continue;
            this.fontSizeList.setSelectedIndex(i);
        }
    }

    @Override
    public void setDefaultBold(boolean bl) {
        this.boldCheckbox.setSelected(bl);
    }

    @Override
    public void setDefaultItalic(boolean bl) {
        this.italicCheckbox.setSelected(bl);
    }

    @Override
    public void displayAndWait() {
        this.setVisible(true);
    }

    private void updateFontNameList() {
        int n;
        boolean bl = this.monospacedCheckbox.isSelected();
        boolean bl2 = this.calledFromScinotes && this.scinotesCompatibleCheckbox.isSelected();
        this.setCursor(Cursor.getPredefinedCursor(3));
        ((DefaultListModel)this.fontNameList.getModel()).removeAllElements();
        if (!bl & !bl2) {
            for (n = 0; n < this.availableFontNames.length; ++n) {
                ((DefaultListModel)this.fontNameList.getModel()).addElement(this.availableFontNames[n]);
            }
        }
        if (bl & !bl2) {
            for (n = 0; n < this.availableFontNames.length; ++n) {
                if (!ScilabFontUtils.isMonospaced(new Font(this.availableFontNames[n], 0, 12))) continue;
                ((DefaultListModel)this.fontNameList.getModel()).addElement(this.availableFontNames[n]);
            }
        }
        if (!bl & bl2) {
            for (n = 0; n < this.availableFontNames.length; ++n) {
                if (!ScilabFontUtils.isAllStylesSameWidths(this.availableFontNames[n])) continue;
                ((DefaultListModel)this.fontNameList.getModel()).addElement(this.availableFontNames[n]);
            }
        }
        if (bl & bl2) {
            for (n = 0; n < this.availableFontNames.length; ++n) {
                if (!(ScilabFontUtils.isMonospaced(new Font(this.availableFontNames[n], 0, 12)) & ScilabFontUtils.isAllStylesSameWidths(this.availableFontNames[n]))) continue;
                ((DefaultListModel)this.fontNameList.getModel()).addElement(this.availableFontNames[n]);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }
}

