/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.gui.filechooser.FileChooserInfos;
import org.scilab.modules.gui.filechooser.SimpleFileChooser;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.SciFileFilter;
import org.scilab.modules.localization.Messages;

public class SwingScilabFileChooser
extends JFileChooser
implements SimpleFileChooser {
    private static final long serialVersionUID = 1L;
    private String[] selection;
    private String selectionPath;
    private String[] selectionFileNames;
    private int selectionSize;
    private int filterIndex;
    private int maskSize;
    private int dialogType;
    private String[] maskDescription;
    private JFrame parent;

    public SwingScilabFileChooser() {
        super.setCurrentDirectory(new File(ConfigManager.getLastOpenedDirectory()));
    }

    @Override
    public void setTitle(String string) {
        super.setDialogTitle(string);
    }

    public void addMask(String[] stringArray, String[] stringArray2) {
        this.maskSize = stringArray.length;
        if (stringArray2 == null || stringArray2.length == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                super.addChoosableFileFilter(new SciFileFilter(stringArray[i], null, i));
            }
        } else {
            this.maskDescription = stringArray2;
            for (int i = 0; i < stringArray.length; ++i) {
                super.addChoosableFileFilter(new SciFileFilter(stringArray[i], this.maskDescription[i], i));
            }
        }
    }

    @Override
    public void setInitialDirectory(String string) {
        String string2;
        if (string.length() == 0) {
            return;
        }
        String string3 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && System.getenv(string2) != null) {
            string3 = string3.replaceFirst(string2, System.getenv(string2));
        }
        super.setCurrentDirectory(new File(string3));
    }

    public void setParentFrame(JFrame jFrame) {
        this.parent = jFrame;
    }

    @Override
    public void displayAndWait() {
        JFrame jFrame = null;
        if (this.parent == null) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component != null) {
                jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, component);
            }
            if (jFrame == null) {
                jFrame = new JFrame();
            }
        } else {
            jFrame = this.parent;
        }
        int n = 0;
        if (this.maskSize > 0) {
            this.setFileFilter(this.getChoosableFileFilters()[this.maskSize]);
        }
        if ((n = this.dialogType == 1 ? this.showSaveDialog(jFrame) : this.showOpenDialog(jFrame)) == 0) {
            Object object;
            if (this.isMultiSelectionEnabled()) {
                object = this.getSelectedFiles();
                this.selection = new String[((File[])object).length];
                this.selectionFileNames = new String[((Object)object).length];
                this.selectionSize = ((Object)object).length;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    this.selection[i] = ((File)object[i]).getAbsolutePath();
                    this.selectionPath = ((File)object[i]).getParentFile().getPath();
                    this.selectionFileNames[i] = ((File)object[i]).getName();
                }
            } else {
                int n2;
                object = this.getSelectedFile();
                if (this.dialogType == 1 && ((File)object).exists() && (n2 = JOptionPane.showConfirmDialog(this, Messages.gettext((String)"Replace existing file?"), Messages.gettext((String)"File already exists"), 0)) != 0) {
                    this.selection = new String[1];
                    this.selection[0] = "";
                    this.selectionSize = 0;
                    this.selectionPath = "";
                    this.selectionFileNames = new String[1];
                    this.selectionFileNames[0] = "";
                    this.filterIndex = 0;
                    FileChooserInfos.getInstance().setSelection(this.selection);
                    FileChooserInfos.getInstance().setSelectionPathName(this.selectionPath);
                    FileChooserInfos.getInstance().setSelectionFileNames(this.selectionFileNames);
                    FileChooserInfos.getInstance().setSelectionSize(this.selectionSize);
                    FileChooserInfos.getInstance().setFilterIndex(this.filterIndex);
                    return;
                }
                this.selection = new String[1];
                this.selection[0] = ((File)object).getAbsolutePath();
                this.selectionPath = this.getFileSelectionMode() == 1 ? ((File)object).getPath() : ((File)object).getParentFile().getPath();
                this.selectionFileNames = new String[1];
                this.selectionFileNames[0] = ((File)object).getName();
                this.selectionSize = 1;
            }
            FileChooserInfos.getInstance().setSelection(this.selection);
            FileChooserInfos.getInstance().setSelectionPathName(this.selectionPath);
            FileChooserInfos.getInstance().setSelectionFileNames(this.selectionFileNames);
            FileChooserInfos.getInstance().setSelectionSize(this.selectionSize);
            object = this.getFileFilter();
            if (((FileFilter)object).getDescription().equals("All Files")) {
                FileChooserInfos.getInstance().setFilterIndex(this.maskSize + 1);
            }
            ConfigManager.saveLastOpenedDirectory(this.selectionPath);
        } else {
            this.selection = new String[1];
            this.selection[0] = "";
            this.selectionSize = 0;
            this.selectionPath = "";
            this.selectionFileNames = new String[1];
            this.selectionFileNames[0] = "";
            this.filterIndex = 0;
            FileChooserInfos.getInstance().setSelection(this.selection);
            FileChooserInfos.getInstance().setSelectionPathName(this.selectionPath);
            FileChooserInfos.getInstance().setSelectionFileNames(this.selectionFileNames);
            FileChooserInfos.getInstance().setSelectionSize(this.selectionSize);
            FileChooserInfos.getInstance().setFilterIndex(this.filterIndex);
        }
    }

    @Override
    public int getSelectionSize() {
        return this.selectionSize;
    }

    @Override
    public String[] getSelection() {
        return this.selection;
    }

    @Override
    public void setDirectorySelectionOnly() {
        this.setFileSelectionMode(1);
    }

    @Override
    public void setMultipleSelection(boolean bl) {
        this.setMultiSelectionEnabled(bl);
    }

    @Override
    public String getSelectionPathName() {
        return this.selectionPath;
    }

    @Override
    public String[] getSelectionFileNames() {
        return this.selectionFileNames;
    }

    @Override
    public void setUiDialogType(int n) {
        this.dialogType = n;
    }
}

