/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.editbox;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabSpinner
extends JSpinner
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -8036645127098703686L;
    private Integer uid;
    private CommonCallBack callback;
    private Border defaultBorder = null;

    public SwingScilabSpinner() {
        this.setModel(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1));
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        numberEditor.getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                System.out.println("keyTyped : " + keyEvent.getKeyChar());
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Double d = (Double)SwingScilabSpinner.this.getValue();
                GraphicController.getController().setProperty(SwingScilabSpinner.this.uid, 310, (Object)new Double[]{d});
                if (SwingScilabSpinner.this.callback != null) {
                    SwingScilabSpinner.this.callback.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public void setText(String string) {
    }

    @Override
    public void setEmptyText() {
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Spinner.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        this.getParent().remove(this);
        this.setVisible(false);
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 299: 
            case 300: 
            case 308: {
                Double d = (Double)graphicController.getProperty(this.getId(), 299);
                Double d2 = (Double)graphicController.getProperty(this.getId(), 300);
                if (d2 > d) {
                    return;
                }
                Double[] doubleArray = (Double[])graphicController.getProperty(this.getId(), 308);
                Double[] doubleArray2 = (Double[])graphicController.getProperty(this.getId(), 310);
                Double d3 = doubleArray2 != null && doubleArray2.length != 0 ? doubleArray2[0] : 0.0;
                if (d3 > d) {
                    d3 = d;
                }
                if (d3 < d2) {
                    d3 = d2;
                }
                d3 = doubleArray[0] != 0.0 ? Double.valueOf(Math.floor(d3 / doubleArray[0]) * doubleArray[0]) : d2;
                graphicController.setProperty(this.uid, 310, (Object)new Double[]{d3});
                this.setModel(new SpinnerNumberModel(d3, d2, d, doubleArray[0]));
                break;
            }
            case 310: {
                this.setValue(((Double[])object)[0]);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("Spinner.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

