/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.contextmenu;

import java.awt.Color;
import java.awt.MouseInfo;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.scilab.modules.commons.utils.StringBlockingResult;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.checkboxmenuitem.SwingScilabCheckBoxMenuItem;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.contextmenu.SimpleContextMenu;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.Size;

public class SwingScilabContextMenu
extends JPopupMenu
implements SwingViewObject,
SimpleContextMenu {
    private static final long serialVersionUID = 1L;
    private Integer uid;
    private boolean checkedState;
    private Border defaultBorder = null;

    public SwingScilabContextMenu() {
        this.setInvoker(this);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (SwingScilabContextMenu.this.uid != null && GraphicController.getController().getObjectFromId(SwingScilabContextMenu.this.uid) != null) {
                    GraphicController.getController().removeRelationShipAndDelete(SwingScilabContextMenu.this.uid);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (SwingScilabContextMenu.this.uid != null && GraphicController.getController().getObjectFromId(SwingScilabContextMenu.this.uid) != null) {
                    GraphicController.getController().removeRelationShipAndDelete(SwingScilabContextMenu.this.uid);
                }
            }
        });
    }

    @Override
    public String getBaseText() {
        return "";
    }

    private void setVisibleAndLocation() {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        }
    }

    @Override
    public void add(MenuItem menuItem) {
        super.add((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem());
    }

    @Override
    public void add(CheckBoxMenuItem checkBoxMenuItem) {
        super.add((SwingScilabCheckBoxMenuItem)checkBoxMenuItem.getAsSimpleCheckBoxMenuItem());
    }

    @Override
    public String displayAndWait() {
        return (String)StringBlockingResult.getInstance().getResult();
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void draw() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Size getDims() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDims(Size size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerticalAlignment(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        this.getParent().remove(this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    @Override
    public void setMnemonic(char c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMnemonic(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmptyText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Menu menu) {
        super.add((SwingScilabMenu)menu.getAsSimpleMenu());
    }

    @Override
    public void firePopupMenuCanceled() {
        StringBlockingResult.getInstance().setResult((Object)"");
        super.firePopupMenuCanceled();
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommonCallBack getCallback() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChecked(boolean bl) {
        this.checkedState = bl;
    }

    @Override
    public boolean isChecked() {
        return this.checkedState;
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        if (n == 22) {
            this.setVisibleAndLocation();
            this.pack();
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("PopupMenu.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("PopupMenu.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

