/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.console;

import com.artenum.rosetta.interfaces.ui.InputCommandView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.console.OneCharKeyEventListener;
import org.scilab.modules.console.SciConsole;
import org.scilab.modules.console.SciHistoryManager;
import org.scilab.modules.console.SciInputCommandView;
import org.scilab.modules.console.SciOutputView;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.console.SimpleConsole;
import org.scilab.modules.gui.events.callback.ScilabCallBack;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.history_manager.HistoryManagement;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;

public class SwingScilabConsole
extends SciConsole
implements SimpleConsole {
    private static final long serialVersionUID = 1L;
    private static final String CONFIRMATION_PATH = "//general/confirmation-dialogs/body/tools/tool[@id='console-clear']";
    private static final String CLEAR = Messages.gettext((String)"Clear Console");
    private static final String CLEAR_CONFIRM = Messages.gettext((String)"Are you sure you want to clear the console ?");
    private static final String DONT_SHOW = Messages.gettext((String)"Do not show this message again");

    public SwingScilabConsole() {
        super(ConfigManager.getUserConfigFile());
        SwingScilabContextMenu swingScilabContextMenu = new SwingScilabContextMenu();
        SwingScilabMenuItem swingScilabMenuItem = new SwingScilabMenuItem();
        swingScilabMenuItem.setText(Messages.gettext((String)"Cut"));
        swingScilabMenuItem.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.cutConsoleSelection", 3));
        swingScilabMenuItem.setMnemonic('U');
        SwingScilabMenuItem swingScilabMenuItem2 = new SwingScilabMenuItem();
        swingScilabMenuItem2.setText(Messages.gettext((String)"Copy"));
        swingScilabMenuItem2.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.copyConsoleSelection", 3));
        swingScilabMenuItem2.setMnemonic('C');
        SwingScilabMenuItem swingScilabMenuItem3 = new SwingScilabMenuItem();
        swingScilabMenuItem3.setText(Messages.gettext((String)"Paste"));
        swingScilabMenuItem3.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.pasteClipboardIntoConsole", 3));
        swingScilabMenuItem3.setMnemonic('P');
        SwingScilabMenuItem swingScilabMenuItem4 = new SwingScilabMenuItem();
        swingScilabMenuItem4.setText(Messages.gettext((String)"Clear History"));
        swingScilabMenuItem4.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.clearHistory", 3));
        swingScilabMenuItem4.setMnemonic('H');
        SwingScilabMenuItem swingScilabMenuItem5 = new SwingScilabMenuItem();
        swingScilabMenuItem5.setText(Messages.gettext((String)"Clear Console"));
        swingScilabMenuItem5.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.clear", 3));
        swingScilabMenuItem5.setMnemonic('O');
        SwingScilabMenuItem swingScilabMenuItem6 = new SwingScilabMenuItem();
        swingScilabMenuItem6.setText(Messages.gettext((String)"Select All"));
        swingScilabMenuItem6.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.selectAllConsoleContents", 3));
        swingScilabMenuItem6.setMnemonic('S');
        final SwingScilabMenuItem swingScilabMenuItem7 = new SwingScilabMenuItem();
        swingScilabMenuItem7.setText(Messages.gettext((String)"Help on a selected keyword"));
        swingScilabMenuItem7.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.helpOnTheKeyword", 3));
        swingScilabMenuItem7.setMnemonic('M');
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = SwingScilabConsole.this.getSelectedText();
                if (string == null || string.length() == 0) {
                    swingScilabMenuItem7.setText(Messages.gettext((String)"Help about a selected text"));
                } else {
                    int n = 10;
                    if (string.length() > n) {
                        string = string.substring(0, n) + "...";
                    }
                    swingScilabMenuItem7.setText(Messages.gettext((String)"Help about '") + string + "'");
                }
            }
        };
        swingScilabMenuItem7.addPropertyChangeListener(propertyChangeListener);
        final SwingScilabMenuItem swingScilabMenuItem8 = new SwingScilabMenuItem();
        swingScilabMenuItem8.setText(Messages.gettext((String)"Evaluate selection with echo"));
        swingScilabMenuItem8.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.evaluateSelectionWithEcho", 3));
        swingScilabMenuItem8.setMnemonic('E');
        propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = SwingScilabConsole.this.getSelectedText();
                swingScilabMenuItem8.setEnabled(string != null && !string.isEmpty());
            }
        };
        swingScilabMenuItem8.addPropertyChangeListener(propertyChangeListener);
        final SwingScilabMenuItem swingScilabMenuItem9 = new SwingScilabMenuItem();
        swingScilabMenuItem9.setText(Messages.gettext((String)"Evaluate selection with no echo"));
        swingScilabMenuItem9.setCallback(ScilabCallBack.createCallback("org.scilab.modules.gui.bridge.CallScilabBridge.evaluateSelectionWithNoEcho", 3));
        swingScilabMenuItem9.setMnemonic('N');
        propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = SwingScilabConsole.this.getSelectedText();
                swingScilabMenuItem9.setEnabled(string != null && !string.isEmpty());
            }
        };
        swingScilabMenuItem8.addPropertyChangeListener(propertyChangeListener);
        swingScilabContextMenu.add(swingScilabMenuItem7);
        swingScilabContextMenu.addSeparator();
        swingScilabContextMenu.add(swingScilabMenuItem);
        swingScilabContextMenu.add(swingScilabMenuItem2);
        swingScilabContextMenu.add(swingScilabMenuItem3);
        swingScilabContextMenu.addSeparator();
        swingScilabContextMenu.add(swingScilabMenuItem4);
        swingScilabContextMenu.add(swingScilabMenuItem5);
        swingScilabContextMenu.addSeparator();
        swingScilabContextMenu.add(swingScilabMenuItem6);
        swingScilabContextMenu.addSeparator();
        swingScilabContextMenu.add(swingScilabMenuItem8);
        swingScilabContextMenu.add(swingScilabMenuItem9);
        ((JEditorPane)this.getConfiguration().getOutputView()).setComponentPopupMenu(swingScilabContextMenu);
        ((JTextPane)this.getConfiguration().getInputCommandView()).setComponentPopupMenu(swingScilabContextMenu);
        ((JPanel)this.getConfiguration().getPromptView()).setComponentPopupMenu(swingScilabContextMenu);
        ((JTextPane)this.getConfiguration().getInputCommandView()).requestFocus();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ((JTextPane)SwingScilabConsole.this.getConfiguration().getInputCommandView()).requestFocus();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    @Override
    public void display(String string) {
        this.getConfiguration().getOutputView().append(string);
    }

    public void displayPrompt() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InputCommandView inputCommandView = SwingScilabConsole.this.getConfiguration().getInputCommandView();
                SwingScilabConsole.this.getConfiguration().getPromptView().setVisible(true);
                inputCommandView.setEditable(true);
                JTextPane jTextPane = (JTextPane)inputCommandView;
                if (jTextPane.isFocusOwner()) {
                    jTextPane.getCaret().setVisible(true);
                }
                SwingScilabConsole.this.setToHome();
            }
        });
        ((SciOutputView)this.getConfiguration().getOutputView()).resetLastEOL();
        this.updateScrollPosition();
    }

    public void unblock() {
        if (this.getCanReadUserInputValue().availablePermits() == 0) {
            this.setUserInputValue(110);
        }
        ((SciInputCommandView)this.getConfiguration().getInputCommandView()).interrupt();
    }

    @Override
    public int getCharWithoutOutput() {
        this.updateScrollPosition();
        try {
            this.getCanReadUserInputValue().acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.getConfiguration().getPromptView().setVisible(false);
        this.getConfiguration().getInputCommandView().setEditable(false);
        OneCharKeyEventListener oneCharKeyEventListener = new OneCharKeyEventListener((SciConsole)this);
        ((JTextPane)this.getConfiguration().getInputCommandView()).addKeyListener((KeyListener)oneCharKeyEventListener);
        ((JEditorPane)this.getConfiguration().getOutputView()).addKeyListener((KeyListener)oneCharKeyEventListener);
        int n = this.getUserInputValue();
        this.getCanReadUserInputValue().release();
        this.clear(-1);
        this.display("\n");
        ((JTextPane)this.getConfiguration().getInputCommandView()).removeKeyListener((KeyListener)oneCharKeyEventListener);
        ((JEditorPane)this.getConfiguration().getOutputView()).removeKeyListener((KeyListener)oneCharKeyEventListener);
        this.getConfiguration().getPromptView().setVisible(true);
        this.getConfiguration().getInputCommandView().setEditable(true);
        this.getConfiguration().getInputCommandView().reset();
        this.getConfiguration().getInputCommandView().requestFocus();
        final JTextPane jTextPane = (JTextPane)this.getConfiguration().getInputCommandView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextPane.getCaret().setVisible(true);
            }
        });
        return n;
    }

    @Override
    public void draw() {
        super.setVisible(true);
        super.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(super.getWidth(), super.getHeight());
    }

    @Override
    public Position getPosition() {
        return new Position(this.getX(), this.getY());
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public void setDims(Size size) {
        this.setPreferredSize(new Dimension(size.getWidth(), size.getHeight()));
    }

    @Override
    public void setPosition(Position position) {
        this.setLocation(position.getX(), position.getY());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void clear() {
        CheckClearConfirmation checkClearConfirmation = ((CheckClearConfirmation[])XConfiguration.get(CheckClearConfirmation.class, (Document)XConfiguration.getXConfigurationDocument(), (String)CONFIRMATION_PATH))[0];
        if (checkClearConfirmation.checked) {
            boolean bl;
            final Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            final boolean[] blArray = new boolean[1];
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    blArray[0] = ((JCheckBox)actionEvent.getSource()).isSelected();
                }
            };
            boolean bl2 = bl = ScilabModalDialog.show((Component)((Object)this), new String[]{CLEAR_CONFIRM}, CLEAR, ScilabModalDialog.IconType.WARNING_ICON, ScilabModalDialog.ButtonType.YES_NO, DONT_SHOW, abstractAction) == ScilabModalDialog.AnswerOption.NO_OPTION;
            if (component != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocus();
                    }
                });
            }
            if (bl) {
                if (blArray[0]) {
                    XConfiguration.set((Document)XConfiguration.getXConfigurationDocument(), (String)"//general/confirmation-dialogs/body/tools/tool[@id='console-clear']/@state", (String)"unchecked");
                }
                return;
            }
            if (blArray[0]) {
                XConfiguration.set((Document)XConfiguration.getXConfigurationDocument(), (String)"//general/confirmation-dialogs/body/tools/tool[@id='console-clear']/@state", (String)"unchecked");
            }
        }
        super.clear();
    }

    @Override
    public void setPrompt(String string) {
        this.getConfiguration().getPromptView().setDefaultPrompt(string);
    }

    @Override
    public void clearHistory() {
        ((SciHistoryManager)this.getConfiguration().getHistoryManager()).reset();
    }

    @Override
    public void pasteClipboard() {
        boolean bl;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        try {
            bl = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        if (!bl) {
            return;
        }
        String string = null;
        try {
            string = (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JTextPane jTextPane = (JTextPane)this.getConfiguration().getInputCommandView();
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        if (jTextPane.getSelectedText() != null) {
            try {
                styledDocument.remove(jTextPane.getSelectionStart(), jTextPane.getSelectionEnd() - jTextPane.getSelectionStart());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        try {
            styledDocument.insertString(((JTextPane)this.getConfiguration().getInputCommandView()).getCaretPosition(), string, styledDocument.getStyle("default"));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    public void selectAll() {
        JEditorPane jEditorPane = (JEditorPane)this.getConfiguration().getOutputView();
        jEditorPane.setSelectionStart(0);
        jEditorPane.setSelectionEnd(jEditorPane.getText().length());
    }

    private String getSelectedText() {
        JEditorPane jEditorPane = (JEditorPane)this.getConfiguration().getOutputView();
        JTextPane jTextPane = (JTextPane)this.getConfiguration().getInputCommandView();
        String string = "";
        if (jEditorPane.getSelectedText() != null) {
            string = string + jEditorPane.getSelectedText();
        }
        if (jTextPane.getSelectedText() != null) {
            string = string + jTextPane.getSelectedText();
        }
        return string;
    }

    @Override
    public void helpOnTheKeyword() {
        String string = this.getSelectedText();
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\"", "\"\"");
        InterpreterManagement.requestScilabExec((String)("help('" + string + "')"));
    }

    @Override
    public void evaluateSelectionWithEcho() {
        String string = this.getSelectedText();
        if (string.compareTo("") != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            HistoryManagement.appendLinesToScilabHistory((String[])stringArray, (int)stringArray.length);
            this.sendCommandsToScilab(string, true, false);
        }
    }

    @Override
    public void evaluateSelectionWithNoEcho() {
        this.sendCommandsToScilab(this.getSelectedText(), false, false);
    }

    @Override
    public void copyToClipboard() {
        String string = this.getSelectedText();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    @Override
    public void cutSelection() {
        JTextPane jTextPane = (JTextPane)this.getConfiguration().getInputCommandView();
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        if (jTextPane.getSelectedText() != null) {
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(jTextPane.getSelectedText()), null);
                styledDocument.remove(jTextPane.getSelectionStart(), jTextPane.getSelectionEnd() - jTextPane.getSelectionStart());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    @Override
    public void setMaxOutputSize(int n) {
        ((SciOutputView)this.getConfiguration().getOutputView()).setMaxSize(n);
    }

    @XConfiguration.XConfAttribute
    private static class CheckClearConfirmation {
        public boolean checked;

        private CheckClearConfirmation() {
        }

        @XConfiguration.XConfAttribute(attributes={"state"})
        private void set(String string) {
            this.checked = string.equals("checked");
        }
    }
}

