/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.checkbox;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.bridge.groupmanager.GroupManager;
import org.scilab.modules.gui.bridge.radiobutton.SwingScilabRadioButton;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabAlignment;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabCheckBox
extends JCheckBox
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = 3435428345694647542L;
    private Integer uid;
    private CommonCallBack callback;
    private ActionListener actListener;
    private Border defaultBorder = null;

    public SwingScilabCheckBox() {
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.actListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Double[] doubleArray = new Double[]{SwingScilabCheckBox.this.isSelected() ? (Double)GraphicController.getController().getProperty(SwingScilabCheckBox.this.uid, 299) : (Double)GraphicController.getController().getProperty(SwingScilabCheckBox.this.uid, 300)};
                if (SwingScilabCheckBox.this.isSelected() && (string = (String)GraphicController.getController().getProperty(SwingScilabCheckBox.this.uid, 392)) != null && !string.equals("")) {
                    Enumeration<AbstractButton> enumeration = GroupManager.getGroupManager().getGroupElements(string);
                    while (enumeration.hasMoreElements()) {
                        AbstractButton abstractButton = enumeration.nextElement();
                        if (abstractButton == actionEvent.getSource()) continue;
                        Integer n = 0;
                        if (abstractButton instanceof SwingScilabRadioButton) {
                            n = ((SwingScilabRadioButton)abstractButton).getId();
                        } else {
                            if (!(abstractButton instanceof SwingScilabRadioButton)) continue;
                            n = ((SwingScilabCheckBox)abstractButton).getId();
                        }
                        Double[] doubleArray2 = new Double[]{(Double)GraphicController.getController().getProperty(n, 300)};
                        GraphicController.getController().setProperty(n, 310, (Object)doubleArray2);
                    }
                }
                GraphicController.getController().setProperty(SwingScilabCheckBox.this.uid, 310, (Object)doubleArray);
                if (SwingScilabCheckBox.this.callback != null) {
                    SwingScilabCheckBox.this.callback.actionPerformed(actionEvent);
                }
            }
        };
        this.addActionListener(this.actListener);
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        this.callback = commonCallBack;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        this.setHorizontalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    @Override
    public void setVerticalAlignment(String string) {
        this.setVerticalAlignment(ScilabAlignment.toSwingAlignment(string));
    }

    public void setChecked(boolean bl) {
        String string;
        if (this.actListener != null) {
            this.removeActionListener(this.actListener);
        }
        if ((string = (String)GraphicController.getController().getProperty(this.uid, 392)) != null && !string.equals("")) {
            GroupManager.getGroupManager().setSelected(this.getModel(), string, bl);
            Enumeration<AbstractButton> enumeration = GroupManager.getGroupManager().getGroupElements(string);
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                Integer n = 0;
                boolean bl2 = false;
                if (abstractButton instanceof SwingScilabRadioButton) {
                    n = ((SwingScilabRadioButton)abstractButton).getId();
                    bl2 = ((SwingScilabRadioButton)abstractButton).isSelected();
                } else {
                    if (!(abstractButton instanceof SwingScilabCheckBox)) continue;
                    n = ((SwingScilabCheckBox)abstractButton).getId();
                    bl2 = ((SwingScilabCheckBox)abstractButton).isSelected();
                }
                Double[] doubleArray = new Double[]{bl2 ? (Double)GraphicController.getController().getProperty(n, 299) : (Double)GraphicController.getController().getProperty(n, 300)};
                GraphicController.getController().setProperty(n, 310, (Object)doubleArray);
            }
        } else {
            this.setSelected(bl);
        }
        if (this.actListener != null) {
            this.addActionListener(this.actListener);
        }
    }

    public boolean isChecked() {
        return this.isSelected();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        this.getParent().remove(this);
        this.setVisible(false);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 392: {
                String string = (String)object;
                if (string == null || string.equals("")) {
                    GroupManager.getGroupManager().removeFromGroup(this);
                    break;
                }
                GroupManager.getGroupManager().addToGroup(string, this);
                break;
            }
            case 299: {
                Double d = (Double)object;
                Double[] doubleArray = (Double[])graphicController.getProperty(this.uid, 310);
                if (doubleArray == null || doubleArray.length == 0) {
                    return;
                }
                double d2 = doubleArray[0];
                this.setChecked(d == d2);
                break;
            }
            case 310: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length == 0) {
                    return;
                }
                int[] nArray = new int[doubleArray.length];
                for (int i = 0; i < doubleArray.length; ++i) {
                    nArray[i] = doubleArray[i].intValue();
                }
                Integer n2 = ((Double)graphicController.getProperty(this.uid, 299)).intValue();
                this.setChecked(n2 == nArray[0]);
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("CheckBox.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("CheckBox.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }
}

