/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.canvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JPanel;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.bridge.canvas.SwingScilabCanvasImpl;
import org.scilab.modules.gui.bridge.tab.SwingScilabAxes;
import org.scilab.modules.gui.canvas.SimpleCanvas;
import org.scilab.modules.gui.events.GlobalEventWatcher;
import org.scilab.modules.gui.graphicWindow.PanelLayout;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;

public class SwingScilabCanvas
extends JPanel
implements SimpleCanvas {
    private static final long serialVersionUID = 6101347094617535625L;
    private final Canvas rendererCanvas;
    private AxesContainer figure;
    private DrawerVisitor drawerVisitor;
    private final Component drawableComponent;
    private Integer id;

    public SwingScilabCanvas(final AxesContainer axesContainer) {
        super(new PanelLayout());
        this.figure = axesContainer;
        this.drawableComponent = SwingScilabCanvasImpl.getInstance().createOpenGLComponent();
        this.drawableComponent.setEnabled(true);
        this.drawableComponent.setVisible(true);
        this.add(this.drawableComponent, "GL_CANVAS");
        this.rendererCanvas = JoGLCanvasFactory.createCanvas((GLAutoDrawable)((GLAutoDrawable)this.drawableComponent));
        this.drawerVisitor = null;
        this.drawableComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingScilabCanvas.this.requestFocus();
            }
        });
        this.drawerVisitor = new DrawerVisitor(this.drawableComponent, this.rendererCanvas, axesContainer);
        this.rendererCanvas.setMainDrawer((Drawer)this.drawerVisitor);
        this.drawableComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GlobalEventWatcher.setAxesUID(axesContainer.getIdentifier());
            }
        });
        this.setBackground(Color.white);
        this.setFocusable(true);
        this.setEnabled(true);
    }

    @Override
    public void addNotify() {
        this.drawableComponent.setVisible(true);
        this.drawableComponent.setEnabled(true);
        this.add(this.drawableComponent, "GL_CANVAS");
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.drawableComponent.setVisible(false);
        this.drawableComponent.setEnabled(false);
        this.remove(this.drawableComponent);
        super.removeNotify();
    }

    public Canvas getRendererCanvas() {
        return this.rendererCanvas;
    }

    public AxesContainer getFigure() {
        return this.figure;
    }

    public static SwingScilabCanvas createCanvas(int n, int n2) {
        return null;
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public Position getPosition() {
        return new Position(this.getX(), this.getY());
    }

    @Override
    public void setDims(Size size) {
        Dimension dimension = new Dimension(size.getWidth(), size.getHeight());
        this.setSize(dimension);
    }

    @Override
    public void setPosition(Position position) {
        this.setLocation(position.getX(), position.getY());
    }

    public int getFigureIndex() {
        return this.getParentAxes().getFigureId();
    }

    @Override
    public void setBackgroundColor(double d, double d2, double d3) {
        this.setBackground(new Color((float)d, (float)d2, (float)d3));
    }

    @Override
    public void close() {
    }

    @Override
    public BufferedImage dumpAsBufferedImage() {
        Canvas canvas = this.getRendererCanvas();
        if (canvas instanceof JoGLCanvas) {
            return ((JoGLCanvas)canvas).getImage();
        }
        return null;
    }

    @Override
    public void setSingleBuffered(boolean bl) {
    }

    private SwingScilabAxes getParentAxes() {
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.setCursor(cursor);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    public void addEventHandlerKeyListener(KeyListener keyListener) {
        this.addKeyListener(keyListener);
    }

    public void removeEventHandlerKeyListener(KeyListener keyListener) {
        this.removeKeyListener(keyListener);
    }

    public void addEventHandlerMouseListener(MouseListener mouseListener) {
        this.drawableComponent.addMouseListener(mouseListener);
    }

    public void removeEventHandlerMouseListener(MouseListener mouseListener) {
        this.drawableComponent.removeMouseListener(mouseListener);
    }

    public void addEventHandlerMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.drawableComponent.addMouseMotionListener(mouseMotionListener);
    }

    public void removeEventHandlerMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.drawableComponent.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void display() {
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return false;
    }

    @Override
    public GL getGL() {
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
    }

    public boolean isAutoResize() {
        Boolean bl = (Boolean)GraphicController.getController().getProperty(this.figure.getIdentifier(), 83);
        return bl == null ? false : bl;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Integer getId() {
        return this.id;
    }
}

