/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.console.SciConsole;
import org.scilab.modules.graphic_export.FileExporter;
import org.scilab.modules.graphic_objects.ScilabNativeView;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.canvas.SwingScilabCanvasImpl;
import org.scilab.modules.gui.bridge.console.SwingScilabConsole;
import org.scilab.modules.gui.bridge.contextmenu.SwingScilabContextMenu;
import org.scilab.modules.gui.bridge.frame.SwingScilabFrame;
import org.scilab.modules.gui.bridge.frame.SwingScilabScrollableFrame;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.colorchooser.ColorChooser;
import org.scilab.modules.gui.colorchooser.ScilabColorChooser;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.filechooser.FileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.fontchooser.FontChooser;
import org.scilab.modules.gui.fontchooser.ScilabFontChooser;
import org.scilab.modules.gui.helpbrowser.HelpBrowser;
import org.scilab.modules.gui.helpbrowser.ScilabHelpBrowser;
import org.scilab.modules.gui.messagebox.MessageBox;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.ImageExporter;
import org.scilab.modules.gui.utils.PrinterHelper;
import org.scilab.modules.gui.utils.ScilabAboutBox;
import org.scilab.modules.gui.utils.ScilabPrint;
import org.scilab.modules.gui.utils.UIElementMapper;
import org.scilab.modules.gui.utils.WebBrowser;
import org.scilab.modules.gui.widget.Widget;
import org.scilab.modules.localization.Messages;

public class CallScilabBridge {
    private static final int NB_COLORS = 3;
    private static PrintRequestAttributeSet scilabPageFormat = new HashPrintRequestAttributeSet();
    private static final String CONSOLE = "Console";

    protected CallScilabBridge() {
        throw new UnsupportedOperationException();
    }

    public static String readLine() {
        return ScilabConsole.getConsole().readLine();
    }

    public static void display(String string) {
        ScilabConsole.getConsole().display(string);
    }

    public static boolean isWaitingForInput() {
        return ScilabConsole.getConsole().isWaitingForInput();
    }

    public static void scilabLinesUpdate() {
        ScilabConsole.getConsole().scilabLinesUpdate();
    }

    public static void clear() {
        ScilabConsole.getConsole().clear();
    }

    public static void clear(int n) {
        ScilabConsole.getConsole().clear(n);
    }

    public static int getCharWithoutOutput() {
        return ScilabConsole.getConsole().getAsSimpleConsole().getCharWithoutOutput();
    }

    public static void toHome() {
        ScilabConsole.getConsole().toHome();
    }

    public static void setPrompt(String string) {
        ScilabConsole.getConsole().setPrompt(string);
    }

    public static void clearHistory() {
        ScilabConsole.getConsole().clearHistory();
    }

    public static int newColorChooser() {
        ColorChooser colorChooser = ScilabColorChooser.createColorChooser();
        return UIElementMapper.add(colorChooser);
    }

    public static int newFontChooser() {
        FontChooser fontChooser = ScilabFontChooser.createFontChooser();
        return UIElementMapper.add(fontChooser);
    }

    public static int newMessageBox() {
        MessageBox messageBox = ScilabMessageBox.createMessageBox();
        return UIElementMapper.add(messageBox);
    }

    public static String displayAndWaitContextMenu(int n) {
        SwingViewObject swingViewObject = SwingView.getFromId(n);
        return ((SwingScilabContextMenu)swingViewObject).displayAndWait();
    }

    public static void setMenuEnabled(int n, String string, boolean bl) {
        SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)SwingView.getFromId(n);
        if (swingScilabDockablePanel != null) {
            swingScilabDockablePanel.getMenuBar().getAsSimpleMenuBar().setMenuEnabled(string, bl);
        }
    }

    public static void setSubMenuEnabled(int n, String string, int n2, boolean bl) {
        SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)SwingView.getFromId(n);
        if (swingScilabDockablePanel != null) {
            swingScilabDockablePanel.getMenuBar().getAsSimpleMenuBar().setSubMenuEnabled(string, n2, bl);
        }
    }

    public static void removeMenu(int n, String string) {
        SwingScilabPanel swingScilabPanel = (SwingScilabPanel)SwingView.getFromId(n);
        if (swingScilabPanel != null) {
            swingScilabPanel.getMenuBar().getAsSimpleMenuBar().removeMenu(string);
        }
    }

    public static int newExportFileChooser(int n) {
        FileChooser fileChooser = ScilabFileChooser.createExportFileChooser(n);
        return 0;
    }

    public static int exportUI(int n) {
        FileChooser fileChooser = ScilabFileChooser.createExportFileChooser(ScilabNativeView.ScilabNativeView__getFigureFromIndex((int)n));
        return 0;
    }

    public static void setMessageBoxTitle(int n, String string) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setTitle(string);
    }

    public static void setMessageBoxMessage(int n, String string) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setMessage(string);
    }

    public static void setMessageBoxMessage(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setMessage(stringArray);
    }

    public static void messageBoxDisplayAndWait(int n) {
        final int n2 = n;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ((MessageBox)UIElementMapper.getCorrespondingUIElement(n2)).displayAndWait();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static int getMessageBoxSelectedButton(int n) {
        return ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).getSelectedButton();
    }

    public static void setMessageBoxDefaultSelectedButtons(int n, int[] nArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setDefaultSelectedButtons(nArray);
    }

    public static int[] getMessageBoxUserSelectedButtons(int n) {
        return ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).getUserSelectedButtons();
    }

    public static void setMessageBoxButtonsLabels(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setButtonsLabels(stringArray);
    }

    public static void setMessageBoxInitialValue(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setInitialValue(stringArray);
    }

    public static String[] getMessageBoxValue(int n) {
        return ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).getValue();
    }

    public static int getMessageBoxValueSize(int n) {
        return ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).getValueSize();
    }

    public static void setMessageBoxListBoxItems(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setListBoxItems(stringArray);
    }

    public static int getMessageBoxSelectedItem(int n) {
        return ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).getSelectedItem();
    }

    public static void setMessageBoxLineLabels(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setLineLabels(stringArray);
    }

    public static void setMessageBoxColumnLabels(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setColumnLabels(stringArray);
    }

    public static void setMessageBoxDefaultInput(int n, String[] stringArray) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setDefaultInput(stringArray);
    }

    public static void setMessageBoxModal(int n, boolean bl) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setModal(bl);
    }

    public static void setMessageBoxIcon(int n, String string) {
        ((MessageBox)UIElementMapper.getCorrespondingUIElement(n)).setIcon(string);
    }

    public static void launchHelpBrowser(final String[] stringArray, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ScilabHelpBrowser.createHelpBrowser(stringArray, string);
                    ScilabHelpBrowser.startHomePage();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        });
    }

    public static void searchKeyword(final String[] stringArray, final String string, final String string2, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        HelpBrowser helpBrowser = ScilabHelpBrowser.createHelpBrowser(stringArray, string2);
                        if (helpBrowser != null) {
                            helpBrowser.fullTextSearch(string);
                        }
                    } else {
                        HelpBrowser helpBrowser = ScilabHelpBrowser.createHelpBrowser(stringArray, string2);
                        if (helpBrowser != null) {
                            helpBrowser.searchKeywork(string);
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        });
    }

    public static void openHelp(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HelpBrowser helpBrowser = ScilabHelpBrowser.createHelpBrowser(null, ScilabCommons.getlanguage());
                    if (helpBrowser != null) {
                        helpBrowser.searchKeywork(string);
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        });
    }

    public static void closeHelpBrowser() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ScilabHelpBrowser.getHelpBrowser().close();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        });
    }

    public static void showSearchFieldInHelp() {
        ScilabHelpBrowser.getHelpBrowser().showSearchField();
    }

    public static void increaseFontInHelpViewer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScilabHelpBrowser.getHelpBrowser().increaseFont();
            }
        });
    }

    public static void decreaseFontInHelpViewer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScilabHelpBrowser.getHelpBrowser().decreaseFont();
            }
        });
    }

    public static void openScilabWebSite() {
        WebBrowser.openUrl("http://www.scilab.org/");
    }

    public static void openWiki() {
        WebBrowser.openUrl("http://wiki.scilab.org/");
    }

    public static void openAtomsScilab() {
        WebBrowser.openUrl("http://atoms.scilab.org/");
    }

    public static void openFileExchange() {
        WebBrowser.openUrl("http://fileexchange.scilab.org/");
    }

    public static void openBugzilla() {
        WebBrowser.openUrl("http://bugzilla.scilab.org/");
    }

    public static void openForge() {
        WebBrowser.openUrl("http://forge.scilab.org/");
    }

    public static void openOnlineHelp() {
        WebBrowser.openUrl("http://help.scilab.org/");
    }

    public static void openMailingList() {
        WebBrowser.openUrl("http://www.scilab.org/communities/developer_zone/tools/mailing_list");
    }

    public static void openMailingListArchives() {
        WebBrowser.openUrl("http://mailinglists.scilab.org/");
    }

    public static void openSE() {
        WebBrowser.openUrl("http://www.scilab.io");
    }

    public static void selectAllConsoleContents() {
        ScilabConsole.getConsole().selectAll();
    }

    public static void helpOnTheKeyword() {
        ScilabConsole.getConsole().helpOnTheKeyword();
    }

    public static void copyConsoleSelection() {
        ScilabConsole.getConsole().copyToClipboard();
    }

    public static void cutConsoleSelection() {
        ScilabConsole.getConsole().cutSelection();
    }

    public static void pasteClipboardIntoConsole() {
        ScilabConsole.getConsole().pasteClipboard();
    }

    public static void emptyClipboard() {
        StringSelection stringSelection = new StringSelection("");
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static void evaluateSelectionWithEcho() {
        ScilabConsole.getConsole().evaluateSelectionWithEcho();
    }

    public static void evaluateSelectionWithNoEcho() {
        ScilabConsole.getConsole().evaluateSelectionWithNoEcho();
    }

    public static void changeConsoleFont() {
        FontChooser fontChooser = ScilabFontChooser.createFontChooser(ScilabConsole.getConsole().getFont());
        fontChooser.displayAndWait();
        Font font = fontChooser.getSelectedFont();
        if (font != null) {
            ScilabConsole.getConsole().setFont(font);
            ConfigManager.saveFont(font);
        }
    }

    public static void unblockConsole() {
        SwingScilabConsole swingScilabConsole = (SwingScilabConsole)ScilabConsole.getConsole().getAsSimpleConsole();
        swingScilabConsole.unblock();
    }

    public static void changeConsoleForeground() {
        ColorChooser colorChooser = ScilabColorChooser.createColorChooser(ScilabConsole.getConsole().getForeground());
        colorChooser.setTitle(Messages.gettext((String)"Console Font..."));
        colorChooser.displayAndWait();
        Color color = colorChooser.getSelectedColor();
        if (color != null) {
            ScilabConsole.getConsole().setForeground(color);
            ConfigManager.saveConsoleForeground(color);
        }
    }

    public static void changeConsoleBackground() {
        ColorChooser colorChooser = ScilabColorChooser.createColorChooser(ScilabConsole.getConsole().getBackground());
        colorChooser.setTitle(Messages.gettext((String)"Console Background..."));
        colorChooser.displayAndWait();
        Color color = colorChooser.getSelectedColor();
        if (color != null) {
            ScilabConsole.getConsole().setBackground(color);
            ConfigManager.saveConsoleBackground(color);
        }
    }

    public static void printConsoleContents() {
        SciConsole sciConsole = (SciConsole)ScilabConsole.getConsole().getAsSimpleConsole();
        Document document = ((JEditorPane)sciConsole.getConfiguration().getOutputView()).getDocument();
        String string = null;
        String string2 = ((JTextPane)sciConsole.getConfiguration().getInputCommandView()).getSelectedText();
        String string3 = ((JEditorPane)sciConsole.getConfiguration().getOutputView()).getSelectedText();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (string2 != null) {
            CallScilabBridge.printString(string2, new String(CONSOLE));
        } else if (string3 != null) {
            CallScilabBridge.printString(string3, new String(CONSOLE));
        } else {
            CallScilabBridge.printString(string, new String(CONSOLE));
        }
    }

    public static boolean printString(String string, String string2) {
        return PrinterHelper.printString(string, string2);
    }

    public static boolean printFile(String string) {
        return PrinterHelper.printFile(string);
    }

    public static boolean print_figure(int n) {
        return CallScilabBridge.printFigure(ScilabNativeView.ScilabNativeView__getFigureFromIndex((int)n), true, true);
    }

    public static boolean printFigure(int n, boolean bl, boolean bl2) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        boolean bl3 = true;
        if (bl2) {
            bl3 = printerJob.printDialog(scilabPageFormat);
        }
        if (bl3) {
            if (CallScilabBridge.isWindowsPlateform()) {
                Object object;
                Figure figure = (Figure)GraphicController.getController().getObjectFromId(Integer.valueOf(n));
                int n2 = figure.getId();
                BufferedImage bufferedImage = null;
                if (figure.getVisible().booleanValue()) {
                    bufferedImage = ((SwingScilabDockablePanel)SwingView.getFromId(n)).getContentCanvas().dumpAsBufferedImage();
                } else {
                    try {
                        object = File.createTempFile("scilabfigure", ".png");
                        ((File)object).delete();
                        FileExporter.fileExport((int)n, (String)((File)object).getAbsolutePath(), (String)"PNG", (float)1.0f, (int)0);
                        bufferedImage = ImageIO.read((File)object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return false;
                    }
                }
                if (bufferedImage != null) {
                    object = new ScilabPrint(bufferedImage, printerJob, scilabPageFormat);
                    return object != null;
                }
                return false;
            }
            DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.POSTSCRIPT;
            String string = ".ps";
            try {
                String string2 = File.createTempFile("scilabfigure", "").getAbsolutePath();
                if ((PrintRequestAttribute)scilabPageFormat.get(OrientationRequested.class) == OrientationRequested.PORTRAIT) {
                    FileExporter.fileExport((int)n, (String)(string2 + string), (String)"PS", (float)1.0f, (int)0);
                } else {
                    FileExporter.fileExport((int)n, (String)(string2 + string), (String)"PS", (float)1.0f, (int)1);
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(string2 + string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    return false;
                }
                SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, null);
                PrintService printService = printerJob.getPrintService();
                if (printService == null) {
                    MessageBox messageBox = ScilabMessageBox.createMessageBox();
                    messageBox.setMessage(Messages.gettext((String)"No print service found."));
                    messageBox.setModal(true);
                    messageBox.setIcon("error");
                    messageBox.displayAndWait();
                    return false;
                }
                DocPrintJob docPrintJob = printService.createPrintJob();
                HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet(scilabPageFormat);
                hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
                return true;
            }
            catch (IOException iOException) {
                System.err.println("Could not create temporary file " + iOException.getLocalizedMessage());
                return false;
            }
            catch (PrintException printException) {
                printException.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static boolean pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        return printerJob.pageDialog(scilabPageFormat) != null;
    }

    public static void setFontChooserFontName(int n, String string) {
        ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).setDefaultFontName(string);
    }

    public static void setFontChooserFontSize(int n, int n2) {
        ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).setDefaultFontSize(n2);
    }

    public static void setFontChooserBold(int n, boolean bl) {
        ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).setDefaultBold(bl);
    }

    public static void setFontChooserItalic(int n, boolean bl) {
        ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).setDefaultItalic(bl);
    }

    public static String getFontChooserFontName(int n) {
        Font font = ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).getSelectedFont();
        if (font != null) {
            return font.getFamily();
        }
        return "";
    }

    public static int getFontChooserFontSize(int n) {
        return ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).getSelectedFont().getSize();
    }

    public static boolean getFontChooserBold(int n) {
        return ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).getSelectedFont().isBold();
    }

    public static boolean getFontChooserItalic(int n) {
        return ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).getSelectedFont().isItalic();
    }

    public static void fontChooserDisplayAndWait(int n) {
        ((FontChooser)UIElementMapper.getCorrespondingUIElement(n)).displayAndWait();
    }

    public static void setColorChooserTitle(int n, String string) {
        ((ColorChooser)UIElementMapper.getCorrespondingUIElement(n)).setTitle(string);
    }

    public static void setColorChooserDefaultColor(int n, int[] nArray) {
        ((ColorChooser)UIElementMapper.getCorrespondingUIElement(n)).setDefaultColor(new Color(nArray[0], nArray[1], nArray[2]));
    }

    public static int[] getColorChooserSelectedColor(int n) {
        Color color = ((ColorChooser)UIElementMapper.getCorrespondingUIElement(n)).getSelectedColor();
        int[] nArray = new int[3];
        if (color != null) {
            nArray[0] = color.getRed();
            nArray[1] = color.getGreen();
            nArray[2] = color.getBlue();
        } else {
            nArray[0] = -1;
            nArray[1] = -1;
            nArray[2] = -1;
        }
        return nArray;
    }

    public static void colorChooserDisplayAndWait(int n) {
        ((ColorChooser)UIElementMapper.getCorrespondingUIElement(n)).displayAndWait();
    }

    public static String getClipboardContents() {
        boolean bl;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        String string = "";
        try {
            bl = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException illegalStateException) {
            return string;
        }
        if (!bl) {
            return string;
        }
        try {
            string = (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public static void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static void clipboard_figure(int n) {
        CallScilabBridge.copyFigureToClipBoard(ScilabNativeView.ScilabNativeView__getFigureFromIndex((int)n));
    }

    public static void copyFigureToClipBoard(int n) {
        Image image = ImageExporter.imageExport(n);
        if (image != null) {
            ClipboardImage clipboardImage = new ClipboardImage(image);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(clipboardImage, null);
        }
    }

    public static int getScreenResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public static double getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().getWidth();
    }

    public static double getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    }

    public static int getScreenDepth() {
        return Toolkit.getDefaultToolkit().getColorModel().getPixelSize();
    }

    public static void requestFocus(int n) {
        SwingViewObject swingViewObject = SwingView.getFromId(n);
        if (swingViewObject instanceof SwingScilabScrollableFrame) {
            ((SwingScilabScrollableFrame)swingViewObject).requestFocus();
        } else if (swingViewObject instanceof SwingScilabFrame) {
            ((SwingScilabFrame)swingViewObject).requestFocus();
        } else {
            ((Widget)((Object)swingViewObject)).requestFocus();
        }
    }

    public static void raiseWindow(int n) {
    }

    public static boolean isWindowsPlateform() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static void useCanvasForDisplay(boolean bl) {
        SwingScilabCanvasImpl.switchToGLCanvas(bl);
    }

    public static boolean useCanvasForDisplay() {
        return SwingScilabCanvasImpl.isGLCanvasEnabled();
    }

    public static void scilabAboutBox() {
        ScilabAboutBox.displayAndWait();
    }

    public static void fireClosingFinished(int n) {
        SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)SwingView.getFromId(n);
        ClosingOperationsManager.removeFromDunnoList(swingScilabDockablePanel);
    }

    public static void registerSwingView() {
        SwingView.registerSwingView();
    }

    public static class ClipboardImage
    implements Transferable {
        private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
        private final Image image;

        public ClipboardImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.flavors[0].equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.flavors[0].equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }
    }
}

