/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.DockingStrategy;
import org.flexdock.docking.defaults.DefaultDockingStrategy;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.props.PropertyManager;
import org.flexdock.plaf.PlafManager;
import org.flexdock.plaf.theme.ViewUI;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.ResourceManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.view.Button;
import org.flexdock.view.Titlebar;
import org.flexdock.view.ViewProps;
import org.flexdock.view.Viewport;

public class View
extends JComponent
implements Dockable,
DockingConstants {
    public static final String uiClassID = "Flexdock.view";
    public static final String ACTION_TOGGLE_NEXT = "toggleNextView";
    public static final String ACTION_TOGGLE_PREVIOUS = "togglePreviousView";
    static final DockingStrategy VIEW_DOCKING_STRATEGY = View.createDockingStrategy();
    private String persistentId;
    protected Titlebar titlepane;
    protected Container contentPane;
    protected boolean contentPaneCheckingEnabled;
    protected ArrayList dockingListeners;
    protected ArrayList dragSources;
    protected HashSet frameDragSources;
    private transient HashSet blockedActions;

    public View(String persistentId) {
        this(persistentId, null);
    }

    public View(String persistentId, String title) {
        this(persistentId, title, null);
    }

    public View(String persistentId, String title, String tabText) {
        if (persistentId == null) {
            throw new IllegalArgumentException("The 'persistentId' parameter cannot be null.");
        }
        this.persistentId = persistentId;
        this.dragSources = new ArrayList(1);
        this.frameDragSources = new HashSet(1);
        this.dockingListeners = new ArrayList(1);
        this.setContentPane(this.createContentPane());
        this.setTitlebar(this.createTitlebar());
        this.setLayout(this.createLayout());
        this.setContentPaneCheckingEnabled(true);
        if (title == null) {
            title = "";
        }
        this.setTitle(title);
        if (tabText == null) {
            tabText = title;
        }
        this.setTabText(tabText);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                View.this.clearButtonRollovers();
            }
        });
        this.updateUI();
        DockingManager.registerDockable(this);
        this.getActionMap().put(ACTION_TOGGLE_NEXT, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SwingUtility.toggleFocus(1);
            }
        });
        this.getActionMap().put(ACTION_TOGGLE_PREVIOUS, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SwingUtility.toggleFocus(-1);
            }
        });
    }

    private static DockingStrategy createDockingStrategy() {
        return new DefaultDockingStrategy(){

            protected DockingPort createDockingPortImpl(DockingPort base) {
                return new Viewport();
            }
        };
    }

    public static View getInstance(String viewId) {
        Dockable view = DockingManager.getDockable(viewId);
        return view instanceof View ? (View)view : null;
    }

    protected Container createContentPane() {
        return new JPanel();
    }

    protected LayoutManager createLayout() {
        return new ViewLayout();
    }

    protected Titlebar createTitlebar() {
        Titlebar t = new Titlebar();
        t.setView(this);
        return t;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Titlebar getTitlebar() {
        return this.titlepane;
    }

    public DockablePropertySet getDockingProperties() {
        return PropertyManager.getDockablePropertySet(this);
    }

    public ViewProps getViewProperties() {
        return (ViewProps)this.getDockingProperties();
    }

    public void addAction(Action action) {
        if (this.titlepane != null) {
            this.titlepane.addAction(action);
        }
    }

    public void addAction(String action) {
        if (this.titlepane != null) {
            this.titlepane.addAction(action);
        }
    }

    public void removeActions() {
        if (this.titlepane != null) {
            this.titlepane.removeAllActions();
        }
    }

    public void setIcon(Icon icon) {
        if (this.titlepane != null) {
            this.titlepane.setIcon(icon);
        }
    }

    public void setIcon(String imgUri) {
        ImageIcon icon = imgUri == null ? null : ResourceManager.createIcon(imgUri);
        this.setIcon(icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentPane(Container c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("Unable to set a null content pane.");
        }
        if (c == this.titlepane) {
            throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
        }
        if (this.contentPane != null) {
            this.remove(this.contentPane);
        }
        this.contentPane = c;
        if (this.contentPane != null) {
            boolean checkingEnabled = this.isContentPaneCheckingEnabled();
            try {
                this.setContentPaneCheckingEnabled(false);
                this.add(this.contentPane);
            }
            finally {
                this.setContentPaneCheckingEnabled(checkingEnabled);
            }
        }
    }

    protected String getPreferredTitlebarUIName() {
        return this.ui instanceof ViewUI ? ((ViewUI)this.ui).getPreferredTitlebarUI() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitlebar(Titlebar titlebar) {
        if (titlebar != null && titlebar == this.contentPane) {
            throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
        }
        if (this.titlepane != null) {
            this.remove(this.titlepane);
            this.titlepane.setView(null);
            this.dragSources.remove(this.titlepane);
            this.frameDragSources.remove(this.titlepane);
            DockingManager.removeDragListeners(this.titlepane);
        }
        this.titlepane = titlebar;
        if (this.titlepane != null) {
            boolean checkingEnabled = this.isContentPaneCheckingEnabled();
            try {
                this.setContentPaneCheckingEnabled(false);
                this.add(this.titlepane);
            }
            finally {
                this.setContentPaneCheckingEnabled(checkingEnabled);
            }
            this.dragSources.add(this.titlepane);
            this.frameDragSources.add(this.titlepane);
            DockingManager.updateDragListeners(this);
        }
    }

    protected Component getTitlePane() {
        return this.titlepane;
    }

    public void setTitle(String title) {
        if (this.titlepane != null) {
            this.titlepane.setText(title);
        }
    }

    public void setTitle(String title, boolean alsoTabText) {
        this.setTitle(title);
        if (alsoTabText) {
            this.setTabText(title);
        }
    }

    public String getTitle() {
        Titlebar tbar = this.getTitlebar();
        return tbar == null ? null : tbar.getText();
    }

    public void updateUI() {
        this.setUI(PlafManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof Titlebar) {
            ((Titlebar)comp).setView(this);
        }
        if (this.isContentPaneCheckingEnabled()) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void remove(Component comp) {
        if (comp == this.contentPane) {
            super.remove(comp);
        } else {
            this.getContentPane().remove(comp);
        }
    }

    public AbstractButton getActionButton(String actionName) {
        Titlebar tbar = this.getTitlebar();
        return tbar == null ? null : tbar.getActionButton(actionName);
    }

    public Component getComponent() {
        return this;
    }

    public List getDragSources() {
        return this.dragSources;
    }

    public Set getFrameDragSources() {
        return this.frameDragSources;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public boolean isTerritoryBlocked(Dockable dockable, String region) {
        return this.getDockingProperties().isTerritoryBlocked(region);
    }

    public void setTerritoryBlocked(String region, boolean blocked) {
        this.getDockingProperties().setTerritoryBlocked(region, blocked);
    }

    public String getTabText() {
        String txt = this.getDockingProperties().getDockableDesc();
        return txt == null ? this.getTitle() : txt;
    }

    public void setTabText(String tabText) {
        this.getDockingProperties().setDockableDesc(tabText);
    }

    public Icon getTabIcon() {
        return this.getDockingProperties().getTabIcon();
    }

    public void setTabIcon(Icon icon) {
        this.getDockingProperties().setTabIcon(icon);
    }

    public boolean dock(Dockable dockable) {
        return this.dock(dockable, "CENTER");
    }

    public DockingPort getDockingPort() {
        return DockingManager.getDockingPort(this);
    }

    public Dockable getSibling(String region) {
        return DefaultDockingStrategy.getSibling(this, region);
    }

    public Viewport getViewport() {
        DockingPort port = this.getDockingPort();
        return port instanceof Viewport ? (Viewport)port : null;
    }

    public boolean dock(Dockable dockable, String relativeRegion) {
        return DockingManager.dock(dockable, this, relativeRegion);
    }

    public boolean dock(Dockable dockable, String relativeRegion, float ratio) {
        return DockingManager.dock(dockable, this, relativeRegion, ratio);
    }

    public void setActive(boolean b) {
        this.getViewProperties().setActive(b);
    }

    public boolean isActive() {
        return this.getViewProperties().isActive();
    }

    public void setActiveStateLocked(boolean b) {
        this.getViewProperties().setActiveStateLocked(b);
    }

    public boolean isActiveStateLocked() {
        return this.getViewProperties().isActiveStateLocked();
    }

    public boolean isMinimized() {
        return DockingUtility.isMinimized(this);
    }

    public int getMinimizedConstraint() {
        return DockingUtility.getMinimizedConstraint(this);
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingListeners.add(listener);
    }

    public DockingListener[] getDockingListeners() {
        return this.dockingListeners.toArray(new DockingListener[0]);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingListeners.remove(listener);
    }

    public void dockingCanceled(DockingEvent evt) {
    }

    public void dockingComplete(DockingEvent evt) {
        this.setActionBlocked("pin", this.isFloating());
        if (this.titlepane != null) {
            this.titlepane.revalidate();
        }
    }

    public void dragStarted(DockingEvent evt) {
    }

    public void dropStarted(DockingEvent evt) {
    }

    public void undockingComplete(DockingEvent evt) {
        this.clearButtonRollovers();
    }

    public void undockingStarted(DockingEvent evt) {
    }

    private void clearButtonRollovers() {
        if (this.titlepane == null) {
            return;
        }
        Component[] comps = this.titlepane.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Button button;
            Button button2 = button = comps[i] instanceof Button ? (Button)comps[i] : null;
            if (button == null) continue;
            button.getModel().setRollover(false);
        }
    }

    public void setActionBlocked(String actionName, boolean blocked) {
        if (actionName == null) {
            return;
        }
        HashSet actions = this.getBlockedActions();
        if (blocked) {
            actions.add(actionName);
        } else if (actions != null) {
            actions.remove(actionName);
        }
    }

    public boolean isActionBlocked(String actionName) {
        return actionName == null || this.blockedActions == null ? false : this.blockedActions.contains(actionName);
    }

    private HashSet getBlockedActions() {
        if (this.blockedActions == null) {
            this.blockedActions = new HashSet(1);
        }
        return this.blockedActions;
    }

    public boolean isFloating() {
        return DockingUtility.isFloating(this);
    }

    protected String paramString() {
        return "id=" + this.getPersistentId() + "," + super.paramString();
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.contentPaneCheckingEnabled;
    }

    protected void setContentPaneCheckingEnabled(boolean contentPaneCheckingEnabled) {
        this.contentPaneCheckingEnabled = contentPaneCheckingEnabled;
    }

    public void setLayout(LayoutManager manager) {
        if (this.isContentPaneCheckingEnabled()) {
            this.getContentPane().setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    static {
        DockingManager.setDockingStrategy(View.class, VIEW_DOCKING_STRATEGY);
        PropertyManager.setDockablePropertyType(View.class, ViewProps.class);
    }

    protected class ViewLayout
    implements LayoutManager2,
    Serializable {
        protected ViewLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets i = View.this.getInsets();
            Dimension rd = View.this.contentPane != null ? View.this.contentPane.getPreferredSize() : parent.getSize();
            Dimension tpd = View.this.titlepane != null && View.this.titlepane.isVisible() ? View.this.titlepane.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(rd.width, tpd.width) + i.left + i.right, rd.height + tpd.height + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets i = View.this.getInsets();
            Dimension rd = View.this.contentPane != null ? View.this.contentPane.getMinimumSize() : parent.getSize();
            Dimension tpd = View.this.titlepane != null && View.this.titlepane.isVisible() ? View.this.titlepane.getMinimumSize() : new Dimension(0, 0);
            return new Dimension(Math.max(rd.width, tpd.width) + i.left + i.right, rd.height + tpd.height + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            Insets i = View.this.getInsets();
            Dimension tpd = View.this.titlepane != null && View.this.titlepane.isVisible() ? View.this.titlepane.getMaximumSize() : new Dimension(0, 0);
            Dimension rd = View.this.contentPane != null ? View.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom - tpd.height - 1);
            return new Dimension(Math.min(rd.width, tpd.width) + i.left + i.right, rd.height + tpd.height + i.top + i.bottom);
        }

        public void layoutContainer(Container parent) {
            Rectangle b = parent.getBounds();
            Insets i = View.this.getInsets();
            int contentY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (View.this.titlepane != null && View.this.titlepane.isVisible()) {
                Dimension mbd = View.this.titlepane.getPreferredSize();
                View.this.titlepane.setBounds(0, 0, w, mbd.height);
                contentY += mbd.height;
            }
            if (View.this.contentPane != null) {
                View.this.contentPane.setBounds(0, contentY, w, h - contentY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

