/* include/ptlib_config.h.  Generated from ptlib_config.h.in by configure.  */
/*
 * buildopts.h
 *
 * Build options generated by the configure script.
 *
 * Portable Windows Library
 *
 * Copyright (c) 2003 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Portable Windows Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): ______________________________________.
 *
 * $Revision: 33732 $
 * $Author: rjongbloed $
 * $Date: 2015-07-11 22:27:46 +0100 (Sat, 11 Jul 2015) $
 */

#ifndef PTLIB_BUILDOPTS_H
#define PTLIB_BUILDOPTS_H


#define PTLIB_MAJOR 2
#define PTLIB_MINOR 16
#define PTLIB_BUILD 1
#define PTLIB_VERSION "2.16.1"

#define PTLIB_VERSION_INT(major,minor,build) ((major<<24)|(minor<<16)|build)
#define PTLIB_CHECK_VERSION(major,minor,build) \
          (PTLIB_VERSION_INT(PTLIB_MAJOR,PTLIB_MINOR,PTLIB_BUILD) >= PTLIB_VERSION_INT(major,minor,build))


/////////////////////////////////////////////////
//
// host type
//

#define P_LINUX 4.5.1-1-CHAKRA
/* #undef P_FREEBSD */
/* #undef P_OPENBSD */
/* #undef P_NETBSD */
/* #undef P_SOLARIS */
/* #undef P_MACOSX */
/* #undef P_IOS */
/* #undef P_CYGWIN */
/* #undef P_MINGW */
/* #undef P_GNU_HURD */
/* #undef P_ANDROID */
/* #undef P_UNKNOWN_OS */

// Windows API version for compile
#if !defined(_WIN32_WCE) && !defined(WINVER)
/* 	#undef WINVER */
#endif

/* #undef P_VERSION_HELPERS */


/////////////////////////////////////////////////
//
// Language stuff
//

/* #undef P_EXCEPTIONS */
#define P_USE_ASSERTS 1


/////////////////////////////////////////////////
//
// Integer/char types
//

#if defined(_WIN64) && !defined(P_64BIT)
  #define P_64BIT 1
#endif

#ifdef _MSC_VER
  #define SIZEOF_INT 4
  #define HAVE_LONG_LONG_INT 1
  #define HAVE_UNSIGNED_LONG_LONG_INT 1
  #define HAVE_LONG_DOUBLE 1
#else
  #define SIZEOF_INT 4
  #define HAVE_INTTYPES_H 1
  #define HAVE_STDINT_H 1
/*   #undef int8_t */
/*   #undef int16_t */
/*   #undef int32_t */
/*   #undef int64_t */
/*   #undef intptr_t */
/*   #undef uint8_t */
/*   #undef uint16_t */
/*   #undef uint32_t */
/*   #undef uint64_t */
/*   #undef uintptr_t */

  #define HAVE_LONG_LONG_INT 1
  #define HAVE_UNSIGNED_LONG_LONG_INT 1
  #define HAVE_LONG_DOUBLE 1
#endif

#define P_HAS_WCHAR 1
#if P_HAS_WCHAR
  #define P_HAS_WOSTREAM 1
#endif
/* #undef P_HAS_SET_RDBUF */

#define PBYTE_ORDER PLITTLE_ENDIAN
#ifndef PBYTE_ORDER
  #if defined(__BIG_ENDIAN__)
    #define PBYTE_ORDER PLITTLE_ENDIAN
  #else
    #define PBYTE_ORDER PLITTLE_ENDIAN
  #endif
#endif


/////////////////////////////////////////////////
//
// Runtime dynamic link libraries
//

#define P_DYNALINK 1
#define P_PLUGINMGR 1
#define P_PLUGINS 1
#define P_DEFAULT_PLUGIN_DIR "/usr/lib/ptlib-2.16.1"


/////////////////////////////////////////////////
//
// Threads and Unix variants for network stuff
//

#if P_ANDROID

  // configure is not run in Android/Visual Studio, so hard code it
  #define SIZEOF_INT 4
  #define HAVE_LONG_LONG_INT 1
  #define HAVE_UNSIGNED_LONG_LONG_INT 1
  #define HAVE_LONG_DOUBLE 1

  #define HAVE_LIMITS_H 1
  #define HAVE_UNISTD_H 1
  #define HAVE_ALLOCA_H 1
  #define HAVE_SYS_TYPES_H 1
  #define HAVE_DIRENT_H 1
  #define HAVE_SYS_STAT_H 1
  #define STDC_HEADERS 1
  #define HAVE_STDLIB_H 1
  #define HAVE_STRING_H 1
  #define HAVE_STRINGS_H 1
  #define HAVE_SIGNAL_H 1
  #define HAVE_FCNTL_H 1
  #define HAVE_TERMIOS_H 1
  #define HAVE_SYS_IOCTL_H 1
  #define HAVE_SYS_TIME_H 1
  #define HAVE_SYS_SOCKET_H 1
  #define HAVE_NETDB_H 1
  #define HAVE_NETINET_IN_H 1
  #define HAVE_NETINET_TCP_H 1
  #define HAVE_ARPA_INET_H 1
  #define HAVE_NET_IF_H 1
  #define HAVE_LINUX_ERRQUEUE_H 1
  #define HAVE_NETINET_IF_ETHER_H 1

  #define P_PTHREADS 1
  #define P_HAS_SEMAPHORES 1
  #define P_ATOMICITY_BUILTIN 1
  #define P_HAS_RECURSIVE_MUTEX 1
  #define P_HAS_POLL 1
  #define P_HAS_RECVMSG 1
  #define P_HAS_RECVMSG_MSG_ERRQUEUE 1
  #define P_HAS_RECVMSG_IP_RECVERR 1
  #define P_HAS_NETLINK 1
  #define P_SETPGRP_NOPARM 1

#else // P_ANDROID

  #define HAVE_LIMITS_H 1
  #define HAVE_UNISTD_H 1
  #define HAVE_ALLOCA_H 1
  #define HAVE_SYS_TYPES_H 1
  #define HAVE_DIRENT_H 1
/*   #undef HAVE_SYS_NDIR_H */
/*   #undef HAVE_SYS_DIR_H */
/*   #undef HAVE_NDIR_H */
  #define HAVE_SYS_STAT_H 1
  #define STDC_HEADERS 1
  #define HAVE_STDLIB_H 1
  #define HAVE_STRING_H 1
  #define HAVE_STRINGS_H 1
  #define HAVE_SIGNAL_H 1
  #define HAVE_FCNTL_H 1
  #define HAVE_TERMIOS_H 1
  #define HAVE_SYS_TERMIOS_H 1
/*   #undef HAVE_IOCTL_H */
  #define HAVE_SYS_IOCTL_H 1
  #define HAVE_SYS_TIME_H 1
  #define HAVE_SYS_SOCKET_H 1
  #define HAVE_NETDB_H 1
  #define HAVE_NETINET_IN_H 1
  #define HAVE_NETINET_TCP_H 1
  #define HAVE_ARPA_INET_H 1
  #define HAVE_NET_IF_H 1
  #define HAVE_IFADDRS_H 1
/*   #undef HAVE_SYS_SOCKIO_H */
  #define HAVE_SYS_SYSCTL_H 1
  #define HAVE_LINUX_ERRQUEUE_H 1
/*   #undef HAVE_NET_IF_DL_H */
/*   #undef HAVE_NET_IF_TYPES_H */
  #define HAVE_NETINET_IF_ETHER_H 1

  #define P_PTHREADS 1
/*   #undef P_NO_PTHREAD_KILL */
  #define P_HAS_SEMAPHORES 1
/*   #undef P_STD_ATOMIC */
  #define P_ATOMICITY_BUILTIN 1
/*   #undef P_ATOMICITY_HEADER */
/*   #undef P_ATOMICITY_NAMESPACE */
  #define P_HAS_RECURSIVE_MUTEX 1
  #define P_HAS_POLL 1
  #define P_HAS_RECVMSG 1
  #define P_HAS_RECVMSG_MSG_ERRQUEUE 1
  #define P_HAS_RECVMSG_IP_RECVERR 1
/*   #undef P_HAS_RT_MSGHDR */
  #define P_HAS_NETLINK 1
  #define P_SETPGRP_NOPARM 1

/*   #undef P_GNU_ALLOCATOR */
  #define P_HAS_MALLOC_INFO 1
/*   #undef P_HAS_NAMED_SEMAPHORES */
  #define P_PTHREADS_XPG6 1
  #define P_HAS_SEMAPHORES_XPG6 1
  #define P_HAS_AIO 1
  #define P_HAS_POSIX_READDIR_R 3
/*   #undef P_HAS_UPAD128_T */
  #define P_HAS_INET_NTOP 1
  #define P_HAS_IPV6_ADD_MEMBERSHIP 1
/*   #undef P_GETPWUID_R4 */
  #define P_GETPWUID_R5 1
/*   #undef P_GETPWNAM_R4 */
  #define P_GETPWNAM_R5 1
/*   #undef P_GETGRGID_R4 */
  #define P_GETGRGID_R5 1
/*   #undef P_GETGRNAM_R4 */
  #define P_GETGRNAM_R5 1
  #define P_GETHOSTBYNAME_R 1

  #define P_HAS_BACKTRACE 1
  #define P_HAS_DEMANGLE 1
/*   #undef P_PROFILING */

#endif //P_ANDROID

#ifndef _WIN32_WCE
  #define P_HAS_IPV6 1
/*   #undef P_GQOS */
/*   #undef P_QWAVE */
/*   #undef P_QWAVE_DSCP */
#endif //  _WIN32_WCE


/////////////////////////////////////////////////
//
// various platform specific features
//

/* #undef P_LPIA */
#define USE_SYSTEM_SWAB /**/
/* #undef P_SHM_VIDEO */


/////////////////////////////////////////////////
//
// various non-platform specific features
//

/* #undef PMEMORY_CHECK */

#define P_AUDIO 1
#define P_VIDEO 1

#define P_TIMERS 1
#define P_REGEX 1
#define P_TTS 1
#define P_ASN 1
#define P_PIPECHAN 1
#define P_DTMF 1
#define P_WAVFILE 1
#define P_SOCKS 1
#define P_FTP 1
#define P_TELNET 1
#define P_CLI 1
#define P_CURSES 1
/* #undef P_ODBC */
/* #undef P_ODBC_DEFINES_WINDOWS_TYPES */
#define P_SERIAL 1
#define P_POP3SMTP 1
#define P_CONFIG_FILE 1
#define P_CYPHER 1
#define P_VARTYPE 1
#define P_GUID 1
#if P_GUID
  #define P_SPOOLDIR 1
#endif
#define P_SYSTEMLOG 1
#define P_CHANNEL_UTILS 1
#define P_NETWORKING 1

#if _WIN32 || P_PIPECHAN
  #define P_REMCONN 1
#endif

#if P_ASN
  #define P_SNMP 1
#endif

#define P_NAT 1
#if P_NAT
  #define P_STUN 1
  #if P_STUN
    #define P_STUNSRVR 1
  #endif
#endif

#define P_URL 1
#ifdef P_URL
  #define P_VCARD 1
  #define P_HTTP 1
  #if P_HTTP
    #if P_CONFIG_FILE
      #define P_HTTPFORMS 1
      #if P_HTTPFORMS
        #define P_HTTPSVC 1
      #endif
    #endif
    #define P_SSDP 1
  #endif
#endif

#define P_VIDFILE 1
#define P_FFVDEV 1
/* #undef P_PORTAUDIO */
/* #undef P_PORTMIXER */

/////////////////////////////////////////////////
//
// PCAP support
//

#define P_PCAP 1
/* #undef P_PCAP_PCAP_H */
/* #undef P_PCAP_WIN64 */
/* #undef P_PCAP_WIN32 */

#if (defined(P_PCAP_WIN64) &&  defined(P_64BIT)) || \
    (defined(P_PCAP_WIN32) && !defined(P_64BIT))
  #define P_PCAP 1
#endif

#if defined(_MSC_VER) && defined(P_PCAP)
  #pragma include_alias(<pcap/pcap.h>, <@PCAP_DIR@/include/pcap/pcap.h>)
  #pragma include_alias(<pcap/bpf.h>, <@PCAP_DIR@/include/pcap/bpf.h>)
  #pragma include_alias(<pcap-stdinc.h>, <@PCAP_DIR@/include/pcap-stdinc.h>)

  #define P_PCAP_PCAP_H 1

  #if defined(P_64BIT)
    #define P_PCAP_LIBRARY1 "@PCAP_DIR@/lib/x64/Packet.lib"
    #define P_PCAP_LIBRARY2 "@PCAP_DIR@/lib/x64/wpcap.lib"
  #else
    #define P_PCAP_LIBRARY1 "@PCAP_DIR@/lib/Packet.lib"
    #define P_PCAP_LIBRARY2 "@PCAP_DIR@/lib/wpcap.lib"
  #endif
#endif


/////////////////////////////////////////////////
//
// OpenSSL library for secure sockets layer
//

#define P_OPENSSL 1
/* #undef P_SSL_WIN64 */
/* #undef P_SSL_WIN32 */
/* #undef P_SSL_WINCE */

#if (defined(P_SSL_WIN64) &&  defined(P_64BIT)                        ) || \
    (defined(P_SSL_WIN32) && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    (defined(P_SSL_WINCE)                      &&  defined(_WIN32_WCE)) || \
    P_OPENSSL
  #define P_SSL 1
#endif

#if P_SSL
  #define P_SSL_AES 1
  #define P_SSL_SRTP 1
  #define P_SSL_USE_CONST 1
#endif

#if defined(_MSC_VER) && P_SSL

  #if P_64BIT

    #define P_SSL_USE_CONST 1

    #define P_SSL_INCLUDE(inc) include_alias(<inc>, <@SSL_WIN64_DIR@/include/inc>)

    #ifdef _DEBUG
      #define P_SSL_LIB1 "@SSL_WIN64_DIR@/lib/VC/libeay32MDd.lib"
      #define P_SSL_LIB2 "@SSL_WIN64_DIR@/lib/VC/ssleay32MDd.lib"
    #else
      #define P_SSL_LIB1 "@SSL_WIN64_DIR@/lib/VC/libeay32MD.lib"
      #define P_SSL_LIB2 "@SSL_WIN64_DIR@/lib/VC/ssleay32MD.lib"
    #endif

  #elif P_SSL_WIN32==2

    #define P_SSL_USE_CONST 1

    #define P_SSL_INCLUDE(inc) include_alias(<inc>, <@SSL_WIN32_DIR@/include/inc>)

    #ifdef _DEBUG
      #define P_SSL_LIB1 "@SSL_WIN32_DIR@/lib/VC/libeay32MTd.lib"
      #define P_SSL_LIB2 "@SSL_WIN32_DIR@/lib/VC/ssleay32MTd.lib"
    #else
      #define P_SSL_LIB1 "@SSL_WIN32_DIR@/lib/VC/libeay32MT.lib"
      #define P_SSL_LIB2 "@SSL_WIN32_DIR@/lib/VC/ssleay32MT.lib"
    #endif

  #else

    #define P_SSL_INCLUDE(inc) include_alias(<inc>, <@SSL_WIN32_DIR@/inc32/inc>)

    #ifdef _DEBUG
      #define P_SSL_LIBDIR "out32.dbg"
    #else
      #define P_SSL_LIBDIR "out32"
    #endif

    #define P_SSL_LIB1 "@SSL_WIN32_DIR@/" P_SSL_LIBDIR "/ssleay32.lib"
    #define P_SSL_LIB2 "@SSL_WIN32_DIR@/" P_SSL_LIBDIR "/libeay32.lib"

  #endif

  #pragma P_SSL_INCLUDE(openssl/ssl.h)
  #pragma P_SSL_INCLUDE(openssl/safestack.h)
  #pragma P_SSL_INCLUDE(openssl/stack.h)
  #pragma P_SSL_INCLUDE(openssl/crypto.h)
  #pragma P_SSL_INCLUDE(openssl/opensslv.h)
  #pragma P_SSL_INCLUDE(openssl/lhash.h)
  #pragma P_SSL_INCLUDE(openssl/buffer.h)
  #pragma P_SSL_INCLUDE(openssl/bio.h)
  #pragma P_SSL_INCLUDE(openssl/pem.h)
  #pragma P_SSL_INCLUDE(openssl/evp.h)
  #pragma P_SSL_INCLUDE(openssl/md2.h)
  #pragma P_SSL_INCLUDE(openssl/opensslconf.h)
  #pragma P_SSL_INCLUDE(openssl/md5.h)
  #pragma P_SSL_INCLUDE(openssl/sha.h)
  #pragma P_SSL_INCLUDE(openssl/ripemd.h)
  #pragma P_SSL_INCLUDE(openssl/des.h)
  #pragma P_SSL_INCLUDE(openssl/e_os2.h)
  #pragma P_SSL_INCLUDE(openssl/rc4.h)
  #pragma P_SSL_INCLUDE(openssl/rc2.h)
  #pragma P_SSL_INCLUDE(openssl/rc5.h)
  #pragma P_SSL_INCLUDE(openssl/blowfish.h)
  #pragma P_SSL_INCLUDE(openssl/cast.h)
  #pragma P_SSL_INCLUDE(openssl/idea.h)
  #pragma P_SSL_INCLUDE(openssl/mdc2.h)
  #pragma P_SSL_INCLUDE(openssl/rsa.h)
  #pragma P_SSL_INCLUDE(openssl/bn.h)
  #pragma P_SSL_INCLUDE(openssl/dsa.h)
  #pragma P_SSL_INCLUDE(openssl/dh.h)
  #pragma P_SSL_INCLUDE(openssl/objects.h)
  #pragma P_SSL_INCLUDE(openssl/asn1.h)
  #pragma P_SSL_INCLUDE(openssl/x509.h)
  #pragma P_SSL_INCLUDE(openssl/x509_vfy.h)
  #pragma P_SSL_INCLUDE(openssl/x509v3.h)
  #pragma P_SSL_INCLUDE(openssl/conf.h)
  #pragma P_SSL_INCLUDE(openssl/pkcs7.h)
  #pragma P_SSL_INCLUDE(openssl/pem2.h)
  #pragma P_SSL_INCLUDE(openssl/ssl2.h)
  #pragma P_SSL_INCLUDE(openssl/ssl3.h)
  #pragma P_SSL_INCLUDE(openssl/tls1.h)
  #pragma P_SSL_INCLUDE(openssl/ssl23.h)
  #pragma P_SSL_INCLUDE(openssl/err.h)
  #pragma P_SSL_INCLUDE(openssl/rand.h)
  #pragma P_SSL_INCLUDE(openssl/symhacks.h)
  #pragma P_SSL_INCLUDE(openssl/comp.h)
  #pragma P_SSL_INCLUDE(openssl/ossl_typ.h)
  #pragma P_SSL_INCLUDE(openssl/md4.h)
  #pragma P_SSL_INCLUDE(openssl/des_old.h)
  #pragma P_SSL_INCLUDE(openssl/ui_compat.h)
  #pragma P_SSL_INCLUDE(openssl/ui.h)
  #pragma P_SSL_INCLUDE(openssl/aes.h)
  #pragma P_SSL_INCLUDE(openssl/obj_mac.h)
  #pragma P_SSL_INCLUDE(openssl/kssl.h)
  #pragma P_SSL_INCLUDE(openssl/ec.h)
  #pragma P_SSL_INCLUDE(openssl/ecdsa.h)
  #pragma P_SSL_INCLUDE(openssl/ecdh.h)
  #pragma P_SSL_INCLUDE(openssl/pq_compat.h)
  #pragma P_SSL_INCLUDE(openssl/dtls1.h)
  #pragma P_SSL_INCLUDE(openssl/pqueue.h)
  #pragma P_SSL_INCLUDE(openssl/hmac.h)
  #pragma P_SSL_INCLUDE(openssl/srtp.h)
  #pragma P_SSL_INCLUDE(openssl/aes.h)

#endif

/* #undef P_d2i_DHparams_bio_OLD */


/////////////////////////////////////////////////
//
// EXPAT library for XML parsing
//

#define P_EXPAT 1
/* #undef P_EXPAT_BUILD */
/* #undef P_EXPAT_WIN32 */
/* #undef P_EXPAT_WIN64 */
/* #undef P_EXPAT_LIBRARY_W32_DEBUG */
/* #undef P_EXPAT_LIBRARY_W32_RELEASE */
/* #undef P_EXPAT_LIBRARY_WM5_DEBUG */
/* #undef P_EXPAT_LIBRARY_WM5_RELEASE */
/* #undef P_EXPAT_LIBRARY_WM6_DEBUG */
/* #undef P_EXPAT_LIBRARY_WM6_RELEASE */
/* #undef P_EXPAT_LIBRARY_W64_DEBUG */
/* #undef P_EXPAT_LIBRARY_W64_RELEASE */

#if (defined(P_EXPAT_WIN64)                 &&  defined(P_64BIT)                        ) || \
    (defined(P_EXPAT_WIN32)                 && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    (defined(P_EXPAT_WINCE)                                      &&  defined(_WIN32_WCE)) || \
    ((defined(P_EXPAT_LIBRARY_W64_DEBUG)                                                  || \
      defined(P_EXPAT_LIBRARY_W64_RELEASE)) &&  defined(P_64BIT))                         || \
    ((defined(P_EXPAT_LIBRARY_W32_DEBUG)                                                  || \
      defined(P_EXPAT_LIBRARY_W32_RELEASE)) && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    ((defined(P_EXPAT_LIBRARY_WM5_DEBUG)                                                  || \
      defined(P_EXPAT_LIBRARY_WM5_RELEASE))                      &&  defined(_WIN32_WCE)) || \
    ((defined(P_EXPAT_LIBRARY_WM6_DEBUG)                                                  || \
      defined(P_EXPAT_LIBRARY_WM6_RELEASE))                      &&  defined(_WIN32_WCE))
  #define P_EXPAT 1
#endif

#if defined(_MSC_VER) && P_EXPAT

  #if P_EXPAT_BUILD
    #pragma include_alias(<expat.h>, <@EXPAT_BUILD_DIR@/lib/expat.h>)
  #else
    #pragma include_alias(<expat.h>, <@EXPAT_WIN32_DIR@/Source/lib/expat.h>)
  #endif

  #if P_64BIT
    #if defined(_DEBUG)
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_W64_DEBUG
    #else
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_W64_RELEASE
    #endif
  #elif defined(P_EXPAT_WIN32)
/*     #undef P_EXPAT_LIBRARY */
  #elif !defined(_WIN32_WCE)
    #if defined(_DEBUG)
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_W32_DEBUG
    #else
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_W32_RELEASE
    #endif
  #elif _WIN32_WCE < 0x502
    #if defined(_DEBUG)
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_WM5_DEBUG
    #else
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_WM5_RELEASE
    #endif
  #else
    #if defined(_DEBUG)
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_WM6_DEBUG
    #else
      #define P_EXPAT_LIBRARY P_EXPAT_LIBRARY_WM6_RELEASE
    #endif
  #endif
#endif

#ifdef P_EXPAT
  #if P_TTS
    #define P_VXML 1
  #endif
  #define P_JABBER 1
  #define P_XMLRPC 1
  #define P_SOAP 1
#endif


/////////////////////////////////////////////////
//
// Script interpreter
//

#if P_VARTYPE
	#define P_SCRIPTS 1
#endif


/////////////////////////////////////////////////
//
// Lua interpreter
//

#if P_SCRIPTS
/*   #undef P_LUA */
/*   #undef P_LUA_WIN64 */
/*   #undef P_LUA_WIN32 */
/*   #undef P_LUA_WINCE */
#endif

#if (defined(P_LUA_WIN64) &&  defined(P_64BIT)                        ) || \
    (defined(P_LUA_WIN32) && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    (defined(P_LUA_WINCE)                      &&  defined(_WIN32_WCE))
  #define P_LUA 1
#endif

#if defined(_MSC_VER) && defined(P_LUA)
  #pragma include_alias(<lua.hpp>,   <@LUA_DIR@/include/lua.hpp>)
  #pragma include_alias(<lua.h>,     <@LUA_DIR@/include/lua.h>)
  #pragma include_alias(<lauxlib.h>, <@LUA_DIR@/include/lauxlib.h>)
  #pragma include_alias(<lualib.h>,  <@LUA_DIR@/include/lualib.h>)
  
  #define P_LUA_LIBRARY "@LUA_DIR@/lib/lua5.1.lib"
#endif


/////////////////////////////////////////////////
//
// V8 Javascript interpreter
//

#if P_SCRIPTS
/*   #undef P_V8 */
/*   #undef P_V8_WIN64 */
/*   #undef P_V8_WIN32 */
/*  #undef P_V8_API */
#endif

#if (defined(P_V8_WIN64) &&  defined(P_64BIT))
  #define P_V8 1
  #define P_V8_API P_V8_WIN64
#endif
#if (defined(P_V8_WIN32) && !defined(P_64BIT))
  #define P_V8 1
  #define P_V8_API P_V8_WIN32
#endif

#if defined(_MSC_VER) && defined(P_V8)
  #pragma include_alias(<v8.h>, <@V8_DIR@/include/v8.h>)

/*   #undef P_V8_DEBUG_LIB */
/*   #undef P_V8_RELEASE_LIB */
#endif


/////////////////////////////////////////////////
//
// Cyrus SASL
//

#define P_SASL 2
/* #undef P_SASL_WIN64 */
/* #undef P_SASL_WIN32 */
/* #undef P_SASL_WINCE */
#define P_HAS_SASL_SASL_H 1

#if (defined(P_SASL_WIN64) &&  defined(P_64BIT)                        ) || \
    (defined(P_SASL_WIN32) && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    (defined(P_SASL_WINCE)                      &&  defined(_WIN32_WCE))
  #define P_SASL 2
#endif

#if defined(_MSC_VER) && P_SASL

  #pragma include_alias(<sasl/sasl.h>, <@SASL_DIR@/include/sasl.h>)

  #define P_SASL_LIBRARY "@SASL_DIR@/lib/libsasl.lib"
  #define P_HAS_SASL_SASL_H 1

#endif



/////////////////////////////////////////////////
//
// OpenLDAP
//

#define P_OPENLDAP 1
/* #undef P_LDAP_WIN64 */
/* #undef P_LDAP_WIN32 */
/* #undef P_LDAP_WINCE */

#if (defined(P_LDAP_WIN64) &&  defined(P_64BIT)                        ) || \
    (defined(P_LDAP_WIN32) && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    (defined(P_LDAP_WINCE)                      &&  defined(_WIN32_WCE)) || \
             P_OPENLDAP
  #define P_LDAP 1
#endif

#if defined(_MSC_VER) && P_LDAP

  #pragma include_alias(<ldap.h>,          <@LDAP_DIR@/include/ldap.h>)
  #pragma include_alias(<lber.h>,          <@LDAP_DIR@/include/lber.h>)
  #pragma include_alias(<lber_types.h>,    <@LDAP_DIR@/include/lber_types.h>)
  #pragma include_alias(<ldap_features.h>, <@LDAP_DIR@/include/ldap_features.h>)
  #pragma include_alias(<ldap_cdefs.h>,    <@LDAP_DIR@/include/ldap_cdefs.h>)

  #ifdef _DEBUG
    #define P_LDAP_LIBRARY "@LDAP_DIR@/DLLDebug/openldapd.lib"
  #else
    #define P_LDAP_LIBRARY "@LDAP_DIR@/DLLRelease/openldap.lib"
  #endif

#endif


/////////////////////////////////////////////////
//
// DNS resolver
//

#ifndef _WIN32_WCE
  #define P_DNS_RESOLVER 1
  #define P_HAS_RES_NINIT 1
#endif


/////////////////////////////////////////////////
//
// Active Template Library (Windows only)
// There is no actual code support in PTLib for this, but the symbols is required
// for other dependencies
//

/* #undef P_ATL */


/////////////////////////////////////////////////
//
// SAPI speech API (Windows only)
//

#ifndef _WIN32_WCE
/*   #undef P_SAPI */
#endif


/////////////////////////////////////////////////
//
// SDL toolkit
//

#if P_VIDEO
  #define P_SDL 1
/*   #undef P_SDL_WIN64 */
/*   #undef P_SDL_WIN32 */
#endif

#if defined(P_SDL_WIN64) && defined(P_64BIT)
  #define P_SDL 1
#elif defined(P_SDL_WIN32) && !defined(P_64BIT)
  #define P_SDL 1
#endif

#if defined(_MSC_VER) && P_SDL
  #define P_SDL_INCLUDE(inc) include_alias(<inc>, <@SDL_DIR@/include/inc>)
  #pragma P_SDL_INCLUDE(SDL.h)
  #pragma P_SDL_INCLUDE(SDL_main.h)

  #ifdef P_64BIT
    #define P_SDL_LIBRARY "@SDL_DIR@/lib/x64/SDL.lib"
  #else
    #define P_SDL_LIBRARY "@SDL_DIR@/lib/x86/SDL.lib"
  #endif

#endif



/////////////////////////////////////////////////
//
// APP Share Input 
//

#if P_VIDEO
  #ifndef _WIN32_WCE
/*     #undef P_APPSHARE */
  #endif
#endif


/////////////////////////////////////////////////
//
// libjpeg support
//

#define P_LIBJPEG 1
/* #undef P_LIBJPEG_WIN32 */
/* #undef P_LIBJPEG_WIN64 */

#if (defined(P_LIBJPEG_WIN64) &&  defined(P_64BIT)                        ) || \
    (defined(P_LIBJPEG_WIN32) && !defined(P_64BIT) && !defined(_WIN32_WCE))
  #define P_LIBJPEG 1
#endif

#if P_LIBJPEG
  #define P_JPEG_DECODER 1
#else
  #define P_TINY_JPEG 1
  #if P_TINY_JPEG
    #define P_JPEG_DECODER 1
  #endif
#endif


#if defined(_MSC_VER) && P_LIBJPEG
  #pragma include_alias(<jpeglib.h>, <@LIBJPEG_DIR@/include/jpeglib.h>)

  #pragma include_alias("jconfig.h", "@LIBJPEG_DIR@/include/jconfig.h")
  #pragma include_alias("jmorecfg.h", "@LIBJPEG_DIR@/include/jmorecfg.h")

/*   #undef P_LIBJPEG_LIBRARY */
  #ifndef P_LIBJPEG_LIBRARY
    #if defined(P_64BIT)
      #define P_LIBJPEG_BUILD "x64/"
    #else
      #define P_LIBJPEG_BUILD "win32/"
    #endif

    #ifdef _DEBUG
      #define P_LIBJPEG_LIBRARY "@LIBJPEG_DIR@/lib/" P_LIBJPEG_BUILD "libjpeg_d.lib"
    #else
      #define P_LIBJPEG_LIBRARY "@LIBJPEG_DIR@/lib/" P_LIBJPEG_BUILD "libjpeg.lib"
    #endif
  #endif
#endif


/////////////////////////////////////////////////
//
// DirectSound Support (Windows only)
//

/* #undef P_DIRECTSOUND_WINCE */
#if P_AUDIO && !defined(_WIN32_WCE) && !defined(P_DIRECTSOUND_WINCE) && defined(_MSC_VER)
/*   #undef P_DIRECTSOUND */
/*   #undef P_DIRECTSOUND_DXERR_H */
/*   #undef P_DIRECTSOUND_LIB */
#endif


/////////////////////////////////////////////////
//
// DirectShow Support (Windows only)
//

#if P_VIDEO

  #if defined(_MSC_VER)

    #ifdef _WIN32_WCE

/*       #undef P_VFW_CAPTURE */
      #define P_DIRECTSHOW 1

    #else // _WIN32_WCE

      #define P_VFW_CAPTURE 1
/*       #undef P_DIRECTSHOW */
       #if WINVER < 0x502
/*           #undef P_DIRECTSHOW_QEDIT_H */
       #endif

    #endif // _WIN32_WCE

  #else /* defined(_MSC_VER)*/

/*     #undef P_DIRECTSHOW */
/*     #undef P_VFW_CAPTURE */

  #endif /* defined(_MSC_VER)*/
#endif // P_VIDEO


/////////////////////////////////////////////////
//
// Media library for video conversions.
//

/* #undef P_MEDIALIB */
/* #undef P_IPP */

#if defined(_MSC_VER) && defined(P_IPP)
  #define P_IPP_INCLUDE(inc) include_alias(<inc>, <@IPP_DIR@/include/inc>)
  #pragma P_IPP_INCLUDE(ippcc.h)
#endif


/////////////////////////////////////////////////
//
// GStreamer
//

#define P_GSTREAMER 1
/* #undef P_GSTREAMER_WIN64 */
/* #undef P_GSTREAMER_WIN32 */
/* #undef P_GSTREAMER_WINCE */
#define P_GSTREAMER_1_0_API 1

#if (defined(P_GSTREAMER_WIN64) &&  defined(P_64BIT)                        ) || \
    (defined(P_GSTREAMER_WIN32) && !defined(P_64BIT) && !defined(_WIN32_WCE)) || \
    (defined(P_GSTREAMER_WINCE)                      &&  defined(_WIN32_WCE))
  #define P_GSTREAMER 1
#endif

#if defined(_MSC_VER) && defined(P_GSTREAMER)
  #if P_GSTREAMER_1_0_API
    #define P_GSTREAMER_VERSTR       "1.0"
    #define P_GSTREAMER_DIRSTR       "@GSTREAMER1_DIR@"
    #define P_GSTREAMER_INCLUDE(inc) include_alias(<inc>,             <@GSTREAMER1_DIR@/include/gstreamer-1.0/inc>)
    #define P_GLIB_INCLUDE(inc)      include_alias(<inc>,             <@GSTREAMER1_DIR@/include/glib-2.0/inc>)
    #define P_GIO_INCLUDE(inc)       include_alias(<inc>,             <@GSTREAMER1_DIR@/include/gio-win32-2.0/inc>)
    #define P_LIBXML_INCLUDE(inc)    include_alias(<inc>,             <@GSTREAMER1_DIR@/include/libxml2/inc>)
    #pragma                          include_alias(<gst/gstconfig.h>, <@GSTREAMER1_DIR@/lib/gstreamer-1.0/include/gst/gstconfig.h>)
    #pragma                          include_alias(<glibconfig.h>,    <@GSTREAMER1_DIR@/lib/glib-2.0/include/glibconfig.h>)
  #else
    #define P_GSTREAMER_VERSTR       "0.10"
    #define P_GSTREAMER_DIRSTR       "@GSTREAMER_DIR@"
    #define P_GSTREAMER_INCLUDE(inc) include_alias(<inc>,             <@GSTREAMER_DIR@/include/gstreamer-0.10/inc>)
    #define P_GLIB_INCLUDE(inc)      include_alias(<inc>,             <@GSTREAMER_DIR@/include/glib-2.0/inc>)
    #define P_LIBXML_INCLUDE(inc)    include_alias(<inc>,             <@GSTREAMER_DIR@/include/libxml2/inc>)
    #pragma                          include_alias(<gst/gstconfig.h>, <@GSTREAMER_DIR@/include/gstreamer-0.10/gst/gstconfig.h>)
    #pragma                          include_alias(<glibconfig.h>,    <@GSTREAMER_DIR@/lib/glib-2.0/include/glibconfig.h>)
    #pragma                          include_alias(<iconv.h>,         <@GSTREAMER_DIR@/include/iconv.h>)
  #endif

  #pragma P_GSTREAMER_INCLUDE(gst/gst.h)
  #pragma P_GSTREAMER_INCLUDE(gst/glib-compat.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstenumtypes.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstversion.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstatomicqueue.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstbin.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstbuffer.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstbufferlist.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstcaps.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstchildproxy.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstclock.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstdatetime.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstdebugutils.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstelement.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsterror.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstevent.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstghostpad.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstindex.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstindexfactory.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstinfo.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstinterface.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstiterator.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstmarshal.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstmessage.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstminiobject.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstobject.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstpad.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstparamspecs.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstpipeline.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstplugin.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstpoll.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstpreset.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstquery.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstregistry.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstsegment.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gststructure.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstsystemclock.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttaglist.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttagsetter.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttask.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttaskpool.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttrace.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttypefind.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttypefindfactory.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsturi.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstutils.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstvalue.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstxml.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstparse.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstcompat.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstformat.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstpadtemplate.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstbus.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstelementfactory.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstpluginfeature.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstmacros.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstcontrolbinding.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstcontrolsource.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstallocator.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstmemory.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstmeta.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstcapsfeatures.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstsample.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttoc.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstcontext.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstdevice.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstbufferpool.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstdevicemonitor.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstdeviceprovider.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstdeviceproviderfactory.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstelementmetadata.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gstprotection.h)
  #pragma P_GSTREAMER_INCLUDE(gst/gsttocsetter.h)
  #pragma P_GSTREAMER_INCLUDE(gst/app/gstappsrc.h)
  #pragma P_GSTREAMER_INCLUDE(gst/app/gstappsink.h)
  #pragma P_GSTREAMER_INCLUDE(gst/app/gstappbuffer.h)
  #pragma P_GSTREAMER_INCLUDE(gst/base/gstpushsrc.h)
  #pragma P_GSTREAMER_INCLUDE(gst/base/gstbasesrc.h)
  #pragma P_GSTREAMER_INCLUDE(gst/base/gstbasesink.h)

  #pragma P_GLIB_INCLUDE(glib.h)
  #pragma P_GLIB_INCLUDE(gmodule.h)
  #pragma P_GLIB_INCLUDE(glib-object.h)
  #pragma P_GLIB_INCLUDE(glib/galloca.h)
  #pragma P_GLIB_INCLUDE(glib/garray.h)
  #pragma P_GLIB_INCLUDE(glib/gasyncqueue.h)
  #pragma P_GLIB_INCLUDE(glib/gatomic.h)
  #pragma P_GLIB_INCLUDE(glib/gbacktrace.h)
  #pragma P_GLIB_INCLUDE(glib/gbase64.h)
  #pragma P_GLIB_INCLUDE(glib/gbitlock.h)
  #pragma P_GLIB_INCLUDE(glib/gbookmarkfile.h)
  #pragma P_GLIB_INCLUDE(glib/gcache.h)
  #pragma P_GLIB_INCLUDE(glib/gchecksum.h)
  #pragma P_GLIB_INCLUDE(glib/gcompletion.h)
  #pragma P_GLIB_INCLUDE(glib/gconvert.h)
  #pragma P_GLIB_INCLUDE(glib/gdataset.h)
  #pragma P_GLIB_INCLUDE(glib/gdate.h)
  #pragma P_GLIB_INCLUDE(glib/gdir.h)
  #pragma P_GLIB_INCLUDE(glib/gerror.h)
  #pragma P_GLIB_INCLUDE(glib/gfileutils.h)
  #pragma P_GLIB_INCLUDE(glib/ghash.h)
  #pragma P_GLIB_INCLUDE(glib/ghook.h)
  #pragma P_GLIB_INCLUDE(glib/ghostutils.h)
  #pragma P_GLIB_INCLUDE(glib/giochannel.h)
  #pragma P_GLIB_INCLUDE(glib/gkeyfile.h)
  #pragma P_GLIB_INCLUDE(glib/glist.h)
  #pragma P_GLIB_INCLUDE(glib/gmacros.h)
  #pragma P_GLIB_INCLUDE(glib/gmain.h)
  #pragma P_GLIB_INCLUDE(glib/gmappedfile.h)
  #pragma P_GLIB_INCLUDE(glib/gmarkup.h)
  #pragma P_GLIB_INCLUDE(glib/gmem.h)
  #pragma P_GLIB_INCLUDE(glib/gmessages.h)
  #pragma P_GLIB_INCLUDE(glib/gnode.h)
  #pragma P_GLIB_INCLUDE(glib/goption.h)
  #pragma P_GLIB_INCLUDE(glib/gpattern.h)
  #pragma P_GLIB_INCLUDE(glib/gpoll.h)
  #pragma P_GLIB_INCLUDE(glib/gprimes.h)
  #pragma P_GLIB_INCLUDE(glib/gqsort.h)
  #pragma P_GLIB_INCLUDE(glib/gquark.h)
  #pragma P_GLIB_INCLUDE(glib/gqueue.h)
  #pragma P_GLIB_INCLUDE(glib/grand.h)
  #pragma P_GLIB_INCLUDE(glib/grel.h)
  #pragma P_GLIB_INCLUDE(glib/gregex.h)
  #pragma P_GLIB_INCLUDE(glib/gscanner.h)
  #pragma P_GLIB_INCLUDE(glib/gsequence.h)
  #pragma P_GLIB_INCLUDE(glib/gshell.h)
  #pragma P_GLIB_INCLUDE(glib/gslice.h)
  #pragma P_GLIB_INCLUDE(glib/gslist.h)
  #pragma P_GLIB_INCLUDE(glib/gspawn.h)
  #pragma P_GLIB_INCLUDE(glib/gstrfuncs.h)
  #pragma P_GLIB_INCLUDE(glib/gstring.h)
  #pragma P_GLIB_INCLUDE(glib/gtestutils.h)
  #pragma P_GLIB_INCLUDE(glib/gthread.h)
  #pragma P_GLIB_INCLUDE(glib/gthreadpool.h)
  #pragma P_GLIB_INCLUDE(glib/gtimer.h)
  #pragma P_GLIB_INCLUDE(glib/gtree.h)
  #pragma P_GLIB_INCLUDE(glib/gtypes.h)
  #pragma P_GLIB_INCLUDE(glib/gunicode.h)
  #pragma P_GLIB_INCLUDE(glib/gurifuncs.h)
  #pragma P_GLIB_INCLUDE(glib/gutils.h)
  #pragma P_GLIB_INCLUDE(glib/gvarianttype.h)
  #pragma P_GLIB_INCLUDE(glib/gvariant.h)
  #pragma P_GLIB_INCLUDE(glib/gwin32.h)
  #pragma P_GLIB_INCLUDE(glib/gversionmacros.h)
  #pragma P_GLIB_INCLUDE(glib/gbytes.h)
  #pragma P_GLIB_INCLUDE(glib/gcharset.h)
  #pragma P_GLIB_INCLUDE(glib/gdatetime.h)
  #pragma P_GLIB_INCLUDE(glib/gtimezone.h)
  #pragma P_GLIB_INCLUDE(glib/genviron.h)
  #pragma P_GLIB_INCLUDE(glib/ggettext.h)
  #pragma P_GLIB_INCLUDE(glib/ghmac.h)
  #pragma P_GLIB_INCLUDE(glib/gstringchunk.h)
  #pragma P_GLIB_INCLUDE(glib/gtrashstack.h)
  #pragma P_GLIB_INCLUDE(glib/gversion.h)
  #pragma P_GLIB_INCLUDE(glib/deprecated/gallocator.h)
  #pragma P_GLIB_INCLUDE(glib/deprecated/gcache.h)
  #pragma P_GLIB_INCLUDE(glib/deprecated/gcompletion.h)
  #pragma P_GLIB_INCLUDE(glib/deprecated/gmain.h)
  #pragma P_GLIB_INCLUDE(glib/deprecated/grel.h)
  #pragma P_GLIB_INCLUDE(glib/deprecated/gthread.h)
  #pragma P_GLIB_INCLUDE(glib/glib-autocleanups.h)

  #pragma P_GLIB_INCLUDE(gio/gio.h)
  #pragma P_GLIB_INCLUDE(gio/giotypes.h)
  #pragma P_GLIB_INCLUDE(gio/gioenums.h)
  #pragma P_GLIB_INCLUDE(gio/gaction.h)
  #pragma P_GLIB_INCLUDE(gio/gactiongroup.h)
  #pragma P_GLIB_INCLUDE(gio/gactiongroupexporter.h)
  #pragma P_GLIB_INCLUDE(gio/gactionmap.h)
  #pragma P_GLIB_INCLUDE(gio/gappinfo.h)
  #pragma P_GLIB_INCLUDE(gio/gapplication.h)
  #pragma P_GLIB_INCLUDE(gio/gapplicationcommandline.h)
  #pragma P_GLIB_INCLUDE(gio/gasyncinitable.h)
  #pragma P_GLIB_INCLUDE(gio/gasyncresult.h)
  #pragma P_GLIB_INCLUDE(gio/gbufferedinputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gbufferedoutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gbytesicon.h)
  #pragma P_GLIB_INCLUDE(gio/gcancellable.h)
  #pragma P_GLIB_INCLUDE(gio/gcharsetconverter.h)
  #pragma P_GLIB_INCLUDE(gio/gcontenttype.h)
  #pragma P_GLIB_INCLUDE(gio/gconverter.h)
  #pragma P_GLIB_INCLUDE(gio/gconverterinputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gconverteroutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gcredentials.h)
  #pragma P_GLIB_INCLUDE(gio/gdatainputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gdataoutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusaddress.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusauthobserver.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gdbuserror.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusintrospection.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusmessage.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusmethodinvocation.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusnameowning.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusnamewatching.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusproxy.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusserver.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusutils.h)
  #pragma P_GLIB_INCLUDE(gio/gdrive.h)
  #pragma P_GLIB_INCLUDE(gio/gemblemedicon.h)
  #pragma P_GLIB_INCLUDE(gio/gfileattribute.h)
  #pragma P_GLIB_INCLUDE(gio/gfileenumerator.h)
  #pragma P_GLIB_INCLUDE(gio/gfile.h)
  #pragma P_GLIB_INCLUDE(gio/gfileicon.h)
  #pragma P_GLIB_INCLUDE(gio/gfileinfo.h)
  #pragma P_GLIB_INCLUDE(gio/gfileinputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gfileiostream.h)
  #pragma P_GLIB_INCLUDE(gio/gfilemonitor.h)
  #pragma P_GLIB_INCLUDE(gio/gfilenamecompleter.h)
  #pragma P_GLIB_INCLUDE(gio/gfileoutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gfilterinputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gfilteroutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gicon.h)
  #pragma P_GLIB_INCLUDE(gio/ginetaddress.h)
  #pragma P_GLIB_INCLUDE(gio/ginetaddressmask.h)
  #pragma P_GLIB_INCLUDE(gio/ginetsocketaddress.h)
  #pragma P_GLIB_INCLUDE(gio/ginitable.h)
  #pragma P_GLIB_INCLUDE(gio/ginputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gioenums.h)
  #pragma P_GLIB_INCLUDE(gio/gioenumtypes.h)
  #pragma P_GLIB_INCLUDE(gio/gioerror.h)
  #pragma P_GLIB_INCLUDE(gio/giomodule.h)
  #pragma P_GLIB_INCLUDE(gio/gioscheduler.h)
  #pragma P_GLIB_INCLUDE(gio/giostream.h)
  #pragma P_GLIB_INCLUDE(gio/gloadableicon.h)
  #pragma P_GLIB_INCLUDE(gio/gmemoryinputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gmemoryoutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gmount.h)
  #pragma P_GLIB_INCLUDE(gio/gmountoperation.h)
  #pragma P_GLIB_INCLUDE(gio/gnativevolumemonitor.h)
  #pragma P_GLIB_INCLUDE(gio/gnetworkaddress.h)
  #pragma P_GLIB_INCLUDE(gio/gnetworkmonitor.h)
  #pragma P_GLIB_INCLUDE(gio/gnetworkservice.h)
  #pragma P_GLIB_INCLUDE(gio/goutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gpermission.h)
  #pragma P_GLIB_INCLUDE(gio/gpollableinputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gpollableoutputstream.h)
  #pragma P_GLIB_INCLUDE(gio/gpollableutils.h)
  #pragma P_GLIB_INCLUDE(gio/gpropertyaction.h)
  #pragma P_GLIB_INCLUDE(gio/gproxy.h)
  #pragma P_GLIB_INCLUDE(gio/gproxyaddress.h)
  #pragma P_GLIB_INCLUDE(gio/gproxyaddressenumerator.h)
  #pragma P_GLIB_INCLUDE(gio/gproxyresolver.h)
  #pragma P_GLIB_INCLUDE(gio/gresolver.h)
  #pragma P_GLIB_INCLUDE(gio/gresource.h)
  #pragma P_GLIB_INCLUDE(gio/gseekable.h)
  #pragma P_GLIB_INCLUDE(gio/gsettingsschema.h)
  #pragma P_GLIB_INCLUDE(gio/gsettings.h)
  #pragma P_GLIB_INCLUDE(gio/gsimpleaction.h)
  #pragma P_GLIB_INCLUDE(gio/gsimpleactiongroup.h)
  #pragma P_GLIB_INCLUDE(gio/gsimpleasyncresult.h)
  #pragma P_GLIB_INCLUDE(gio/gsimpleiostream.h)
  #pragma P_GLIB_INCLUDE(gio/gsimplepermission.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketaddressenumerator.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketaddress.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketclient.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketconnectable.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketcontrolmessage.h)
  #pragma P_GLIB_INCLUDE(gio/gsocket.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketlistener.h)
  #pragma P_GLIB_INCLUDE(gio/gsocketservice.h)
  #pragma P_GLIB_INCLUDE(gio/gsrvtarget.h)
  #pragma P_GLIB_INCLUDE(gio/gsimpleproxyresolver.h)
  #pragma P_GLIB_INCLUDE(gio/gtask.h)
  #pragma P_GLIB_INCLUDE(gio/gsubprocess.h)
  #pragma P_GLIB_INCLUDE(gio/gsubprocesslauncher.h)
  #pragma P_GLIB_INCLUDE(gio/gtcpconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gtcpwrapperconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gtestdbus.h)
  #pragma P_GLIB_INCLUDE(gio/gthemedicon.h)
  #pragma P_GLIB_INCLUDE(gio/gthreadedsocketservice.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsbackend.h)
  #pragma P_GLIB_INCLUDE(gio/gtlscertificate.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsclientconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsdatabase.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsfiledatabase.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsinteraction.h)
  #pragma P_GLIB_INCLUDE(gio/gtlsserverconnection.h)
  #pragma P_GLIB_INCLUDE(gio/gtlspassword.h)
  #pragma P_GLIB_INCLUDE(gio/gvfs.h)
  #pragma P_GLIB_INCLUDE(gio/gvolume.h)
  #pragma P_GLIB_INCLUDE(gio/gvolumemonitor.h)
  #pragma P_GLIB_INCLUDE(gio/gzlibcompressor.h)
  #pragma P_GLIB_INCLUDE(gio/gzlibdecompressor.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusinterface.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusinterfaceskeleton.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusobject.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusobjectskeleton.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusobjectproxy.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusobjectmanager.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusobjectmanagerclient.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusobjectmanagerserver.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusactiongroup.h)
  #pragma P_GLIB_INCLUDE(gio/gremoteactiongroup.h)
  #pragma P_GLIB_INCLUDE(gio/gmenumodel.h)
  #pragma P_GLIB_INCLUDE(gio/gmenu.h)
  #pragma P_GLIB_INCLUDE(gio/gmenuexporter.h)
  #pragma P_GLIB_INCLUDE(gio/gdbusmenumodel.h)
  #pragma P_GLIB_INCLUDE(gio/gnotification.h)
  #pragma P_GLIB_INCLUDE(gio/glistmodel.h)
  #pragma P_GLIB_INCLUDE(gio/gliststore.h)
  #pragma P_GLIB_INCLUDE(gio/gio-autocleanups.h)
  #pragma P_GLIB_INCLUDE(gio/gemblem.h)
  #ifdef P_GIO_INCLUDE
  #endif

  #pragma P_GLIB_INCLUDE(gobject/gbinding.h)
  #pragma P_GLIB_INCLUDE(gobject/gboxed.h)
  #pragma P_GLIB_INCLUDE(gobject/genums.h)
  #pragma P_GLIB_INCLUDE(gobject/gobject.h)
  #pragma P_GLIB_INCLUDE(gobject/gparam.h)
  #pragma P_GLIB_INCLUDE(gobject/gparamspecs.h)
  #pragma P_GLIB_INCLUDE(gobject/gsignal.h)
  #pragma P_GLIB_INCLUDE(gobject/gsourceclosure.h)
  #pragma P_GLIB_INCLUDE(gobject/gtype.h)
  #pragma P_GLIB_INCLUDE(gobject/gtypemodule.h)
  #pragma P_GLIB_INCLUDE(gobject/gtypeplugin.h)
  #pragma P_GLIB_INCLUDE(gobject/gvalue.h)
  #pragma P_GLIB_INCLUDE(gobject/gvaluearray.h)
  #pragma P_GLIB_INCLUDE(gobject/gvaluetypes.h)
  #pragma P_GLIB_INCLUDE(gobject/gclosure.h)
  #pragma P_GLIB_INCLUDE(gobject/gmarshal.h)
  #pragma P_GLIB_INCLUDE(gobject/glib-types.h)
  #pragma P_GLIB_INCLUDE(gobject/gobject-autocleanups.h)
  
  #pragma P_LIBXML_INCLUDE(libxml/parser.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlversion.h)
  #pragma P_LIBXML_INCLUDE(libxml/list.h)
  #pragma P_LIBXML_INCLUDE(libxml/tree.h)
  #pragma P_LIBXML_INCLUDE(libxml/dict.h)
  #pragma P_LIBXML_INCLUDE(libxml/hash.h)
  #pragma P_LIBXML_INCLUDE(libxml/valid.h)
  #pragma P_LIBXML_INCLUDE(libxml/entities.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlerror.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlstring.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlexports.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlregexp.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlautomata.h)
  #pragma P_LIBXML_INCLUDE(libxml/encoding.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlIO.h)
  #pragma P_LIBXML_INCLUDE(libxml/globals.h)
  #pragma P_LIBXML_INCLUDE(libxml/SAX.h)
  #pragma P_LIBXML_INCLUDE(libxml/SAX2.h)
  #pragma P_LIBXML_INCLUDE(libxml/xmlmemory.h)
  #pragma P_LIBXML_INCLUDE(libxml/xlink.h)
  #pragma P_LIBXML_INCLUDE(libxml/threads.h)

  #define P_GSTREAMER_LIBRARY P_GSTREAMER_DIRSTR"/lib/gstreamer-"P_GSTREAMER_VERSTR".lib"
  #define P_GST_APP_LIBRARY   P_GSTREAMER_DIRSTR"/lib/gstapp-"P_GSTREAMER_VERSTR".lib"
  #define P_GOBJECT_LIBRARY   P_GSTREAMER_DIRSTR"/lib/gobject-2.0.lib"
  #define P_GLIB_LIBRARY      P_GSTREAMER_DIRSTR"/lib/glib-2.0.lib"
  #define P_GIO_LIBRARY       P_GSTREAMER_DIRSTR"/lib/gio-2.0.lib"
#endif


/////////////////////////////////////////////////
//
// COM/DCOM Support (Windows only)
//

#if defined(_WIN32) || (_WIN32_WCE > 0x500)

  #if defined(_WIN32)
    #define _WIN32_DCOM 1
  #endif

  #if defined(_WIN32_WCE) && !defined(_CE_DCOM)
    #ifndef _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA
      #define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA  1
    #endif
  #endif

  #define P_WIN_COM

#endif 


#endif // PTLIB_BUILDOPTS_H


// End Of File ///////////////////////////////////////////////////////////////

