// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 2.1
import org.kde.plasma.components 2.0 as PlasmaComponents

PlasmaComponents.Page {
    id: storySelector

    property variant model

    signal storyClicked(string page, variant propertys)

    anchors.fill: parent

    PlasmaComponents.BusyIndicator {
        running: visible
        visible: model.loading

        anchors.centerIn: parent
    }

    ListView {
        id: infoView
        model: storySelector.model
        delegate: InfoDelegate {
            id: infoDelegate

            title: model.title
            story: model.story
            storyIcon: model.icon ? model.icon : "" // silences undefined warning; TODO: wait with loading until model is actually available

            Component.onCompleted: storyClicked.connect(storySelector.storyClicked)
        }

        clip: true

        visible: !model.loading

        anchors {
            left: parent.left
            right: parent.right
            rightMargin: scrollBar.visible ? scrollBar.width + 3 : 0
            top: parent.top
            bottom: parent.bottom
        }
    }

    PlasmaComponents.ScrollBar {
        id: scrollBar
        flickableItem: infoView

        anchors { right: parent.right; top: parent.top; bottom: parent.bottom }
    }
}
