/*
    Chakra Welcome - Plasmoid,
    a Plasmoid to welcome a user in the Chakra Desktop

    Copyright (C) 2012  Johannes Troescher troscherj@gmail.com

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 2.1
import org.kde.plasma.components 2.0 as PlasmaComponents

PlasmaComponents.PageStack {
    property alias model: browse.model

    initialPage: StorySelectionPage { id: browse }

    Connections {
        target: currentPage

        // we connect to both the InfoPage (defines onStoryClicked) and the StorySelectionPage (defines onBackClicked)
        // as one signal is always undefined, we would create warnings
        // to prevent this, we set ignoreUnknownSignals
        ignoreUnknownSignals: true

        // for PackageInfoPage
        onBackClicked: pop()

        // for BrowsePackagesPage
        onStoryClicked: push(page, propertys)
    }
}
