/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.AbstractLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.VariablesCollection;
import org.libreoffice.report.pentaho.model.FormattedTextElement;

public class VariablesDeclarationLayoutController
extends AbstractLayoutController {
    private boolean processed;

    private OfficeRepeatingStructureLayoutController getRepeatingParent() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OfficeRepeatingStructureLayoutController)) continue;
            return (OfficeRepeatingStructureLayoutController)parent;
        }
        return null;
    }

    @Override
    public LayoutController advance(ReportTarget target) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        if (this.processed) {
            throw new IllegalStateException("Already processed.");
        }
        VariablesDeclarationLayoutController vlc = (VariablesDeclarationLayoutController)this.clone();
        vlc.processed = true;
        OfficeRepeatingStructureLayoutController orslc = this.getRepeatingParent();
        if (orslc == null) {
            return vlc;
        }
        VariablesCollection collection = orslc.getVariablesCollection();
        if (collection.getVariablesCount() == 0) {
            return vlc;
        }
        Element node = (Element)this.getNode();
        AttributeMap vdSection = node.getAttributeMap();
        target.startElement(vdSection);
        FormattedTextElement[] variables = collection.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            FormattedTextElement variable = variables[i];
            String varName = collection.getNamePrefix() + (i + 1);
            AttributeMap map = this.generateVariableSetSection(variable);
            map.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", (Object)varName);
            target.startElement(map);
            target.endElement(map);
        }
        target.endElement(vdSection);
        return vlc;
    }

    private AttributeMap generateVariableSetSection(FormattedTextElement variable) throws DataSourceException {
        AttributeMap variableSection = new AttributeMap();
        variableSection.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        variableSection.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"variable-set");
        variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "display", (Object)"none");
        FormulaExpression valueExpression = variable.getValueExpression();
        Object value = LayoutControllerUtil.evaluateExpression(this.getFlowController(), variable, valueExpression);
        String formula = FormatValueUtility.applyValueForVariable(value, variableSection);
        if (formula == null) {
            formula = "" + value;
        }
        if (value instanceof java.sql.Date) {
            Date date = (Date)value;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy;MM;dd");
            formula = "Date(" + dateFormat.format(date) + ")";
        }
        variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "formula", (Object)("ooow:" + formula));
        return variableSection;
    }

    @Override
    public boolean isAdvanceable() {
        return !this.processed;
    }

    @Override
    public LayoutController join(FlowController flowController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        throw new UnsupportedOperationException("Join is not supported in this layout controller");
    }
}

