/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.chart;

import java.io.IOException;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.output.OfficeDocumentReportTarget;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ChartRawReportTarget
extends OfficeDocumentReportTarget {
    private boolean inFilterElements = false;
    private boolean tableRowsStarted = false;
    private int tableCount = 0;
    private int closeTags = 0;

    public ChartRawReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey baseResource, InputRepository inputRepository, OutputRepository outputRepository, String target, ImageService imageService, DataSourceFactory dataSourceFactory) throws ReportProcessingException {
        super(reportJob, resourceManager, baseResource, inputRepository, outputRepository, target, imageService, dataSourceFactory);
    }

    @Override
    protected String getTargetMimeType() {
        return "application/vnd.oasis.opendocument.chart";
    }

    private String getStartContent() {
        return "chart";
    }

    @Override
    public String getExportDescriptor() {
        return "raw/application/vnd.oasis.opendocument.chart";
    }

    @Override
    protected void startContent(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        this.inFilterElements = false;
        this.closeTags = 0;
        this.tableCount = 0;
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", this.getStartContent(), null, false);
        this.writeNullDate();
        ++this.closeTags;
    }

    @Override
    protected void endContent(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        XmlWriter xmlWriter = this.getXmlWriter();
        while (this.closeTags > 0) {
            xmlWriter.writeCloseTag();
            --this.closeTags;
        }
    }

    @Override
    protected void startReportSection(AttributeMap attrs, int role) throws ReportProcessingException {
    }

    @Override
    protected void endReportSection(AttributeMap attrs, int role) {
    }

    @Override
    protected void startOther(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        if (!this.isFilteredNamespace(namespace)) {
            String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
            try {
                this.processElement(attrs, namespace, elementType);
            }
            catch (IOException e) {
                throw new ReportProcessingException("Failed", e);
            }
        }
    }

    private boolean isFiltered(String elementType) {
        return "table-header-columns".equals(elementType) || "table-header-rows".equals(elementType) || "table-columns".equals(elementType);
    }

    @Override
    protected void endOther(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        if (this.tableRowsStarted && this.getCurrentRole() == 11) {
            return;
        }
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        if (this.isFilteredNamespace(namespace)) {
            return;
        }
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(namespace)) {
            if ("table".equals(elementType) || "table-rows".equals(elementType)) {
                return;
            }
            if (this.isFiltered(elementType)) {
                this.inFilterElements = false;
                if (this.tableCount > 1) {
                    return;
                }
            }
        } else if ("urn:oasis:names:tc:opendocument:xmlns:chart:1.0".equals(namespace) && "chart".equals(elementType)) {
            return;
        }
        if (this.inFilterElements && this.tableCount > 1) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeCloseTag();
        --this.closeTags;
    }

    @Override
    public void processContent(DataFlags value) throws DataSourceException, ReportProcessingException {
        if (!this.tableRowsStarted || this.getCurrentRole() != 11) {
            super.processContent(value);
        }
    }

    private void processElement(AttributeMap attrs, String namespace, String elementType) throws IOException, ReportProcessingException {
        if (this.tableRowsStarted && this.getCurrentRole() == 11) {
            return;
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(namespace)) {
            if ("table".equals(elementType)) {
                ++this.tableCount;
                if (this.tableCount > 1) {
                    return;
                }
            } else if ("table-rows".equals(elementType)) {
                if (this.tableCount > 1) {
                    return;
                }
                this.tableRowsStarted = true;
            } else if (this.isFiltered(elementType)) {
                this.inFilterElements = true;
                if (this.tableCount > 1) {
                    return;
                }
            }
        }
        if (this.inFilterElements && this.tableCount > 1) {
            return;
        }
        this.performStyleProcessing(attrs);
        AttributeList attrList = this.buildAttributeList(attrs);
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag(namespace, elementType, attrList, false);
        ++this.closeTags;
    }

    @Override
    public void processText(String text) throws DataSourceException, ReportProcessingException {
        if (this.inFilterElements && this.tableCount > 1) {
            return;
        }
        super.processText(text);
    }

    @Override
    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        super.endReport(report);
        this.copyMeta();
    }
}

