/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class JavaClassOnCompanionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor) || Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName().asString(), "javaClass") ^ true) {
            return;
        }
        DeclarationDescriptor container2 = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        if (!(container2 instanceof PackageFragmentDescriptor) || Intrinsics.areEqual(((PackageFragmentDescriptor)container2).getFqName().asString(), "kotlin.jvm") ^ true) {
            return;
        }
        KotlinType actualType = ((PropertyDescriptor)descriptor2).getType();
        Object object = CollectionsKt.singleOrNull(actualType.getArguments());
        if (!((object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor companionObject = classDescriptor;
        if (companionObject.isCompanionObject()) {
            DeclarationDescriptor declarationDescriptor = companionObject.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
            ClassifierDescriptor classifierDescriptor2 = actualType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor2;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor javaLangClass = classDescriptor2;
            List<TypeProjectionImpl> arguments2 = CollectionsKt.listOf(new TypeProjectionImpl(containingClass.getDefaultType()));
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            TypeConstructor typeConstructor2 = javaLangClass.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "javaLangClass.typeConstructor");
            SimpleType expectedType = KotlinTypeFactory.simpleType$default(annotations2, typeConstructor2, arguments2, actualType.isMarkedNullable(), null, 16, null);
            context.getTrace().report(ErrorsJvm.JAVA_CLASS_ON_COMPANION.on(reportOn, actualType, expectedType));
        }
    }
}

