/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasCondition;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatchScope;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsCatch
extends SourceInfoAwareJsNode
implements HasCondition {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(JsScope parent2, @NotNull String ident) {
        if (ident == null) {
            JsCatch.$$$reportNull$$$0(0);
        }
        assert (parent2 != null);
        this.scope = new JsCatchScope(parent2, ident);
        this.param = new JsParameter(this.scope.findName(ident));
    }

    public JsCatch(JsScope parent2, @NotNull String ident, @NotNull JsStatement catchBody) {
        if (ident == null) {
            JsCatch.$$$reportNull$$$0(1);
        }
        if (catchBody == null) {
            JsCatch.$$$reportNull$$$0(2);
        }
        this(parent2, ident);
        this.body = catchBody instanceof JsBlock ? (JsBlock)catchBody : new JsBlock(catchBody);
    }

    public JsBlock getBody() {
        return this.body;
    }

    @Override
    public JsExpression getCondition() {
        return this.condition;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    @Override
    public void setCondition(JsExpression condition) {
        this.condition = condition;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitCatch(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.param);
        if (this.condition != null) {
            visitor2.accept(this.condition);
        }
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.param = v.accept(this.param);
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsCatch deepCopy() {
        JsCatchScope scopeCopy = this.scope.copy();
        JsBlock bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsParameter paramCopy = AstUtil.deepCopy(this.param);
        JsCatch jsCatch = new JsCatch(scopeCopy, bodyCopy, conditionCopy, paramCopy).withMetadataFrom(this);
        if (jsCatch == null) {
            JsCatch.$$$reportNull$$$0(3);
        }
        return jsCatch;
    }

    private JsCatch(JsCatchScope scope, JsBlock body, JsExpression condition, JsParameter param) {
        this.scope = scope;
        this.body = body;
        this.condition = condition;
        this.param = param;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ident";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchBody";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsCatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsCatch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

